/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchScope;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean typesOnly;
    private DereferencePolicy dereferencePolicy;
    private ASN1OctetString baseDN;
    private int sizeLimit;
    private int timeLimit;
    private LDAPFilter filter;
    private LinkedHashSet<String> attributes;
    private SearchScope scope;

    public SearchRequestProtocolOp(ASN1OctetString baseDN, SearchScope scope, DereferencePolicy dereferencePolicy, int sizeLimit, int timeLimit, boolean typesOnly, LDAPFilter filter, LinkedHashSet<String> attributes) {
        this.baseDN = baseDN;
        this.scope = scope;
        this.dereferencePolicy = dereferencePolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.filter = filter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
    }

    public ASN1OctetString getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(ASN1OctetString baseDN) {
        this.baseDN = baseDN;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    public void setDereferencePolicy(DereferencePolicy dereferencePolicy) {
        this.dereferencePolicy = dereferencePolicy;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public LDAPFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LDAPFilter filter) {
        this.filter = filter;
    }

    public LinkedHashSet<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedHashSet<String> attributes) {
        if (attributes == null) {
            this.attributes.clear();
        } else {
            this.attributes = attributes;
        }
    }

    @Override
    public byte getType() {
        return 99;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Request";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(8);
        elements.add(this.baseDN);
        elements.add(new ASN1Enumerated(this.scope.intValue()));
        elements.add(new ASN1Enumerated(this.dereferencePolicy.intValue()));
        elements.add(new ASN1Integer(this.sizeLimit));
        elements.add(new ASN1Integer(this.timeLimit));
        elements.add(new ASN1Boolean(this.typesOnly));
        elements.add(this.filter.encode());
        ArrayList<ASN1Element> attrElements = new ArrayList<ASN1Element>(this.attributes.size());
        for (String attribute : this.attributes) {
            attrElements.add(new ASN1OctetString(attribute));
        }
        elements.add(new ASN1Sequence(attrElements));
        return new ASN1Sequence(99, elements);
    }

    public static SearchRequestProtocolOp decodeSearchRequest(ASN1Element element) throws LDAPException {
        LinkedHashSet<String> attributes;
        LDAPFilter filter;
        boolean typesOnly;
        int timeLimit;
        int sizeLimit;
        DereferencePolicy dereferencePolicy;
        SearchScope scope;
        ASN1OctetString baseDN;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements != 8) {
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            baseDN = elements.get(0).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_BASE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            switch (elements.get(1).decodeAsEnumerated().intValue()) {
                case 0: {
                    scope = SearchScope.BASE_OBJECT;
                    break;
                }
                case 1: {
                    scope = SearchScope.SINGLE_LEVEL;
                    break;
                }
                case 2: {
                    scope = SearchScope.WHOLE_SUBTREE;
                    break;
                }
                case 3: {
                    scope = SearchScope.SUBORDINATE_SUBTREE;
                    break;
                }
                default: {
                    int scopeValue = elements.get(1).decodeAsEnumerated().intValue();
                    Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_SCOPE.get(scopeValue);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SCOPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            switch (elements.get(2).decodeAsEnumerated().intValue()) {
                case 0: {
                    dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
                    break;
                }
                case 1: {
                    dereferencePolicy = DereferencePolicy.DEREF_IN_SEARCHING;
                    break;
                }
                case 2: {
                    dereferencePolicy = DereferencePolicy.DEREF_FINDING_BASE_OBJECT;
                    break;
                }
                case 3: {
                    dereferencePolicy = DereferencePolicy.DEREF_ALWAYS;
                    break;
                }
                default: {
                    int derefValue = elements.get(2).decodeAsEnumerated().intValue();
                    Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_DEREF.get(derefValue);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_DEREF.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            sizeLimit = elements.get(3).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_SIZE_LIMIT.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            timeLimit = elements.get(4).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_TIME_LIMIT.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            typesOnly = elements.get(5).decodeAsBoolean().booleanValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_TYPES_ONLY.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            filter = LDAPFilter.decode(elements.get(6));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_FILTER.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            ArrayList<ASN1Element> attrElements = elements.get(7).decodeAsSequence().elements();
            attributes = new LinkedHashSet<String>(attrElements.size());
            for (ASN1Element e : attrElements) {
                attributes.add(e.decodeAsOctetString().stringValue());
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_ATTRIBUTES.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new SearchRequestProtocolOp(baseDN, scope, dereferencePolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchRequest(baseDN=");
        this.baseDN.toString(buffer);
        buffer.append(", scope=");
        buffer.append(String.valueOf((Object)this.scope));
        buffer.append(", derefPolicy=");
        buffer.append(String.valueOf((Object)this.dereferencePolicy));
        buffer.append(", sizeLimit=");
        buffer.append(this.sizeLimit);
        buffer.append(", timeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(", typesOnly=");
        buffer.append(this.typesOnly);
        buffer.append(", filter=");
        this.filter.toString(buffer);
        buffer.append(", attributes={");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Iterator iterator = this.attributes.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append((String)iterator.next());
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Base DN:  ");
        this.baseDN.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Scope:  ");
        buffer.append(String.valueOf((Object)this.scope));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Dereference Policy:  ");
        buffer.append(String.valueOf((Object)this.dereferencePolicy));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Size Limit:  ");
        buffer.append(this.sizeLimit);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Time Limit:  ");
        buffer.append(this.timeLimit);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Types Only:  ");
        buffer.append(this.typesOnly);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Filter:  ");
        this.filter.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        if (this.attributes != null) {
            for (String attribute : this.attributes) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("    ");
                buffer.append(attribute);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

