/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.util.ServerConstants;

public class LDAPModification
extends RawModification {
    private ModificationType modificationType;
    private RawAttribute attribute;

    public LDAPModification(ModificationType modificationType, RawAttribute attribute) {
        this.modificationType = modificationType;
        this.attribute = attribute;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public void setModificationType(ModificationType modificationType) {
        this.modificationType = modificationType;
    }

    public RawAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(RawAttribute attribute) {
        this.attribute = attribute;
    }

    public Modification toModification() throws LDAPException {
        return new Modification(this.modificationType, this.attribute.toAttribute());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPModification(type=");
        buffer.append(String.valueOf((Object)this.modificationType));
        buffer.append(", attr=");
        this.attribute.toString(buffer);
        buffer.append("})");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Modification");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Modification Type:  ");
        buffer.append(String.valueOf((Object)this.modificationType));
        buffer.append(" (");
        buffer.append(this.modificationType.intValue());
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attribute:");
        buffer.append(ServerConstants.EOL);
        this.attribute.toString(buffer, indent + 4);
    }
}

