/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;

public class DirectoryRMIServerSocketFactory
implements RMIServerSocketFactory {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SSLSocketFactory sslSocketFactory = null;
    private final boolean needClientCertificate;

    public DirectoryRMIServerSocketFactory(SSLSocketFactory sslSocketFactory, boolean needClientCertificate) {
        this.needClientCertificate = needClientCertificate;
        this.sslSocketFactory = sslSocketFactory;
    }

    public final boolean getNeedClientCertificate() {
        return this.needClientCertificate;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, 0, InetAddress.getByName("0.0.0.0")){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("host/port: %s/%d", socket.getInetAddress().getHostName(), socket.getPort());
                }
                SSLSocket sslSocket = (SSLSocket)DirectoryRMIServerSocketFactory.this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                sslSocket.setNeedClientAuth(DirectoryRMIServerSocketFactory.this.needClientCertificate);
                return sslSocket;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DirectoryRMIServerSocketFactory)) {
            return false;
        }
        DirectoryRMIServerSocketFactory that = (DirectoryRMIServerSocketFactory)obj;
        return this.getClass().equals(that.getClass()) && this.checkParameters(that);
    }

    private boolean checkParameters(DirectoryRMIServerSocketFactory that) {
        if (this.needClientCertificate != that.needClientCertificate) {
            return false;
        }
        return this.sslSocketFactory.equals(that.sslSocketFactory);
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.needClientCertificate ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + this.sslSocketFactory.hashCode();
    }
}

