/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import org.opends.server.protocols.internal.InternalLDAPSocket;
import org.opends.server.protocols.internal.NullLDAPMessage;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class InternalLDAPInputStream
extends InputStream {
    private ArrayBlockingQueue<LDAPMessage> messageQueue;
    private boolean closed;
    private ByteBuffer partialMessageBuffer;
    private InternalLDAPSocket socket;

    public InternalLDAPInputStream(InternalLDAPSocket socket) {
        this.socket = socket;
        this.messageQueue = new ArrayBlockingQueue(10);
        this.partialMessageBuffer = null;
        this.closed = false;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void addLDAPMessage(LDAPMessage message) {
        if (this.closed) {
            return;
        }
        try {
            this.messageQueue.put(message);
            return;
        }
        catch (Exception e) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.messageQueue.put(message);
                    break;
                }
                catch (Exception e2) {
                    continue;
                }
            }
            return;
        }
    }

    public synchronized int available() {
        if (this.partialMessageBuffer == null) {
            LDAPMessage message = this.messageQueue.poll();
            if (message == null || message instanceof NullLDAPMessage) {
                if (message instanceof NullLDAPMessage) {
                    this.closed = true;
                }
                return 0;
            }
            this.partialMessageBuffer = ByteBuffer.wrap(message.encode().encode());
            return this.partialMessageBuffer.remaining();
        }
        return this.partialMessageBuffer.remaining();
    }

    public void close() {
        this.socket.close();
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void closeInternal() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        NullLDAPMessage nullMessage = new NullLDAPMessage();
        while (!this.messageQueue.offer(nullMessage)) {
            this.messageQueue.clear();
        }
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.partialMessageBuffer != null) {
            if (this.partialMessageBuffer.remaining() > 0) {
                int i = 0xFF & this.partialMessageBuffer.get();
                if (this.partialMessageBuffer.remaining() == 0) {
                    this.partialMessageBuffer = null;
                }
                return i;
            }
            this.partialMessageBuffer = null;
        }
        if (this.closed) {
            return -1;
        }
        try {
            LDAPMessage message = this.messageQueue.take();
            if (message instanceof NullLDAPMessage) {
                this.messageQueue.clear();
                this.closed = true;
                return -1;
            }
            this.partialMessageBuffer = ByteBuffer.wrap(message.encode().encode());
            return 0xFF & this.partialMessageBuffer.get();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.partialMessageBuffer != null) {
            int remaining = this.partialMessageBuffer.remaining();
            if (remaining > 0) {
                if (remaining <= len) {
                    this.partialMessageBuffer.get(b, off, remaining);
                    this.partialMessageBuffer = null;
                    return remaining;
                }
                this.partialMessageBuffer.get(b, off, len);
                return len;
            }
            this.partialMessageBuffer = null;
        }
        if (this.closed) {
            return -1;
        }
        try {
            LDAPMessage message = this.messageQueue.take();
            if (message instanceof NullLDAPMessage) {
                this.messageQueue.clear();
                this.closed = true;
                return -1;
            }
            byte[] encodedMessage = message.encode().encode();
            if (encodedMessage.length <= len) {
                System.arraycopy(encodedMessage, 0, b, off, encodedMessage.length);
                return encodedMessage.length;
            }
            System.arraycopy(encodedMessage, 0, b, off, len);
            this.partialMessageBuffer = ByteBuffer.wrap(encodedMessage);
            this.partialMessageBuffer.position(len);
            return len;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void reset() {
    }

    public synchronized long skip(long n) throws IOException {
        long totalBytesRead;
        int bytesRead;
        byte[] b = n > 8192L ? new byte[8192] : new byte[(int)n];
        for (totalBytesRead = 0L; totalBytesRead < n; totalBytesRead += (long)bytesRead) {
            int maxLen = (int)Math.min(n - totalBytesRead, (long)b.length);
            bytesRead = this.read(b, 0, maxLen);
            if (bytesRead >= 0) continue;
            if (totalBytesRead > 0L) {
                return totalBytesRead;
            }
            return bytesRead;
        }
        return totalBytesRead;
    }

    public String toString() {
        return "InternalLDAPInputStream";
    }
}

