/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ProtocolElement;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1Null;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.types.ByteString;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class ASN1Element
implements ProtocolElement,
Serializable {
    private static final long serialVersionUID = -6085322427222358963L;
    private byte type;
    private byte[] value;

    public ASN1Element(byte type) {
        this.type = type;
        this.value = ASN1Constants.NO_VALUE;
    }

    public ASN1Element(byte type, byte[] value) {
        this.type = type;
        this.value = value == null ? ASN1Constants.NO_VALUE : value;
    }

    public final byte getType() {
        return this.type;
    }

    public final void setType(byte type) {
        this.type = type;
    }

    public final boolean isUniversal() {
        return (this.type & 0xFFFFFFC0) == 0;
    }

    public final boolean isApplicationSpecific() {
        return (this.type & 0xFFFFFFC0) == 64;
    }

    public final boolean isContextSpecific() {
        return (this.type & 0xFFFFFFC0) == -128;
    }

    public final boolean isPrivate() {
        return (this.type & 0xFFFFFFC0) == -64;
    }

    public final boolean isPrimitive() {
        return (this.type & 0x20) == 0;
    }

    public final boolean isConstructed() {
        return (this.type & 0x20) == 32;
    }

    public final byte[] value() {
        return this.value;
    }

    public void setValue(byte[] value) throws ASN1Exception {
        this.value = value == null ? ASN1Constants.NO_VALUE : value;
    }

    protected final void setValueInternal(byte[] value) {
        this.value = value;
    }

    public static byte[] encodeLength(int length) {
        if (length < 128) {
            return new byte[]{(byte)length};
        }
        if ((length & 0xFF) == length) {
            return new byte[]{-127, (byte)(length & 0xFF)};
        }
        if ((length & 0xFFFF) == length) {
            return new byte[]{-126, (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        if ((length & 0xFFFFFF) == length) {
            return new byte[]{-125, (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        return new byte[]{-124, (byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
    }

    public final byte[] encode() {
        if (this.value.length == 0) {
            return new byte[]{this.type, 0};
        }
        if (this.value.length < 128) {
            byte[] encodedElement = new byte[this.value.length + 2];
            encodedElement[0] = this.type;
            encodedElement[1] = (byte)this.value.length;
            System.arraycopy(this.value, 0, encodedElement, 2, this.value.length);
            return encodedElement;
        }
        byte[] encodedLength = ASN1Element.encodeLength(this.value.length);
        byte[] encodedElement = new byte[1 + this.value.length + encodedLength.length];
        encodedElement[0] = this.type;
        System.arraycopy(encodedLength, 0, encodedElement, 1, encodedLength.length);
        System.arraycopy(this.value, 0, encodedElement, 1 + encodedLength.length, this.value.length);
        return encodedElement;
    }

    public static byte[] encodeValue(boolean booleanValue) {
        return booleanValue ? ASN1Constants.BOOLEAN_VALUE_TRUE : ASN1Constants.BOOLEAN_VALUE_FALSE;
    }

    public static byte[] encodeValue(int intValue) {
        if ((intValue & 0x7F) == intValue) {
            return new byte[]{(byte)(intValue & 0xFF)};
        }
        if ((intValue & Short.MAX_VALUE) == intValue) {
            return new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
        }
        if ((intValue & 0x7FFFFF) == intValue) {
            return new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] encodeLongValue(long longValue) {
        if ((longValue & 0x7FL) == longValue) {
            return new byte[]{(byte)(longValue & 0xFFL)};
        }
        if ((longValue & 0x7FFFL) == longValue) {
            return new byte[]{(byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        if ((longValue & 0x7FFFFFL) == longValue) {
            return new byte[]{(byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        if ((longValue & Integer.MAX_VALUE) == longValue) {
            return new byte[]{(byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        if ((longValue & 0x7FFFFFFFFFL) == longValue) {
            return new byte[]{(byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        if ((longValue & 0x7FFFFFFFFFFFL) == longValue) {
            return new byte[]{(byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        if ((longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            return new byte[]{(byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        }
        return new byte[]{(byte)(longValue >> 56 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
    }

    public static byte[] encodeValue(ArrayList<ASN1Element> elements) {
        if (elements == null) {
            return ASN1Constants.NO_VALUE;
        }
        int totalLength = 0;
        byte[][] encodedElements = new byte[elements.size()][];
        for (int i = 0; i < encodedElements.length; ++i) {
            encodedElements[i] = elements.get(i).encode();
            totalLength += encodedElements[i].length;
        }
        byte[] encodedValue = new byte[totalLength];
        int startPos = 0;
        for (byte[] b : encodedElements) {
            System.arraycopy(b, 0, encodedValue, startPos, b.length);
            startPos += b.length;
        }
        return encodedValue;
    }

    public static ASN1Element decode(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_ELEMENT.get();
            throw new ASN1Exception(message);
        }
        if (encodedElement.length < 2) {
            Message message = ProtocolMessages.ERR_ASN1_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        return new ASN1Element(type, value);
    }

    public static ASN1Element decode(byte[] encodedElement, int startPos, int length) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_ELEMENT.get();
            throw new ASN1Exception(message);
        }
        if (startPos < 0 || startPos + length > encodedElement.length || length < 2) {
            Message message = ProtocolMessages.ERR_ASN1_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[startPos];
        int elementLength = encodedElement[startPos + 1] & 0x7F;
        int valueStartPos = startPos + 2;
        if (elementLength != encodedElement[startPos + 1]) {
            int numLengthBytes = elementLength;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (startPos + length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            elementLength = 0;
            valueStartPos = startPos + 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                elementLength = elementLength << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (startPos + length - valueStartPos != elementLength) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(elementLength, startPos + length - valueStartPos);
            throw new ASN1Exception(message);
        }
        byte[] value = new byte[elementLength];
        System.arraycopy(encodedElement, valueStartPos, value, 0, elementLength);
        return new ASN1Element(type, value);
    }

    public final ASN1Boolean decodeAsBoolean() throws ASN1Exception {
        return ASN1Boolean.decodeAsBoolean(this);
    }

    public final ASN1Enumerated decodeAsEnumerated() throws ASN1Exception {
        return ASN1Enumerated.decodeAsEnumerated(this);
    }

    public final ASN1Integer decodeAsInteger() throws ASN1Exception {
        return ASN1Integer.decodeAsInteger(this);
    }

    public final ASN1Long decodeAsLong() throws ASN1Exception {
        return ASN1Long.decodeAsLong(this);
    }

    public final ASN1Null decodeAsNull() throws ASN1Exception {
        return ASN1Null.decodeAsNull(this);
    }

    public final ASN1OctetString decodeAsOctetString() throws ASN1Exception {
        return ASN1OctetString.decodeAsOctetString(this);
    }

    public final ASN1Sequence decodeAsSequence() throws ASN1Exception {
        return ASN1Sequence.decodeAsSequence(this);
    }

    public final ASN1Set decodeAsSet() throws ASN1Exception {
        return ASN1Set.decodeAsSet(this);
    }

    public static ArrayList<ASN1Element> decodeElements(byte[] encodedElements) throws ASN1Exception {
        int length;
        if (encodedElements == null) {
            Message message = ProtocolMessages.ERR_ASN1_ELEMENT_SET_NULL.get();
            throw new ASN1Exception(message);
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>();
        for (int startPos = 0; startPos < encodedElements.length; startPos += length) {
            byte firstLengthByte;
            byte type = encodedElements[startPos++];
            if (startPos >= encodedElements.length) {
                Message message = ProtocolMessages.ERR_ASN1_ELEMENT_SET_NO_LENGTH.get();
                throw new ASN1Exception(message);
            }
            if ((length = (int)((firstLengthByte = encodedElements[startPos++]) & 0x7F)) != firstLengthByte) {
                int numLengthBytes = length;
                if (numLengthBytes > 4) {
                    Message message = ProtocolMessages.ERR_ASN1_ELEMENT_SET_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                    throw new ASN1Exception(message);
                }
                if (numLengthBytes > encodedElements.length - startPos) {
                    Message message = ProtocolMessages.ERR_ASN1_ELEMENT_SET_TRUNCATED_LENGTH.get(numLengthBytes);
                    throw new ASN1Exception(message);
                }
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length = length << 8 | encodedElements[startPos++] & 0xFF;
                }
            }
            if (length > encodedElements.length - startPos) {
                Message message = ProtocolMessages.ERR_ASN1_ELEMENT_SET_TRUNCATED_VALUE.get(length, encodedElements.length - startPos);
                throw new ASN1Exception(message);
            }
            byte[] value = new byte[length];
            System.arraycopy(encodedElements, startPos, value, 0, length);
            elements.add(new ASN1Element(type, value));
        }
        return elements;
    }

    @Override
    public final String getProtocolElementName() {
        return "ASN.1";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ASN1Element)) {
            return false;
        }
        ASN1Element e = (ASN1Element)o;
        return this.type == e.type && Arrays.equals(this.value, e.value);
    }

    public final boolean equalsIgnoreType(ASN1Element element) {
        return Arrays.equals(this.value, element.value);
    }

    public final boolean equalsIgnoreType(ByteString byteString) {
        return Arrays.equals(this.value, byteString.value());
    }

    public final boolean equalsElement(ASN1Element e) {
        if (this == e) {
            return true;
        }
        if (e == null) {
            return false;
        }
        return this.type == e.type && Arrays.equals(this.value, e.value);
    }

    public final int hashCode() {
        int hashCode = this.type;
        int length = Math.min(20, this.value.length);
        for (int i = 0; i < length; ++i) {
            hashCode += this.value[i];
        }
        return hashCode;
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Element(type=");
        buffer.append(StaticUtils.byteToHex(this.type));
        buffer.append(", length=");
        buffer.append(this.value.length);
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Element");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.type));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value (");
        buffer.append(this.value.length);
        buffer.append(" bytes)");
        buffer.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(buffer, this.value, indent + 2);
    }
}

