/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.DebugLogLevel;

public class ProfileStack {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int LINE_NUMBER_UNKNOWN = -1;
    public static final int LINE_NUMBER_NATIVE = -2;
    private int numFrames;
    private int[] lineNumbers;
    private String[] classNames;
    private String[] methodNames;

    public ProfileStack(StackTraceElement[] stackElements) {
        this.numFrames = stackElements.length;
        this.classNames = new String[this.numFrames];
        this.methodNames = new String[this.numFrames];
        this.lineNumbers = new int[this.numFrames];
        int i = 0;
        int j = this.numFrames - 1;
        while (i < this.numFrames) {
            this.classNames[i] = stackElements[j].getClassName();
            this.methodNames[i] = stackElements[j].getMethodName();
            this.lineNumbers[i] = stackElements[j].getLineNumber();
            if (this.lineNumbers[i] <= 0) {
                this.lineNumbers[i] = stackElements[j].isNativeMethod() ? -2 : -1;
            }
            ++i;
            --j;
        }
    }

    private ProfileStack(String[] classNames, String[] methodNames, int[] lineNumbers) {
        this.numFrames = classNames.length;
        this.classNames = classNames;
        this.methodNames = methodNames;
        this.lineNumbers = lineNumbers;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public String getClassName(int depth) {
        return this.classNames[depth];
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public String getMethodName(int depth) {
        return this.methodNames[depth];
    }

    public int[] getLineNumbers() {
        return this.lineNumbers;
    }

    public int getLineNumber(int depth) {
        return this.lineNumbers[depth];
    }

    public int hashCode() {
        if (this.numFrames == 0) {
            return 0;
        }
        return this.classNames[0].hashCode() + this.methodNames[0].hashCode() + this.lineNumbers[0];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            ProfileStack s = (ProfileStack)o;
            if (this.numFrames != s.numFrames) {
                return false;
            }
            for (int i = 0; i < this.numFrames; ++i) {
                if (this.lineNumbers[i] == s.lineNumbers[i] && this.classNames[i].equals(s.classNames[i]) && this.methodNames[i].equals(s.methodNames[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3 * this.numFrames);
        for (int i = 0; i < this.numFrames; ++i) {
            elements.add(new ASN1OctetString(this.classNames[i]));
            elements.add(new ASN1OctetString(this.methodNames[i]));
            elements.add(new ASN1OctetString(String.valueOf(this.lineNumbers[i])));
        }
        return new ASN1Sequence(elements);
    }

    public static ProfileStack decode(ASN1Element stackElement) {
        try {
            ArrayList<ASN1Element> elements = stackElement.decodeAsSequence().elements();
            int numFrames = elements.size() / 3;
            String[] classNames = new String[numFrames];
            String[] methodNames = new String[numFrames];
            int[] lineNumbers = new int[numFrames];
            int i = 0;
            int j = 0;
            while (i < numFrames) {
                classNames[i] = elements.get(j).decodeAsOctetString().stringValue();
                methodNames[i] = elements.get(j + 1).decodeAsOctetString().stringValue();
                lineNumbers[i] = Integer.parseInt(elements.get(j + 2).decodeAsOctetString().stringValue());
                ++i;
                j += 3;
            }
            return new ProfileStack(classNames, methodNames, lineNumbers);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }
    }
}

