/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.admin.std.server.SystemInfoMonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoMonitorProvider
extends MonitorProvider<SystemInfoMonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public SystemInfoMonitorProvider() {
        super("System Info Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(SystemInfoMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "System Information";
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs;
        block8: {
            attrs = new ArrayList<Attribute>(13);
            attrs.add(this.createAttribute("javaVersion", System.getProperty("java.version")));
            attrs.add(this.createAttribute("javaVendor", System.getProperty("java.vendor")));
            attrs.add(this.createAttribute("jvmVersion", System.getProperty("java.vm.version")));
            attrs.add(this.createAttribute("jvmVendor", System.getProperty("java.vm.vendor")));
            attrs.add(this.createAttribute("javaHome", System.getProperty("java.home")));
            attrs.add(this.createAttribute("classPath", System.getProperty("java.class.path")));
            attrs.add(this.createAttribute("workingDirectory", System.getProperty("user.dir")));
            String osInfo = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
            attrs.add(this.createAttribute("operatingSystem", osInfo));
            String sunOsArchDataModel = System.getProperty("sun.arch.data.model");
            if (sunOsArchDataModel != null) {
                String jvmArch = sunOsArchDataModel;
                if (!sunOsArchDataModel.toLowerCase().equals("unknown")) {
                    jvmArch = jvmArch + "-bit";
                }
                attrs.add(this.createAttribute("jvmArchitecture", jvmArch));
            } else {
                attrs.add(this.createAttribute("jvmArchitecture", "unknown"));
            }
            try {
                attrs.add(this.createAttribute("systemName", InetAddress.getLocalHost().getCanonicalHostName()));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        Runtime runtime = Runtime.getRuntime();
        attrs.add(this.createAttribute("availableCPUs", String.valueOf(runtime.availableProcessors())));
        attrs.add(this.createAttribute("maxMemory", String.valueOf(runtime.maxMemory())));
        attrs.add(this.createAttribute("usedMemory", String.valueOf(runtime.totalMemory())));
        attrs.add(this.createAttribute("freeUsedMemory", String.valueOf(runtime.freeMemory())));
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArguments = rtBean.getInputArguments();
        if (jvmArguments != null && !jvmArguments.isEmpty()) {
            StringBuilder argList = new StringBuilder();
            for (String jvmArg : jvmArguments) {
                if (argList.length() > 0) {
                    argList.append(" ");
                }
                argList.append("\"");
                argList.append(jvmArg);
                argList.append("\"");
            }
            attrs.add(this.createAttribute("jvmArguments", argList.toString()));
        }
        return attrs;
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        ASN1OctetString encodedValue = new ASN1OctetString(value);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        try {
            values.add(new AttributeValue(encodedValue, attrType.normalize(encodedValue)));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            values.add(new AttributeValue(encodedValue, (ByteString)encodedValue));
        }
        return new Attribute(attrType, name, values);
    }
}

