/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedAccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAccessLogPublisher
extends AccessLogPublisher<FileBasedAccessLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> {
    private boolean suppressInternalOperations = true;
    private boolean suppressSynchronizationOperations = false;
    private TextWriter writer;
    private FileBasedAccessLogPublisherCfg currentConfig;

    public static TextAccessLogPublisher getStartupTextAccessPublisher(TextWriter writer, boolean suppressInternal) {
        TextAccessLogPublisher startupPublisher = new TextAccessLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.suppressInternalOperations = suppressInternal;
        return startupPublisher;
    }

    @Override
    public boolean isConfigurationAcceptable(AccessLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        FileBasedAccessLogPublisherCfg config = (FileBasedAccessLogPublisherCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public void initializeAccessLogPublisher(FileBasedAccessLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDNs()) {
                writer.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : config.getRetentionPolicyDNs()) {
                writer.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        this.currentConfig = config;
        config.addFileBasedAccessChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedAccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedAccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedAccessChangeListener(this);
        }
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
        long connectionID = clientConnection.getConnectionID();
        if (connectionID < 0L && this.suppressInternalOperations) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" CONNECT conn=");
        buffer.append(connectionID);
        buffer.append(" from=");
        buffer.append(clientConnection.getClientAddress());
        buffer.append(" to=");
        buffer.append(clientConnection.getServerAddress());
        buffer.append(" protocol=");
        buffer.append(clientConnection.getProtocol());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        long connectionID = clientConnection.getConnectionID();
        if (connectionID < 0L && this.suppressInternalOperations) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" DISCONNECT conn=");
        buffer.append(connectionID);
        buffer.append(" reason=\"");
        buffer.append((Object)disconnectReason);
        if (message != null) {
            buffer.append("\" msg=\"");
            buffer.append(message);
        }
        buffer.append("\"");
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
        long connectionID = abandonOperation.getConnectionID();
        if (connectionID < 0L && (abandonOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" ABANDON conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(abandonOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(abandonOperation.getMessageID());
        buffer.append(" idToAbandon=");
        buffer.append(abandonOperation.getIDToAbandon());
        if (abandonOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
        long connectionID = abandonOperation.getConnectionID();
        if (connectionID < 0L && (abandonOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" ABANDON conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(abandonOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(abandonOperation.getMessageID());
        buffer.append(" result=");
        buffer.append((Object)abandonOperation.getResultCode());
        MessageBuilder msg = abandonOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append("\"");
        }
        if ((msg = abandonOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append("\"");
        }
        buffer.append(" etime=");
        buffer.append(abandonOperation.getProcessingTime());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
        long connectionID = addOperation.getConnectionID();
        if (connectionID < 0L && (addOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" ADD conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(addOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(addOperation.getMessageID());
        buffer.append(" dn=\"");
        addOperation.getRawEntryDN().toString(buffer);
        buffer.append("\"");
        if (addOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        DN proxiedAuthDN;
        long connectionID = addOperation.getConnectionID();
        if (connectionID < 0L && (addOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" ADD conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(addOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(addOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)addOperation.getResultCode());
        MessageBuilder msg = addOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = addOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if ((proxiedAuthDN = addOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append("\" authzDN=\"");
            proxiedAuthDN.toString(buffer);
        }
        buffer.append("\" etime=");
        buffer.append(addOperation.getProcessingTime());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
        long connectionID = bindOperation.getConnectionID();
        if (connectionID < 0L && (bindOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" BIND conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(bindOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(bindOperation.getMessageID());
        switch (bindOperation.getAuthenticationType()) {
            case SIMPLE: {
                buffer.append(" type=SIMPLE");
                break;
            }
            case SASL: {
                buffer.append(" type=SASL mechanism=");
                buffer.append(bindOperation.getSASLMechanism());
                break;
            }
            default: {
                buffer.append(" type=");
                buffer.append((Object)bindOperation.getAuthenticationType());
            }
        }
        buffer.append(" dn=\"");
        bindOperation.getRawBindDN().toString(buffer);
        buffer.append("\"");
        if (bindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
        AuthenticationInfo authInfo;
        Message failureMessage;
        long connectionID = bindOperation.getConnectionID();
        if (connectionID < 0L && (bindOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" BIND conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(bindOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(bindOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)bindOperation.getResultCode());
        MessageBuilder msg = bindOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((failureMessage = bindOperation.getAuthFailureReason()) != null) {
            buffer.append("\" authFailureID=");
            buffer.append(failureMessage.getDescriptor().getId());
            buffer.append(" authFailureReason=\"");
            buffer.append(failureMessage);
        }
        if ((msg = bindOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if (bindOperation.getResultCode() == ResultCode.SUCCESS && (authInfo = bindOperation.getAuthenticationInfo()) != null) {
            DN authDN = authInfo.getAuthenticationDN();
            buffer.append("\" authDN=\"");
            if (authDN != null) {
                authDN.toString(buffer);
                DN authzDN = authInfo.getAuthorizationDN();
                if (!authDN.equals(authzDN)) {
                    buffer.append("\" authzDN=\"");
                    if (authzDN != null) {
                        authzDN.toString(buffer);
                    }
                }
            }
        }
        buffer.append("\" etime=");
        long etime = bindOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = bindOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
        long connectionID = compareOperation.getConnectionID();
        if (connectionID < 0L && (compareOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" COMPARE conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(compareOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(compareOperation.getMessageID());
        buffer.append(" dn=\"");
        compareOperation.getRawEntryDN().toString(buffer);
        buffer.append("\" attr=");
        buffer.append(compareOperation.getAttributeType());
        if (compareOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
        DN proxiedAuthDN;
        long connectionID = compareOperation.getConnectionID();
        if (connectionID < 0L && (compareOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" COMPARE conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(compareOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(compareOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)compareOperation.getResultCode());
        MessageBuilder msg = compareOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = compareOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if ((proxiedAuthDN = compareOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append("\" authzDN=\"");
            proxiedAuthDN.toString(buffer);
        }
        buffer.append("\" etime=");
        long etime = compareOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = compareOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
        long connectionID = deleteOperation.getConnectionID();
        if (connectionID < 0L && (deleteOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" DELETE conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(deleteOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(deleteOperation.getMessageID());
        buffer.append(" dn=\"");
        deleteOperation.getRawEntryDN().toString(buffer);
        buffer.append("\"");
        if (deleteOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        DN proxiedAuthDN;
        long connectionID = deleteOperation.getConnectionID();
        if (connectionID < 0L && (deleteOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" DELETE conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(deleteOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(deleteOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)deleteOperation.getResultCode());
        MessageBuilder msg = deleteOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = deleteOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if ((proxiedAuthDN = deleteOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append("\" authzDN=\"");
            proxiedAuthDN.toString(buffer);
        }
        buffer.append("\" etime=");
        long etime = deleteOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = deleteOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
        long connectionID = extendedOperation.getConnectionID();
        if (connectionID < 0L && (extendedOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" EXTENDED conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(extendedOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(extendedOperation.getMessageID());
        buffer.append(" oid=\"");
        buffer.append(extendedOperation.getRequestOID());
        buffer.append("\"");
        if (extendedOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
        long connectionID = extendedOperation.getConnectionID();
        if (connectionID < 0L && (extendedOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" EXTENDED conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(extendedOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(extendedOperation.getMessageID());
        String oid = extendedOperation.getResponseOID();
        if (oid != null) {
            buffer.append(" oid=\"");
            buffer.append(oid);
            buffer.append("\"");
        }
        buffer.append(" result=\"");
        buffer.append((Object)extendedOperation.getResultCode());
        MessageBuilder msg = extendedOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = extendedOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        buffer.append("\" etime=");
        long etime = extendedOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = extendedOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
        long connectionID = modifyOperation.getConnectionID();
        if (connectionID < 0L && (modifyOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" MODIFY conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(modifyOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(modifyOperation.getMessageID());
        buffer.append(" dn=\"");
        modifyOperation.getRawEntryDN().toString(buffer);
        buffer.append("\"");
        if (modifyOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        DN proxiedAuthDN;
        long connectionID = modifyOperation.getConnectionID();
        if (connectionID < 0L && (modifyOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" MODIFY conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(modifyOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(modifyOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)modifyOperation.getResultCode());
        MessageBuilder msg = modifyOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = modifyOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if ((proxiedAuthDN = modifyOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append("\" authzDN=\"");
            proxiedAuthDN.toString(buffer);
        }
        buffer.append("\" etime=");
        long etime = modifyOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = modifyOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        long connectionID = modifyDNOperation.getConnectionID();
        if (connectionID < 0L && (modifyDNOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" MODIFYDN conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(modifyDNOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(modifyDNOperation.getMessageID());
        buffer.append(" dn=\"");
        modifyDNOperation.getRawEntryDN().toString(buffer);
        buffer.append("\" newRDN=\"");
        modifyDNOperation.getRawNewRDN().toString(buffer);
        buffer.append("\" deleteOldRDN=");
        buffer.append(modifyDNOperation.deleteOldRDN());
        ByteString newSuperior = modifyDNOperation.getRawNewSuperior();
        if (newSuperior != null) {
            buffer.append(" newSuperior=\"");
            newSuperior.toString(buffer);
        }
        if (modifyDNOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        DN proxiedAuthDN;
        long connectionID = modifyDNOperation.getConnectionID();
        if (connectionID < 0L && (modifyDNOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" MODIFYDN conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(modifyDNOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(modifyDNOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)modifyDNOperation.getResultCode());
        MessageBuilder msg = modifyDNOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        if ((msg = modifyDNOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append("\" additionalInfo=\"");
            buffer.append(msg);
        }
        if ((proxiedAuthDN = modifyDNOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append("\" authzDN=\"");
            proxiedAuthDN.toString(buffer);
        }
        buffer.append("\" etime=");
        long etime = modifyDNOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = modifyDNOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
        long connectionID = searchOperation.getConnectionID();
        if (connectionID < 0L && (searchOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" SEARCH conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(searchOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(searchOperation.getMessageID());
        buffer.append(" base=\"");
        searchOperation.getRawBaseDN().toString(buffer);
        buffer.append("\" scope=");
        buffer.append((Object)searchOperation.getScope());
        buffer.append(" filter=\"");
        searchOperation.getRawFilter().toString(buffer);
        LinkedHashSet<String> attrs = searchOperation.getAttributes();
        if (attrs == null || attrs.isEmpty()) {
            buffer.append("\" attrs=\"ALL\"");
        } else {
            buffer.append("\" attrs=\"");
            Iterator iterator = attrs.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append((String)iterator.next());
            }
            buffer.append("\"");
        }
        if (searchOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
    }

    @Override
    public void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchReference) {
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
        DN proxiedAuthDN;
        long connectionID = searchOperation.getConnectionID();
        if (connectionID < 0L && (searchOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" SEARCH conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(searchOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(searchOperation.getMessageID());
        buffer.append(" result=\"");
        buffer.append((Object)searchOperation.getResultCode());
        MessageBuilder msg = searchOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append("\" message=\"");
            buffer.append(msg);
        }
        buffer.append("\" nentries=");
        buffer.append(searchOperation.getEntriesSent());
        msg = searchOperation.getAdditionalLogMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append("\"");
        }
        if ((proxiedAuthDN = searchOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append("\"");
        }
        buffer.append(" etime=");
        long etime = searchOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = searchOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
        long connectionID = unbindOperation.getConnectionID();
        if (connectionID < 0L && (unbindOperation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" UNBIND conn=");
        buffer.append(connectionID);
        buffer.append(" op=");
        buffer.append(unbindOperation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(unbindOperation.getMessageID());
        if (unbindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

