/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedKeyManagerProviderCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedKeyManagerProvider
extends KeyManagerProvider<FileBasedKeyManagerProviderCfg>
implements ConfigurationChangeListener<FileBasedKeyManagerProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private char[] keyStorePIN;
    private FileBasedKeyManagerProviderCfg currentConfig;
    private String keyStoreFile;
    private String keyStoreType;

    @Override
    public void initializeKeyManagerProvider(FileBasedKeyManagerProviderCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addFileBasedChangeListener(this);
        this.keyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(this.keyStoreFile);
            if (!f.exists() || !f.isFile()) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_NO_SUCH_FILE.get(String.valueOf(this.keyStoreFile), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
        }
        catch (SecurityException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_CANNOT_DETERMINE_FILE.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
                this.keyStoreType = configuration.getKeyStoreType();
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_INVALID_TYPE.get(String.valueOf(configuration.getKeyStoreType()), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse));
                throw new InitializationException(message);
            }
        } else {
            this.keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStorePIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinFile() != null) {
            String pinStr;
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(pinFile));
                pinStr = br.readLine();
                br.close();
            }
            catch (IOException ioe) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                throw new InitializationException(message, (Throwable)ioe);
            }
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePin() != null) {
            this.keyStorePIN = configuration.getKeyStorePin().toCharArray();
        } else {
            Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_NO_PIN.get(String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
    }

    @Override
    public void finalizeKeyManagerProvider() {
        this.currentConfig.removeFileBasedChangeListener(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(this.keyStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.keyStoreFile));
            keyStore.load(inputStream, this.keyStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_CANNOT_LOAD.get(this.keyStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FILE_KEYMANAGER_CANNOT_CREATE_FACTORY.get(this.keyStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(FileBasedKeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedKeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String newKeyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newKeyStoreFile);
            if (!f.exists() || !f.isFile()) {
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_NO_SUCH_FILE.get(String.valueOf(newKeyStoreFile), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_CANNOT_DETERMINE_FILE.get(String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(e)));
            configAcceptable = false;
        }
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_INVALID_TYPE.get(String.valueOf(configuration.getKeyStoreType()), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(kse)));
                configAcceptable = false;
            }
        }
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe)));
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                    configAcceptable = false;
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            configuration.getKeyStorePin().toCharArray();
        } else {
            unacceptableReasons.add(ExtensionMessages.ERR_FILE_KEYMANAGER_NO_PIN.get(String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedKeyManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        String newKeyStoreFile = configuration.getKeyStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newKeyStoreFile);
            if (!f.exists() || !f.isFile()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_NO_SUCH_FILE.get(String.valueOf(newKeyStoreFile), String.valueOf(this.configEntryDN)));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_CANNOT_DETERMINE_FILE.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e)));
        }
        String newKeyStoreType = KeyStore.getDefaultType();
        if (configuration.getKeyStoreType() != null) {
            try {
                KeyStore.getInstance(configuration.getKeyStoreType());
                newKeyStoreType = configuration.getKeyStoreType();
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_INVALID_TYPE.get(String.valueOf(configuration.getKeyStoreType()), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse)));
            }
        }
        char[] newPIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(this.configEntryDN)));
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            newPIN = configuration.getKeyStorePin().toCharArray();
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(ExtensionMessages.ERR_FILE_KEYMANAGER_NO_PIN.get(String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.currentConfig = configuration;
            this.keyStorePIN = newPIN;
            this.keyStoreFile = newKeyStoreFile;
            this.keyStoreType = newKeyStoreType;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

