/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.WorkQueueCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkQueueConfigManager
implements ConfigurationChangeListener<WorkQueueCfg> {
    public WorkQueue initializeWorkQueue() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        WorkQueueCfg workQueueConfig = rootConfiguration.getWorkQueue();
        workQueueConfig.addChangeListener(this);
        WorkQueueCfgDefn definition = WorkQueueCfgDefn.getInstance();
        ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
        Class<WorkQueue> workQueueClass = propertyDefinition.loadClass(workQueueConfig.getJavaClass(), WorkQueue.class);
        try {
            WorkQueue workQueue = workQueueClass.newInstance();
            Method method = workQueue.getClass().getMethod("initializeWorkQueue", workQueueConfig.configurationClass());
            method.invoke((Object)workQueue, workQueueConfig);
            return workQueue;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_INITIALIZATION_FAILED.get(workQueueConfig.getJavaClass(), String.valueOf(workQueueConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(WorkQueueCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(WorkQueueCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        WorkQueue workQueue = DirectoryServer.getWorkQueue();
        String workQueueClass = configuration.getJavaClass();
        if (!workQueueClass.equals(workQueue.getClass().getName())) {
            messages.add(ConfigMessages.INFO_CONFIG_WORK_QUEUE_CLASS_CHANGE_REQUIRES_RESTART.get(workQueue.getClass().getName(), workQueueClass));
            adminActionRequired = true;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

