/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

public class ServerSideSortRequestControl
extends Control {
    private static final byte TYPE_ORDERING_RULE_ID = -128;
    private static final byte TYPE_REVERSE_ORDER = -127;
    private SortOrder sortOrder;

    public ServerSideSortRequestControl(SortOrder sortOrder) {
        super("1.2.840.113556.1.4.473", false, ServerSideSortRequestControl.encodeControlValue(sortOrder));
        this.sortOrder = sortOrder;
    }

    public ServerSideSortRequestControl(String sortOrderString) throws LDAPException {
        super("1.2.840.113556.1.4.473", false, ServerSideSortRequestControl.encodeControlValue(sortOrderString));
        this.sortOrder = null;
    }

    private ServerSideSortRequestControl(String oid, boolean isCritical, ASN1OctetString controlValue, SortOrder sortOrder) {
        super(oid, isCritical, controlValue);
        this.sortOrder = sortOrder;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    private static ASN1OctetString encodeControlValue(SortOrder sortOrder) {
        SortKey[] sortKeys = sortOrder.getSortKeys();
        ArrayList<ASN1Element> keyList = new ArrayList<ASN1Element>(sortKeys.length);
        for (SortKey sortKey : sortKeys) {
            ArrayList<ASN1Element> elementList = new ArrayList<ASN1Element>(3);
            elementList.add(new ASN1OctetString(sortKey.getAttributeType().getNameOrOID()));
            if (sortKey.getOrderingRule() != null) {
                elementList.add(new ASN1OctetString(-128, sortKey.getOrderingRule().getNameOrOID()));
            }
            if (!sortKey.ascending()) {
                elementList.add(new ASN1Boolean(-127, true));
            }
            keyList.add(new ASN1Sequence(elementList));
        }
        return new ASN1OctetString(new ASN1Sequence(keyList).encode());
    }

    private static ASN1OctetString encodeControlValue(String sortOrderString) throws LDAPException {
        StringTokenizer tokenizer = new StringTokenizer(sortOrderString, ",");
        ArrayList<ASN1Element> keyList = new ArrayList<ASN1Element>();
        while (tokenizer.hasMoreTokens()) {
            ArrayList<ASN1Element> elementList;
            Message message;
            String token = tokenizer.nextToken().trim();
            boolean reverseOrder = false;
            if (token.startsWith("-")) {
                reverseOrder = true;
                token = token.substring(1);
            } else if (token.startsWith("+")) {
                token = token.substring(1);
            }
            int colonPos = token.indexOf(58);
            if (colonPos < 0) {
                ArrayList<ASN1Element> elementList2;
                if (token.length() == 0) {
                    message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ATTR_NAME.get(sortOrderString);
                    throw new LDAPException(2, message);
                }
                if (reverseOrder) {
                    elementList2 = new ArrayList<ASN1Element>(2);
                    elementList2.add(new ASN1OctetString(token));
                    elementList2.add(new ASN1Boolean(-127, reverseOrder));
                    keyList.add(new ASN1Sequence(elementList2));
                    continue;
                }
                elementList2 = new ArrayList(1);
                elementList2.add(new ASN1OctetString(token));
                keyList.add(new ASN1Sequence(elementList2));
                continue;
            }
            if (colonPos == 0) {
                message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ATTR_NAME.get(sortOrderString);
                throw new LDAPException(2, message);
            }
            if (colonPos == token.length() - 1) {
                message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_MATCHING_RULE.get(sortOrderString);
                throw new LDAPException(2, message);
            }
            String attrName = token.substring(0, colonPos);
            String ruleID = token.substring(colonPos + 1);
            if (reverseOrder) {
                elementList = new ArrayList<ASN1Element>(3);
                elementList.add(new ASN1OctetString(attrName));
                elementList.add(new ASN1OctetString(-128, ruleID));
                elementList.add(new ASN1Boolean(-127, reverseOrder));
                keyList.add(new ASN1Sequence(elementList));
                continue;
            }
            elementList = new ArrayList(2);
            elementList.add(new ASN1OctetString(attrName));
            elementList.add(new ASN1OctetString(-128, ruleID));
            keyList.add(new ASN1Sequence(elementList));
        }
        if (keyList.isEmpty()) {
            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_SORT_KEYS.get();
            throw new LDAPException(2, message);
        }
        return new ASN1OctetString(new ASN1Sequence(keyList).encode());
    }

    public static ServerSideSortRequestControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_VALUE.get();
            throw new LDAPException(2, message);
        }
        try {
            ASN1Sequence orderSequence = ASN1Sequence.decodeAsSequence(controlValue.value());
            ArrayList<ASN1Element> orderElements = orderSequence.elements();
            SortKey[] sortKeys = new SortKey[orderElements.size()];
            if (sortKeys.length == 0) {
                Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_SORT_KEYS.get();
                throw new LDAPException(2, message);
            }
            for (int i = 0; i < sortKeys.length; ++i) {
                ASN1Sequence keySequence = orderElements.get(i).decodeAsSequence();
                ArrayList<ASN1Element> keyElements = keySequence.elements();
                String attrName = keyElements.get(0).decodeAsOctetString().stringValue().toLowerCase();
                AttributeType attrType = DirectoryServer.getAttributeType(attrName, false);
                if (attrType == null) {
                    Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_UNDEFINED_ATTR.get(attrName);
                    throw new LDAPException(2, message);
                }
                OrderingMatchingRule orderingRule = null;
                boolean ascending = true;
                block8: for (int j = 1; j < keyElements.size(); ++j) {
                    ASN1Element e = keyElements.get(j);
                    switch (e.getType()) {
                        case -128: {
                            String orderingRuleID = e.decodeAsOctetString().stringValue().toLowerCase();
                            orderingRule = DirectoryServer.getOrderingMatchingRule(orderingRuleID);
                            if (orderingRule != null) continue block8;
                            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_UNDEFINED_ORDERING_RULE.get(orderingRuleID);
                            throw new LDAPException(2, message);
                        }
                        case -127: {
                            ascending = !e.decodeAsBoolean().booleanValue();
                            continue block8;
                        }
                        default: {
                            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_INVALID_SEQ_ELEMENT_TYPE.get(StaticUtils.byteToHex(e.getType()));
                            throw new LDAPException(2, message);
                        }
                    }
                }
                if (orderingRule == null && attrType.getOrderingMatchingRule() == null) {
                    Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ORDERING_RULE_FOR_ATTR.get(attrName);
                    throw new LDAPException(19, message);
                }
                sortKeys[i] = new SortKey(attrType, ascending, orderingRule);
            }
            return new ServerSideSortRequestControl(control.getOID(), control.isCritical(), controlValue, new SortOrder(sortKeys));
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, message, e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerSideSortRequestControl(");
        if (this.sortOrder != null) {
            buffer.append(this.sortOrder);
        }
        buffer.append(")");
    }
}

