/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.io.File;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class ConfigConstants {
    public static final String NAME_PREFIX_BACKUP = "ds-backup-";
    public static final String NAME_PREFIX_CFG = "ds-cfg-";
    public static final String NAME_PREFIX_PWP = "ds-pwp-";
    public static final String NAME_PREFIX_RECURRING_TASK = "ds-recurring-task-";
    public static final String NAME_PREFIX_RLIM = "ds-rlim-";
    public static final String NAME_PREFIX_TASK = "ds-task-";
    public static final String ATTR_ACCEPT_BACKLOG = "ds-cfg-accept-backlog";
    public static final int DEFAULT_ACCEPT_BACKLOG = 128;
    public static final String ATTR_ACCT_NOTIFICATION_HANDLER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_ACCT_NOTIFICATION_HANDLER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_ACCT_NOTIFICATION_TYPE = "ds-cfg-account-status-notification-type";
    public static final String ATTR_ADD_MISSING_RDN_ATTRS = "ds-cfg-add-missing-rdn-attributes";
    public static final String ATTR_ALERT_HANDLER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_ALERT_HANDLER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_ALLOW_ATTRIBUTE_NAME_EXCEPTIONS = "ds-cfg-allow-attribute-name-exceptions";
    public static final String ATTR_ALLOWED_CLIENT = "ds-cfg-allowed-client";
    public static final String ATTR_ALLOW_LDAPV2 = "ds-cfg-allow-ldap-v2";
    public static final boolean DEFAULT_ALLOW_LDAPV2 = true;
    public static final String ATTR_ALLOW_REUSE_ADDRESS = "ds-cfg-allow-tcp-reuse-address";
    public static final boolean DEFAULT_ALLOW_REUSE_ADDRESS = true;
    public static final String ATTR_ROOTDN_ALTERNATE_BIND_DN = "ds-cfg-alternate-bind-dn";
    public static final String ATTR_ROOTDSE_SHOW_ALL_ATTRIBUTES = "ds-cfg-show-all-attributes";
    public static final boolean DEFAULT_ROOTDSE_SHOW_ALL_ATTRIBUTES = false;
    public static final String ATTR_SCHEMA_SHOW_ALL_ATTRIBUTES = "ds-cfg-show-all-attributes";
    public static final boolean DEFAULT_SCHEMA_SHOW_ALL_ATTRIBUTES = false;
    public static final String ATTR_ALLOW_STARTTLS = "ds-cfg-allow-start-tls";
    public static final boolean DEFAULT_ALLOW_STARTTLS = false;
    public static final String ATTR_ALLOW_ZEROLENGTH_DIRECTORYSTRINGS = "ds-cfg-allow-zero-length-values";
    public static final boolean DEFAULT_ALLOW_ZEROLENGTH_DIRECTORYSTRINGS = false;
    public static final String ATTR_ATTRIBUTE_TYPES = "attributeTypes";
    public static final String ATTR_ATTRIBUTE_TYPES_LC = "attributetypes";
    public static final String ATTR_BACKEND_BASE_DN = "ds-cfg-base-dn";
    public static final String ATTR_BACKEND_CLASS = "ds-cfg-java-class";
    public static final String ATTR_BACKEND_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_BACKEND_ID = "ds-cfg-backend-id";
    public static final String ATTR_BACKEND_WRITABILITY_MODE = "ds-cfg-writability-mode";
    public static final String ATTR_BACKUP_BACKEND_DN = "ds-backup-backend-dn";
    public static final String ATTR_BACKUP_COMPRESSED = "ds-backup-compressed";
    public static final String ATTR_BACKUP_DATE = "ds-backup-date";
    public static final String ATTR_BACKUP_DEPENDENCY = "ds-backup-dependency";
    public static final String ATTR_BACKUP_DIR_LIST = "ds-cfg-backup-directory";
    public static final String ATTR_BACKUP_DIRECTORY_PATH = "ds-backup-directory-path";
    public static final String ATTR_BACKUP_ENCRYPTED = "ds-backup-encrypted";
    public static final String ATTR_BACKUP_ID = "ds-backup-id";
    public static final String ATTR_BACKUP_INCREMENTAL = "ds-backup-incremental";
    public static final String ATTR_BACKUP_SIGNED_HASH = "ds-backup-signed-hash";
    public static final String ATTR_BACKUP_UNSIGNED_HASH = "ds-backup-unsigned-hash";
    public static final String ATTR_BIND_WITH_DN_REQUIRES_PW = "ds-cfg-bind-with-dn-requires-password";
    public static final boolean DEFAULT_BIND_WITH_DN_REQUIRES_PW = true;
    public static final String ATTR_REJECT_UNAUTHENTICATED_REQ = "ds-cfg-reject-unauthenticated-requests";
    public static final boolean DEFAULT_REJECT_UNAUTHENTICATED_REQ = false;
    public static final String ATTR_CERTIFICATE_FINGERPRINT_ATTR = "ds-cfg-fingerprint-attribute";
    public static final String ATTR_CERTIFICATE_FINGERPRINT_ALGORITHM = "ds-cfg-fingerprint-algorithm";
    public static final String ATTR_CERTIFICATE_SUBJECT_ATTR = "ds-cfg-subject-attribute";
    public static final String ATTR_CERTIFICATE_SUBJECT_ATTR_MAP = "ds-cfg-subject-attribute-mapping";
    public static final String ATTR_CERTIFICATE_SUBJECT_BASEDN = "ds-cfg-user-base-dn";
    public static final String ATTR_CERTMAPPER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_CERTMAPPER_DN = "ds-cfg-certificate-mapper";
    public static final String ATTR_CERTMAPPER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_CHECK_SCHEMA = "ds-cfg-check-schema";
    public static final String ATTR_CLIENT_CERT_VALIDATION_POLICY = "ds-cfg-certificate-validation-policy";
    public static final String ATTR_CONNECTION_HANDLER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_CONNECTION_HANDLER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_DEFAULT_PWPOLICY_DN = "ds-cfg-default-password-policy";
    public static final String ATTR_DEFAULT_ROOT_PRIVILEGE_NAME = "ds-cfg-default-root-privilege-name";
    public static final String ATTR_DENIED_CLIENT = "ds-cfg-denied-client";
    public static final String ATTR_DIGESTMD5_REALM = "ds-cfg-realm";
    public static final String ATTR_DIT_CONTENT_RULES = "dITContentRules";
    public static final String ATTR_DIT_CONTENT_RULES_LC = "ditcontentrules";
    public static final String ATTR_DIT_STRUCTURE_RULES = "dITStructureRules";
    public static final String ATTR_DIT_STRUCTURE_RULES_LC = "ditstructurerules";
    public static final String ATTR_ENTRYCACHE_CLASS = "ds-cfg-java-class";
    public static final String ATTR_ENTRYCACHE_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_EXTOP_CLASS = "ds-cfg-java-class";
    public static final String ATTR_EXTOP_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_FIFOCACHE_EXCLUDE_FILTER = "ds-cfg-exclude-filter";
    public static final String ATTR_FIFOCACHE_INCLUDE_FILTER = "ds-cfg-include-filter";
    public static final String ATTR_FIFOCACHE_LOCK_TIMEOUT = "ds-cfg-lock-timeout";
    public static final long DEFAULT_FIFOCACHE_LOCK_TIMEOUT = 2000L;
    public static final String ATTR_FIFOCACHE_MAX_ENTRIES = "ds-cfg-max-entries";
    public static final long DEFAULT_FIFOCACHE_MAX_ENTRIES = Long.MAX_VALUE;
    public static final String ATTR_FIFOCACHE_MAX_MEMORY_PCT = "ds-cfg-max-memory-percent";
    public static final int DEFAULT_FIFOCACHE_MAX_MEMORY_PCT = 90;
    public static final String ATTR_FSCACHE_EXCLUDE_FILTER = "ds-cfg-exclude-filter";
    public static final String ATTR_FSCACHE_INCLUDE_FILTER = "ds-cfg-include-filter";
    public static final String ATTR_FSCACHE_LOCK_TIMEOUT = "ds-cfg-lock-timeout";
    public static final long DEFAULT_FSCACHE_LOCK_TIMEOUT = 2000L;
    public static final String ATTR_FSCACHE_MAX_ENTRIES = "ds-cfg-max-entries";
    public static final long DEFAULT_FSCACHE_MAX_ENTRIES = Long.MAX_VALUE;
    public static final String ATTR_FSCACHE_MAX_MEMORY_SIZE = "ds-cfg-max-memory-size";
    public static final String ATTR_FSCACHE_HOME = "ds-cfg-cache-directory";
    public static final String DEFAULT_FSCACHE_HOME = "/tmp/OpenDS.FSCache";
    public static final String ATTR_FSCACHE_JE_CACHE_SIZE = "ds-cfg-db-cache-size";
    public static final long DEFAULT_FSCACHE_JE_CACHE_SIZE = 0L;
    public static final String ATTR_FSCACHE_JE_CACHE_PCT = "ds-cfg-db-cache-percent";
    public static final int DEFAULT_FSCACHE_JE_CACHE_PCT = 0;
    public static final String ATTR_FSCACHE_IS_PERSISTENT = "ds-cfg-persistent-cache";
    public static final boolean DEFAULT_FSCACHE_IS_PERSISTENT = false;
    public static final String DEFAULT_FSCACHE_TYPE = "FIFO";
    public static final String ATTR_FSCACHE_TYPE = "ds-cfg-cache-type";
    public static final String ATTR_GROUP_IMPLEMENTATION_CLASS = "ds-cfg-java-class";
    public static final String ATTR_GROUP_IMPLEMENTATION_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_GSSAPI_KDC = "ds-cfg-kdc-address";
    public static final String ATTR_GSSAPI_KEYTAB_FILE = "ds-cfg-keytab";
    public static final String ATTR_GSSAPI_REALM = "ds-cfg-realm";
    public static final String ATTR_IDMAPPER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_IDMAPPER_DN = "ds-cfg-identity-mapper";
    public static final String ATTR_IDMAPPER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_INVALID_SYNTAX_BEHAVIOR = "ds-cfg-invalid-attribute-syntax-behavior";
    public static final String ATTR_SINGLE_STRUCTURAL_CLASS_BEHAVIOR = "ds-cfg-single-structural-objectclass-behavior";
    public static final String ATTR_LDAP_SYNTAXES = "ldapSyntaxes";
    public static final String ATTR_LDAP_SYNTAXES_LC = "ldapsyntaxes";
    public static final String ATTR_KEEP_LDAP_STATS = "ds-cfg-keep-stats";
    public static final boolean DEFAULT_KEEP_LDAP_STATS = true;
    public static final String ATTR_KEYMANAGER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_KEYMANAGER_DN = "ds-cfg-key-manager-provider";
    public static final String ATTR_KEYMANAGER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_KEYSTORE_FILE = "ds-cfg-key-store-file";
    public static final String ATTR_KEYSTORE_PIN = "ds-cfg-key-store-pin";
    public static final String ATTR_KEYSTORE_PIN_ENVAR = "ds-cfg-key-store-pin-environment-variable";
    public static final String ATTR_KEYSTORE_PIN_FILE = "ds-cfg-key-store-pin-file";
    public static final String ATTR_KEYSTORE_PIN_PROPERTY = "ds-cfg-key-store-pin-property";
    public static final String ATTR_KEYSTORE_TYPE = "ds-cfg-key-store-type";
    public static final String ATTR_TRUSTMANAGER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_TRUSTMANAGER_DN = "ds-cfg-trust-manager-provider";
    public static final String ATTR_TRUSTMANAGER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_TRUSTSTORE_FILE = "ds-cfg-trust-store-file";
    public static final String ATTR_TRUSTSTORE_PIN = "ds-cfg-trust-store-pin";
    public static final String ATTR_TRUSTSTORE_PIN_ENVAR = "ds-cfg-trust-store-pin-environment-variable";
    public static final String ATTR_TRUSTSTORE_PIN_FILE = "ds-cfg-trust-store-pin-file";
    public static final String ATTR_TRUSTSTORE_PIN_PROPERTY = "ds-cfg-trust-store-pin-property";
    public static final String ATTR_TRUSTSTORE_TYPE = "ds-cfg-trust-store-type";
    public static final String ATTR_LISTEN_ADDRESS = "ds-cfg-listen-address";
    public static final String ATTR_LISTEN_PORT = "ds-cfg-listen-port";
    public static final String ATTR_LOGGER_SUPPRESS_INTERNAL_OPERATIONS = "ds-cfg-suppress-internal-operations";
    public static final String ATTR_LOGGER_ROTATION_POLICY = "ds-cfg-rotation-policy";
    public static final String ATTR_LOGGER_RETENTION_POLICY = "ds-cfg-retention-policy";
    public static final String ATTR_LOGGER_RETENTION_NUMBER_OF_FILES = "ds-cfg-number-of-files";
    public static final String ATTR_LOGGER_RETENTION_DISK_SPACE_USED = "ds-cfg-disk-space-used";
    public static final String ATTR_LOGGER_RETENTION_FREE_DISK_SPACE = "ds-cfg-free-disk-space";
    public static final String ATTR_LOGGER_ROTATION_SIZE_LIMIT = "ds-cfg-size-limit";
    public static final String ATTR_LOGGER_ROTATION_TIME_OF_DAY = "ds-cfg-time-of-day";
    public static final String ATTR_LOGGER_ROTATION_ACTION = "ds-cfg-rotation-action";
    public static final String ATTR_LOGGER_THREAD_INTERVAL = "ds-cfg-time-interval";
    public static final String ATTR_LOGGER_BUFFER_SIZE = "ds-cfg-buffer-size";
    public static final String ATTR_LOGGER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_LOGGER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_MATCH_ATTRIBUTE = "ds-cfg-match-attribute";
    public static final String ATTR_MATCH_BASE = "ds-cfg-match-base-dn";
    public static final String ATTR_MATCHING_RULES = "matchingRules";
    public static final String ATTR_MATCHING_RULES_LC = "matchingrules";
    public static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    public static final String ATTR_MATCHING_RULE_USE_LC = "matchingruleuse";
    public static final int DEFAULT_MAX_REQUEST_SIZE = 0x500000;
    public static final String ATTR_MATCHING_RULE_CLASS = "ds-cfg-java-class";
    public static final String ATTR_MATCHING_RULE_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_MAX_REQUEST_SIZE = "ds-cfg-max-request-size";
    public static final String ATTR_MAX_WORK_QUEUE_CAPACITY = "ds-cfg-max-work-queue-capacity";
    public static final int DEFAULT_MAX_WORK_QUEUE_CAPACITY = 0;
    public static final String ATTR_MONITOR_CLASS = "ds-cfg-java-class";
    public static final String ATTR_MONITOR_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_NAME_FORMS = "nameForms";
    public static final String ATTR_NAME_FORMS_LC = "nameforms";
    public static final String ATTR_NOTIFY_ABANDONED_OPS = "ds-cfg-notify-abandoned-operations";
    public static final String ATTR_NUM_REQUEST_HANDLERS = "ds-cfg-num-request-handlers";
    public static final int DEFAULT_NUM_REQUEST_HANDLERS = 1;
    public static final String ATTR_NUM_WORKER_THREADS = "ds-cfg-num-worker-threads";
    public static final int DEFAULT_NUM_WORKER_THREADS = 24;
    public static final String ATTR_OBJECTCLASS = "objectClass";
    public static final String ATTR_OBJECTCLASSES = "objectClasses";
    public static final String ATTR_OBJECTCLASSES_LC = "objectclasses";
    public static final String ATTR_PASSWORD_CHARSET = "ds-cfg-password-character-set";
    public static final String ATTR_PASSWORD_FORMAT = "ds-cfg-password-format";
    public static final String ATTR_PASSWORD_MAX_LENGTH = "ds-cfg-max-password-length";
    public static final String ATTR_PASSWORD_MIN_LENGTH = "ds-cfg-min-password-length";
    public static final String ATTR_PASSWORD_MIN_DIFFERENCE = "ds-cfg-min-password-difference";
    public static final String ATTR_PLUGIN_CLASS = "ds-cfg-java-class";
    public static final String ATTR_PLUGIN_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_PLUGIN_TYPE = "ds-cfg-plugin-type";
    public static final String ATTR_PROFILE_ACTION = "ds-cfg-profile-action";
    public static final String ATTR_PROFILE_AUTOSTART = "ds-cfg-enable-profiling-on-startup";
    public static final String ATTR_PROFILE_DIR = "ds-cfg-profile-directory";
    public static final String ATTR_PROFILE_INTERVAL = "ds-cfg-profile-sample-interval";
    public static final long DEFAULT_PROFILE_INTERVAL = 10L;
    public static final String ATTR_PROFILE_STATE = "ds-cfg-profiler-state";
    public static final String ATTR_PROXY_MAPPER_DN = "ds-cfg-proxied-authorization-identity-mapper";
    public static final String ATTR_PWGENERATOR_CLASS = "ds-cfg-java-class";
    public static final String ATTR_PWGENERATOR_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_PWPOLICY_ALLOW_EXPIRED_CHANGES = "ds-cfg-allow-expired-password-changes";
    public static final boolean DEFAULT_PWPOLICY_ALLOW_EXPIRED_CHANGES = false;
    public static final String ATTR_PWPOLICY_ALLOW_PRE_ENCODED_PASSWORDS = "ds-cfg-allow-pre-encoded-passwords";
    public static final boolean DEFAULT_PWPOLICY_ALLOW_PRE_ENCODED_PASSWORDS = false;
    public static final String ATTR_PWPOLICY_ALLOW_MULTIPLE_PW_VALUES = "ds-cfg-allow-multiple-password-values";
    public static final boolean DEFAULT_PWPOLICY_ALLOW_MULTIPLE_PW_VALUES = false;
    public static final String ATTR_PWPOLICY_ALLOW_USER_CHANGE = "ds-cfg-allow-user-password-changes";
    public static final boolean DEFAULT_PWPOLICY_ALLOW_USER_CHANGE = true;
    public static final String ATTR_PWPOLICY_DEFAULT_SCHEME = "ds-cfg-default-password-storage-scheme";
    public static final String ATTR_PWPOLICY_EXPIRE_WITHOUT_WARNING = "ds-cfg-expire-passwords-without-warning";
    public static final boolean DEFAULT_PWPOLICY_EXPIRE_WITHOUT_WARNING = false;
    public static final String ATTR_PWPOLICY_FORCE_CHANGE_ON_ADD = "ds-cfg-force-change-on-add";
    public static final boolean DEFAULT_PWPOLICY_FORCE_CHANGE_ON_ADD = false;
    public static final String ATTR_PWPOLICY_FORCE_CHANGE_ON_RESET = "ds-cfg-force-change-on-reset";
    public static final boolean DEFAULT_PWPOLICY_FORCE_CHANGE_ON_RESET = false;
    public static final String ATTR_PWPOLICY_GRACE_LOGIN_COUNT = "ds-cfg-grace-login-count";
    public static final int DEFAULT_PWPOLICY_GRACE_LOGIN_COUNT = 0;
    public static final int DEFAULT_PWPOLICY_HISTORY_COUNT = 0;
    public static final int DEFAULT_PWPOLICY_HISTORY_DURATION = 0;
    public static final String ATTR_PWPOLICY_IDLE_LOCKOUT_INTERVAL = "ds-cfg-idle-lockout-interval";
    public static final int DEFAULT_PWPOLICY_IDLE_LOCKOUT_INTERVAL = 0;
    public static final String ATTR_PWPOLICY_LAST_LOGIN_TIME_ATTRIBUTE = "ds-cfg-last-login-time-attribute";
    public static final String ATTR_PWPOLICY_LAST_LOGIN_TIME_FORMAT = "ds-cfg-last-login-time-format";
    public static final String ATTR_PWPOLICY_LOCKOUT_DURATION = "ds-cfg-lockout-duration";
    public static final int DEFAULT_PWPOLICY_LOCKOUT_DURATION = 0;
    public static final String ATTR_PWPOLICY_LOCKOUT_FAILURE_COUNT = "ds-cfg-lockout-failure-count";
    public static final int DEFAULT_PWPOLICY_LOCKOUT_FAILURE_COUNT = 0;
    public static final String ATTR_PWPOLICY_LOCKOUT_FAILURE_EXPIRATION_INTERVAL = "ds-cfg-lockout-failure-expiration-interval";
    public static final int DEFAULT_PWPOLICY_LOCKOUT_FAILURE_EXPIRATION_INTERVAL = 0;
    public static final String ATTR_PWPOLICY_MAXIMUM_PASSWORD_AGE = "ds-cfg-max-password-age";
    public static final int DEFAULT_PWPOLICY_MAXIMUM_PASSWORD_AGE = 0;
    public static final String ATTR_PWPOLICY_MAXIMUM_PASSWORD_RESET_AGE = "ds-cfg-max-password-reset-age";
    public static final int DEFAULT_PWPOLICY_MAXIMUM_PASSWORD_RESET_AGE = 0;
    public static final String ATTR_PWPOLICY_MINIMUM_PASSWORD_AGE = "ds-cfg-min-password-age";
    public static final int DEFAULT_PWPOLICY_MINIMUM_PASSWORD_AGE = 0;
    public static final String ATTR_PWPOLICY_NOTIFICATION_HANDLER = "ds-cfg-account-status-notification-handler";
    public static final String ATTR_PWPOLICY_PASSWORD_ATTRIBUTE = "ds-cfg-password-attribute";
    public static final String ATTR_PWPOLICY_PASSWORD_GENERATOR = "ds-cfg-password-generator";
    public static final String ATTR_PWPOLICY_PASSWORD_VALIDATOR = "ds-cfg-password-validator";
    public static final String ATTR_PWPOLICY_PREVIOUS_LAST_LOGIN_TIME_FORMAT = "ds-cfg-previous-last-login-time-format";
    public static final String ATTR_PWPOLICY_REQUIRE_CHANGE_BY_TIME = "ds-cfg-require-change-by-time";
    public static final String ATTR_PWPOLICY_REQUIRE_CURRENT_PASSWORD = "ds-cfg-password-change-requires-current-password";
    public static final boolean DEFAULT_PWPOLICY_REQUIRE_CURRENT_PASSWORD = false;
    public static final String ATTR_PWPOLICY_REQUIRE_SECURE_AUTHENTICATION = "ds-cfg-require-secure-authentication";
    public static final boolean DEFAULT_PWPOLICY_REQUIRE_SECURE_AUTHENTICATION = false;
    public static final String ATTR_PWPOLICY_REQUIRE_SECURE_PASSWORD_CHANGES = "ds-cfg-require-secure-password-changes";
    public static final boolean DEFAULT_PWPOLICY_REQUIRE_SECURE_PASSWORD_CHANGES = false;
    public static final String ATTR_PWPOLICY_SKIP_ADMIN_VALIDATION = "ds-cfg-skip-validation-for-administrators";
    public static final boolean DEFAULT_PWPOLICY_SKIP_ADMIN_VALIDATION = false;
    public static final String ATTR_PWPOLICY_WARNING_INTERVAL = "ds-cfg-password-expiration-warning-interval";
    public static final int DEFAULT_PWPOLICY_WARNING_INTERVAL = 604800;
    public static final String ATTR_PWSCHEME_CLASS = "ds-cfg-java-class";
    public static final String ATTR_PWSCHEME_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_PWVALIDATOR_CLASS = "ds-cfg-java-class";
    public static final String ATTR_PWVALIDATOR_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_RECURRING_TASK_CLASS_NAME = "ds-recurring-task-class-name";
    public static final String ATTR_RECURRING_TASK_ID = "ds-recurring-task-id";
    public static final String ATTR_RESTART_SERVER = "ds-task-restart-server";
    public static final String ATTR_ROOT_DSE_SUBORDINATE_BASE_DN = "ds-cfg-subordinate-base-dn";
    public static final String ATTR_SASL_CLASS = "ds-cfg-java-class";
    public static final String ATTR_SASL_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_SCHEMA_ENTRY_DN = "ds-cfg-schema-entry-dn";
    public static final String ATTR_SEND_REJECTION_NOTICE = "ds-cfg-send-rejection-notice";
    public static final boolean DEFAULT_SEND_REJECTION_NOTICE = true;
    public static final String ATTR_SERVER_ERROR_RESULT_CODE = "ds-cfg-server-error-result-code";
    public static final String ATTR_SERVER_FQDN = "ds-cfg-server-fqdn";
    public static final String ATTR_SHUTDOWN_MESSAGE = "ds-task-shutdown-message";
    public static final String ATTR_SHUTDOWN_PASSWORD = "ds-task-shutdown-password";
    public static final String ATTR_SIZE_LIMIT = "ds-cfg-size-limit";
    public static final int DEFAULT_SIZE_LIMIT = 1000;
    public static final String ATTR_LOOKTHROUGH_LIMIT = "ds-cfg-lookthrough-limit";
    public static final int DEFAULT_LOOKTHROUGH_LIMIT = 5000;
    public static final String ATTR_SOFTREFCACHE_EXCLUDE_FILTER = "ds-cfg-exclude-filter";
    public static final String ATTR_SOFTREFCACHE_INCLUDE_FILTER = "ds-cfg-include-filter";
    public static final String ATTR_SOFTREFCACHE_LOCK_TIMEOUT = "ds-cfg-lock-timeout";
    public static final String ATTR_SSL_CLIENT_AUTH_POLICY = "ds-cfg-ssl-client-auth-policy";
    public static final SSLClientAuthPolicy DEFAULT_SSL_CLIENT_AUTH_POLICY = SSLClientAuthPolicy.OPTIONAL;
    public static final String ATTR_SSL_CERT_NICKNAME = "ds-cfg-ssl-cert-nickname";
    public static final String DEFAULT_SSL_CERT_NICKNAME = "server-cert";
    public static final String ATTR_SSL_CIPHERS = "ds-cfg-ssl-cipher-suite";
    public static final String ATTR_SSL_PROTOCOLS = "ds-cfg-ssl-protocol";
    public static final String ATTR_SYNCHRONIZATION_PROVIDER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_SYNCHRONIZATION_PROVIDER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_AUTHZ_HANDLER_CLASS = "ds-cfg-java-class";
    public static final String ATTR_AUTHZ_HANDLER_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_AUTHZ_GLOBAL_ACI = "ds-cfg-global-aci";
    public static final String ATTR_SYNTAX_CLASS = "ds-cfg-java-class";
    public static final String ATTR_SYNTAX_ENABLED = "ds-cfg-enabled";
    public static final String ATTR_TASK_ACTUAL_START_TIME = "ds-task-actual-start-time";
    public static final String ATTR_TASK_BACKING_FILE = "ds-cfg-task-backing-file";
    public static final String ATTR_TASK_CLASS = "ds-task-class-name";
    public static final String ATTR_TASK_COMPLETION_TIME = "ds-task-completion-time";
    public static final String ATTR_TASK_DEPENDENCY_IDS = "ds-task-dependency-id";
    public static final String ATTR_TASK_FAILED_DEPENDENCY_ACTION = "ds-task-failed-dependency-action";
    public static final String ATTR_TASK_LOG_MESSAGES = "ds-task-log-message";
    public static final String ATTR_TASK_NOTIFY_ON_COMPLETION = "ds-task-notify-on-completion";
    public static final String ATTR_TASK_NOTIFY_ON_ERROR = "ds-task-notify-on-error";
    public static final String ATTR_TASK_RETENTION_TIME = "ds-cfg-task-retention-time";
    public static final long DEFAULT_TASK_RETENTION_TIME = 86400L;
    public static final String ATTR_TASK_SCHEDULED_START_TIME = "ds-task-scheduled-start-time";
    public static final String ATTR_TASK_ID = "ds-task-id";
    public static final String ATTR_TASK_STATE = "ds-task-state";
    public static final String ATTR_TELEPHONE_STRICT_MODE = "ds-cfg-strict-format";
    public static final String ATTR_TIME_LIMIT = "ds-cfg-time-limit";
    public static final int DEFAULT_TIME_LIMIT = 60;
    public static final String ATTR_USER_BASE_DN = "ds-cfg-user-base-dn";
    public static final String ATTR_USERNAME_ATTRIBUTE = "ds-cfg-user-name-attribute";
    public static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    public static final String ATTR_USE_SSL = "ds-cfg-use-ssl";
    public static final boolean DEFAULT_USE_SSL = false;
    public static final String ATTR_USE_TCP_KEEPALIVE = "ds-cfg-use-tcp-keep-alive";
    public static final boolean DEFAULT_USE_TCP_KEEPALIVE = true;
    public static final String ATTR_USE_TCP_NODELAY = "ds-cfg-use-tcp-no-delay";
    public static final boolean DEFAULT_USE_TCP_NODELAY = true;
    public static final String ATTR_VALIDATION_CERT_ATTRIBUTE = "ds-cfg-certificate-attribute";
    public static final String DEFAULT_VALIDATION_CERT_ATTRIBUTE = "usercertificate";
    public static final String ATTR_WORKQ_CLASS = "ds-cfg-java-class";
    public static final String ATTR_WRITABILITY_MODE = "ds-cfg-writability-mode";
    public static final String COMPRESSED_SCHEMA_FILE_NAME = "schematokens.dat";
    public static final String CONFIG_ARCHIVE_DIR_NAME = "archived-configs";
    public static final String CONFIG_CHANGES_NAME = "config-changes.ldif";
    public static final String CONFIG_DIR_NAME = "config";
    public static final String CONFIG_FILE_NAME = "config.ldif";
    public static final String DN_CONFIG_ROOT = "cn=config";
    public static final String DN_ACCT_NOTIFICATION_HANDLER_CONFIG_BASE = "cn=Account Status Notification Handlers,cn=config";
    public static final String DN_BACKEND_BASE = "cn=Backends,cn=config";
    public static final String DN_BACKUP_ROOT = "cn=backups";
    public static final String DN_CONNHANDLER_BASE = "cn=Connection Handlers,cn=config";
    public static final String DN_DEFAULT_SCHEMA_ROOT = "cn=schema";
    public static final String DN_ENTRY_CACHE_BASE = "cn=Entry Caches,cn=config";
    public static final String DN_EXTENDED_OP_CONFIG_BASE = "cn=Extended Operations,cn=config";
    public static final String DN_GROUP_IMPLEMENTATION_CONFIG_BASE = "cn=Group Implementations,cn=config";
    public static final String DN_IDMAPPER_CONFIG_BASE = "cn=Identity Mappers,cn=config";
    public static final String DN_CERTMAPPER_CONFIG_BASE = "cn=Certificate Mappers,cn=config";
    public static final String DN_KEYMANAGER_PROVIDER_CONFIG_BASE = "cn=Key Manager Providers,cn=config";
    public static final String DN_TRUSTMANAGER_PROVIDER_CONFIG_BASE = "cn=Trust Manager Providers,cn=config";
    public static final String ID_ADS_TRUST_STORE_BACKEND = "ads-truststore";
    public static final String DN_TRUST_STORE_BACKEND = "ds-cfg-backend-id=ads-truststore,cn=Backends,cn=config";
    public static final String ADS_CERTIFICATE_ALIAS = "ads-certificate";
    public static final String DN_TRUST_STORE_ROOT = "cn=ads-truststore";
    public static final String ATTR_CRYPTO_KEY_ID = "ds-cfg-key-id";
    public static final String OC_CRYPTO_INSTANCE_KEY = "ds-cfg-instance-key";
    public static final String OC_SELF_SIGNED_CERT_REQUEST = "ds-cfg-self-signed-cert-request";
    public static final String OC_CRYPTO_CIPHER_KEY = "ds-cfg-cipher-key";
    public static final String OC_CRYPTO_MAC_KEY = "ds-cfg-mac-key";
    public static final String ATTR_CRYPTO_PUBLIC_KEY_CERTIFICATE = "ds-cfg-public-key-certificate";
    public static final String ATTR_CRYPTO_CIPHER_TRANSFORMATION_NAME = "ds-cfg-cipher-transformation-name";
    public static final String ATTR_CRYPTO_CIPHER_KEY_WRAPPING_TRANSFORMATION = "ds-cfg-key-wrapping-transformation";
    public static final String ATTR_CRYPTO_MAC_ALGORITHM_NAME = "ds-cfg-mac-algorithm-name";
    public static final String ATTR_CRYPTO_KEY_LENGTH_BITS = "ds-cfg-key-length-bits";
    public static final String ATTR_CRYPTO_INIT_VECTOR_LENGTH_BITS = "ds-cfg-initialization-vector-length-bits";
    public static final String ATTR_CRYPTO_SYMMETRIC_KEY = "ds-cfg-symmetric-key";
    public static final String ATTR_CRYPTO_KEY_COMPROMISED_TIME = "ds-cfg-key-compromised-time";
    public static final String DN_LOGGER_BASE = "cn=Loggers,cn=config";
    public static final String DN_MATCHING_RULE_CONFIG_BASE = "cn=Matching Rules,cn=config";
    public static final String DN_MONITOR_CONFIG_BASE = "cn=Monitor Providers,cn=config";
    public static final String DN_ENTRY_CACHE_MONITOR_CONFIG = "cn=Entry Caches,cn=Monitor Providers,cn=config";
    public static final String DN_MONITOR_ROOT = "cn=monitor";
    public static final String DN_PLUGIN_BASE = "cn=Plugins,cn=config";
    public static final String DN_PWGENERATOR_CONFIG_BASE = "cn=Password Generators,cn=config";
    public static final String DN_PWPOLICY_CONFIG_BASE = "cn=Password Policies,cn=config";
    public static final String DN_PWSCHEME_CONFIG_BASE = "cn=Password Storage Schemes,cn=config";
    public static final String DN_PWVALIDATOR_CONFIG_BASE = "cn=Password Validators,cn=config";
    public static final String DN_ROOT_DN_CONFIG_BASE = "cn=Root DNs,cn=config";
    public static final String DN_ROOT_DSE_CONFIG = "cn=Root DSE,cn=config";
    public static final String DN_SASL_CONFIG_BASE = "cn=SASL Mechanisms,cn=config";
    public static final String DN_SYNCHRONIZATION_PROVIDER_BASE = "cn=Synchronization Providers,cn=config";
    public static final String DN_AUTHZ_HANDLER_CONFIG = "cn=Access Control Handler,cn=config";
    public static final String DN_SYNTAX_CONFIG_BASE = "cn=Syntaxes,cn=config";
    public static final String DN_TASK_ROOT = "cn=Tasks";
    public static final String DN_WORK_QUEUE_CONFIG = "cn=Work Queue,cn=config";
    public static final String ENV_VAR_INSTANCE_ROOT = "INSTANCE_ROOT";
    public static final String JMX_TYPE_BOOLEAN_ARRAY = "[Z";
    public static final String JMX_TYPE_BYTE_ARRAY = "[B";
    public static final String JMX_TYPE_CHARACTER_ARRAY = "[C";
    public static final String JMX_TYPE_DOUBLE_ARRAY = "[D";
    public static final String JMX_TYPE_FLOAT_ARRAY = "[F";
    public static final String JMX_TYPE_INT_ARRAY = "[I";
    public static final String JMX_TYPE_LONG_ARRAY = "[J";
    public static final String JMX_TYPE_SHORT_ARRAY = "[S";
    public static final String JMX_TYPE_STRING_ARRAY = "[L" + String.class.getName() + ";";
    public static final String OC_ACCESS_LOGGER = "ds-cfg-access-log-publisher";
    public static final String OC_ACCT_NOTIFICATION_HANDLER = "ds-cfg-account-status-notification-handler";
    public static final String OC_ALERT_HANDLER = "ds-cfg-alert-handler";
    public static final String OC_ATTRIBUTE_SYNTAX = "ds-cfg-attribute-syntax";
    public static final String OC_BACKEND = "ds-cfg-backend";
    public static final String OC_BACKUP_DIRECTORY = "ds-backup-directory";
    public static final String OC_BACKUP_INFO = "ds-backup-info";
    public static final String OC_CERTIFICATE_MAPPER = "ds-cfg-certificate-mapper";
    public static final String OC_CONNECTION_HANDLER = "ds-cfg-connection-handler";
    public static final String OC_DEBUG_LOGGER = "ds-cfg-debug-log-publisher";
    public static final String OC_ERROR_LOGGER = "ds-cfg-error-log-publisher";
    public static final String OC_EXTENDED_OPERATION_HANDLER = "ds-cfg-extended-operation-handler";
    public static final String OC_GROUP_IMPLEMENTATION = "ds-cfg-group-implementation";
    public static final String OC_IDENTITY_MAPPER = "ds-cfg-identity-mapper";
    public static final String OC_KEY_MANAGER_PROVIDER = "ds-cfg-key-manager-provider";
    public static final String OC_MATCHING_RULE = "ds-cfg-matching-rule";
    public static final String OC_MONITOR_PROVIDER = "ds-cfg-monitor-provider";
    public static final String OC_PASSWORD_GENERATOR = "ds-cfg-password-generator";
    public static final String OC_PASSWORD_POLICY = "ds-cfg-password-policy";
    public static final String OC_PASSWORD_STORAGE_SCHEME = "ds-cfg-password-storage-scheme";
    public static final String OC_PASSWORD_VALIDATOR = "ds-cfg-password-validator";
    public static final String OC_PLUGIN = "ds-cfg-plugin";
    public static final String OC_RECURRING_TASK = "ds-recurring-task";
    public static final String OC_ROOT_DN = "ds-cfg-root-dn-user";
    public static final String OC_SASL_MECHANISM_HANDLER = "ds-cfg-sasl-mechanism-handler";
    public static final String OC_SYNCHRONIZATION_PROVIDER = "ds-cfg-synchronization-provider";
    public static final String OC_AUTHZ_HANDLER_CONFIG = "ds-cfg-access-control-handler";
    public static final String OC_TASK = "ds-task";
    public static final String OC_TRUST_MANAGER_PROVIDER = "ds-cfg-trust-manager-provider";
    public static final String OP_ATTR_ACCOUNT_DISABLED = "ds-pwp-account-disabled";
    public static final String OP_ATTR_ACCOUNT_EXPIRATION_TIME = "ds-pwp-account-expiration-time";
    public static final String OP_ATTR_CREATE_TIMESTAMP = "createTimestamp";
    public static final String OP_ATTR_CREATE_TIMESTAMP_LC = "createtimestamp";
    public static final String OP_ATTR_CREATORS_NAME = "creatorsName";
    public static final String OP_ATTR_CREATORS_NAME_LC = "creatorsname";
    public static final String OP_ATTR_LAST_LOGIN_TIME = "ds-pwp-last-login-time";
    public static final String OP_ATTR_MODIFIERS_NAME = "modifiersName";
    public static final String OP_ATTR_MODIFIERS_NAME_LC = "modifiersname";
    public static final String OP_ATTR_MODIFY_TIMESTAMP = "modifyTimestamp";
    public static final String OP_ATTR_MODIFY_TIMESTAMP_LC = "modifytimestamp";
    public static final String OP_ATTR_PRIVILEGE_NAME = "ds-privilege-name";
    public static final String OP_ATTR_PWPOLICY_CHANGED_TIME = "pwdChangedTime";
    public static final String OP_ATTR_PWPOLICY_CHANGED_TIME_LC = "pwdchangedtime";
    public static final String OP_ATTR_PWPOLICY_GRACE_LOGIN_TIME = "pwdGraceUseTime";
    public static final String OP_ATTR_PWPOLICY_GRACE_LOGIN_TIME_LC = "pwdgraceusetime";
    public static final String OP_ATTR_PWPOLICY_FAILURE_TIME = "pwdFailureTime";
    public static final String OP_ATTR_PWPOLICY_FAILURE_TIME_LC = "pwdfailuretime";
    public static final String OP_ATTR_PWPOLICY_HISTORY = "pwdHistory";
    public static final String OP_ATTR_PWPOLICY_HISTORY_LC = "pwdhistory";
    public static final String OP_ATTR_PWPOLICY_LOCKED_TIME = "pwdAccountLockedTime";
    public static final String OP_ATTR_PWPOLICY_LOCKED_TIME_LC = "pwdaccountlockedtime";
    public static final String OP_ATTR_PWPOLICY_CHANGED_BY_REQUIRED_TIME = "ds-pwp-password-changed-by-required-time";
    public static final String OP_ATTR_PWPOLICY_RESET_REQUIRED = "pwdReset";
    public static final String OP_ATTR_PWPOLICY_RESET_REQUIRED_LC = "pwdreset";
    public static final String OP_ATTR_PWPOLICY_POLICY_DN = "ds-pwp-password-policy-dn";
    public static final String OP_ATTR_PWPOLICY_WARNED_TIME = "ds-pwp-warned-time";
    public static final String OP_ATTR_USER_IDLE_TIME_LIMIT = "ds-rlim-idle-time-limit";
    public static final String OP_ATTR_USER_SIZE_LIMIT = "ds-rlim-size-limit";
    public static final String OP_ATTR_USER_TIME_LIMIT = "ds-rlim-time-limit";
    public static final String OP_ATTR_USER_LOOKTHROUGH_LIMIT = "ds-rlim-lookthrough-limit";
    public static final String OPTION_PENDING_VALUES = "pending";
    public static final String PATH_MAKELDIF_RESOURCE_DIR = "config" + File.separator + "MakeLDIF";
    public static final String PATH_SCHEMA_DIR = "config" + File.separator + "schema";
    public static final String FILE_USER_SCHEMA_ELEMENTS = "99-user.ldif";
    public static final String ATTR_LOGGER_FILE = "ds-cfg-log-file";
    public static final String ATTR_LOGGER_DEFAULT_SEVERITY = "ds-cfg-default-severity";
    public static final String ATTR_LOGGER_OVERRIDE_SEVERITY = "ds-cfg-override-severity";
    public static final String ATTR_BACKEND_DIRECTORY = "ds-cfg-db-directory";
    public static final String ATTR_BACKEND_MODE = "ds-cfg-db-directory-permissions";
    public static final String TASK_FILE_NAME = "tasks.ldif";
    public static final String RECURRING_TASK_BASE_RDN = "cn=Recurring Tasks";
    public static final String SCHEDULED_TASK_BASE_RDN = "cn=Scheduled Tasks";
    public static final String OC_IMPORT_TASK = "ds-task-import";
    public static final String ATTR_IMPORT_LDIF_FILE = "ds-task-import-ldif-file";
    public static final String ATTR_IMPORT_TEMPLATE_FILE = "ds-task-import-template-file";
    public static final String ATTR_IMPORT_RANDOM_SEED = "ds-task-import-random-seed";
    public static final String ATTR_IMPORT_APPEND = "ds-task-import-append";
    public static final String ATTR_IMPORT_REPLACE_EXISTING = "ds-task-import-replace-existing";
    public static final String ATTR_IMPORT_BACKEND_ID = "ds-task-import-backend-id";
    public static final String ATTR_IMPORT_INCLUDE_BRANCH = "ds-task-import-include-branch";
    public static final String ATTR_IMPORT_EXCLUDE_BRANCH = "ds-task-import-exclude-branch";
    public static final String ATTR_IMPORT_INCLUDE_ATTRIBUTE = "ds-task-import-include-attribute";
    public static final String ATTR_IMPORT_EXCLUDE_ATTRIBUTE = "ds-task-import-exclude-attribute";
    public static final String ATTR_IMPORT_INCLUDE_FILTER = "ds-task-import-include-filter";
    public static final String ATTR_IMPORT_EXCLUDE_FILTER = "ds-task-import-exclude-filter";
    public static final String ATTR_IMPORT_REJECT_FILE = "ds-task-import-reject-file";
    public static final String ATTR_IMPORT_SKIP_FILE = "ds-task-import-skip-file";
    public static final String ATTR_IMPORT_OVERWRITE = "ds-task-import-overwrite-rejects";
    public static final String ATTR_IMPORT_SKIP_SCHEMA_VALIDATION = "ds-task-import-skip-schema-validation";
    public static final String ATTR_IMPORT_IS_COMPRESSED = "ds-task-import-is-compressed";
    public static final String ATTR_IMPORT_IS_ENCRYPTED = "ds-task-import-is-encrypted";
    public static final String OC_INITIALIZE_TASK = "ds-task-initialize-from-remote-replica";
    public static final String ATTR_TASK_INITIALIZE_DOMAIN_DN = "ds-task-initialize-domain-dn";
    public static final String ATTR_TASK_INITIALIZE_SOURCE = "ds-task-initialize-replica-server-id";
    public static final String OC_INITIALIZE_TARGET_TASK = "ds-task-initialize-remote-replica";
    public static final String ATTR_TASK_INITIALIZE_TARGET_DOMAIN_DN = "ds-task-initialize-domain-dn";
    public static final String ATTR_TASK_INITIALIZE_TARGET_SCOPE = "ds-task-initialize-replica-server-id";
    public static final String ATTR_TASK_INITIALIZE_LEFT = "ds-task-unprocessed-entry-count";
    public static final String ATTR_TASK_INITIALIZE_DONE = "ds-task-processed-entry-count";
    public static final String OC_EXPORT_TASK = "ds-task-export";
    public static final String ATTR_TASK_EXPORT_LDIF_FILE = "ds-task-export-ldif-file";
    public static final String ATTR_TASK_EXPORT_APPEND_TO_LDIF = "ds-task-export-append-to-ldif";
    public static final String ATTR_TASK_EXPORT_BACKEND_ID = "ds-task-export-backend-id";
    public static final String ATTR_TASK_EXPORT_INCLUDE_BRANCH = "ds-task-export-include-branch";
    public static final String ATTR_TASK_EXPORT_EXCLUDE_BRANCH = "ds-task-export-exclude-branch";
    public static final String ATTR_TASK_EXPORT_INCLUDE_ATTRIBUTE = "ds-task-export-include-attribute";
    public static final String ATTR_TASK_EXPORT_EXCLUDE_ATTRIBUTE = "ds-task-export-exclude-attribute";
    public static final String ATTR_TASK_EXPORT_INCLUDE_FILTER = "ds-task-export-include-filter";
    public static final String ATTR_TASK_EXPORT_EXCLUDE_FILTER = "ds-task-export-exclude-filter";
    public static final String ATTR_TASK_EXPORT_WRAP_COLUMN = "ds-task-export-wrap-column";
    public static final String ATTR_TASK_EXPORT_INCLUDE_OPERATIONAL_ATTRIBUTES = "ds-task-export-include-operational-attributes";
    public static final String ATTR_TASK_EXPORT_COMPRESS_LDIF = "ds-task-export-compress-ldif";
    public static final String ATTR_TASK_EXPORT_ENCRYPT_LDIF = "ds-task-export-encrypt-ldif";
    public static final String ATTR_TASK_EXPORT_SIGN_HASH = "ds-task-export-sign-hash";
    public static final String OC_RESTORE_TASK = "ds-task-restore";
    public static final String ATTR_TASK_RESTORE_VERIFY_ONLY = "ds-task-restore-verify-only";
    public static final String OC_BACKUP_TASK = "ds-task-backup";
    public static final String ATTR_TASK_BACKUP_BACKEND_ID = "ds-task-backup-backend-id";
    public static final String ATTR_TASK_BACKUP_ALL = "ds-task-backup-all";
    public static final String ATTR_TASK_BACKUP_INCREMENTAL = "ds-task-backup-incremental";
    public static final String ATTR_TASK_BACKUP_INCREMENTAL_BASE_ID = "ds-task-backup-incremental-base-id";
    public static final String ATTR_TASK_BACKUP_COMPRESS = "ds-task-backup-compress";
    public static final String ATTR_TASK_BACKUP_ENCRYPT = "ds-task-backup-encrypt";
    public static final String ATTR_TASK_BACKUP_HASH = "ds-task-backup-hash";
    public static final String ATTR_TASK_BACKUP_SIGN_HASH = "ds-task-backup-sign-hash";
    public static final String ATTR_TASK_ADDSCHEMAFILE_FILENAME = "ds-task-schema-file-name";
    public static final String ATTR_LOGGER_DEBUG_SCOPE = "ds-task-debug-scope";
    public static final String ATTR_LOGGER_LEVEL = "ds-task-log-level";
    public static final String ATTR_LOGGER_ASYNC_WRITE = "ds-task-async-write";
    public static final String ATTR_REBUILD_BASE_DN = "ds-task-rebuild-base-dn";
    public static final String ATTR_REBUILD_INDEX = "ds-task-rebuild-index";
    public static final String ATTR_REBUILD_MAX_THREADS = "ds-task-rebuild-max-threads";
    public static final String OC_RESET_GENERATION_ID_TASK = "ds-task-reset-generation-id";
    public static final String ATTR_TASK_SET_GENERATION_ID_DOMAIN_DN = "ds-task-reset-generation-id-domain-base-dn";
    public static final String ATTR_TASK_SET_GENERATION_ID_NEW_VALUE = "ds-task-reset-generation-id-new-value";
    public static final String ATTR_IMPORT_CLEAR_BACKEND = "ds-task-import-clear-backend";
}

