/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.util.Map;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean exitRequested;
    private int threadID;
    private TaskScheduler taskScheduler;
    private Object notifyLock;

    public TaskThread(TaskScheduler taskScheduler, int threadID) {
        super("Task Thread " + threadID);
        this.taskScheduler = taskScheduler;
        this.threadID = threadID;
        this.notifyLock = new Object();
        this.exitRequested = false;
        this.setAssociatedTask(null);
    }

    public Task getTask() {
        return this.getAssociatedTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTask(Task task) {
        this.setAssociatedTask(task);
        Object object = this.notifyLock;
        synchronized (object) {
            this.notifyLock.notify();
        }
    }

    public void interruptTask(TaskState interruptState, Message interruptReason, boolean exitThread) {
        block4: {
            if (this.getAssociatedTask() != null) {
                try {
                    this.getAssociatedTask().interruptTask(interruptState, interruptReason);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        if (exitThread) {
            this.exitRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.exitRequested) {
            if (this.getAssociatedTask() == null) {
                try {
                    Object object = this.notifyLock;
                    synchronized (object) {
                        this.notifyLock.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    continue;
                }
            }
            try {
                TaskState returnState = this.getAssociatedTask().execute();
                this.getAssociatedTask().setTaskState(returnState);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Task task = this.getAssociatedTask();
                Message message = BackendMessages.ERR_TASK_EXECUTE_FAILED.get(String.valueOf(task.getTaskEntry().getDN()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                task.setTaskState(TaskState.STOPPED_BY_ERROR);
            }
            Task completedTask = this.getAssociatedTask();
            this.setAssociatedTask(null);
            if (this.taskScheduler.threadDone(this, completedTask)) continue;
            this.exitRequested = true;
            break;
        }
        if (this.getAssociatedTask() != null) {
            Task task = this.getAssociatedTask();
            task.setTaskState(TaskState.STOPPED_BY_SHUTDOWN);
            this.taskScheduler.threadDone(this, task);
        }
    }

    @Override
    public Map<String, String> getDebugProperties() {
        Map<String, String> properties = super.getDebugProperties();
        if (this.getAssociatedTask() != null) {
            properties.put("task", this.getAssociatedTask().toString());
        }
        return properties;
    }
}

