/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.io.Serializable;
import java.util.Comparator;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLVKeyComparator
implements Comparator<byte[]>,
Serializable {
    static final long serialVersionUID = 1585167927344130604L;
    private OrderingMatchingRule[] orderingRules;
    private boolean[] ascending;

    public VLVKeyComparator(OrderingMatchingRule[] orderingRules, boolean[] ascending) {
        this.orderingRules = orderingRules;
        this.ascending = ascending;
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        if (b1.length == 0) {
            if (b2.length == 0) {
                return 0;
            }
            return 1;
        }
        if (b2.length == 0) {
            return -1;
        }
        int b1Pos = 0;
        int b2Pos = 0;
        for (int j = 0; j < this.orderingRules.length && b1Pos < b1.length && b2Pos < b2.length; ++j) {
            byte[] b2Bytes;
            byte[] b1Bytes;
            int b2Length;
            int b1Length;
            if (b1[b1Pos++] != (b1Length = b1[b1Pos] & 0x7F)) {
                int b1NumLengthBytes = b1Length;
                b1Length = 0;
                int k = 0;
                while (k < b1NumLengthBytes) {
                    b1Length = b1Length << 8 | b1[b1Pos] & 0xFF;
                    ++k;
                    ++b1Pos;
                }
            }
            if (b2[b2Pos++] != (b2Length = b2[b2Pos] & 0x7F)) {
                int b2NumLengthBytes = b2Length;
                b2Length = 0;
                int k = 0;
                while (k < b2NumLengthBytes) {
                    b2Length = b2Length << 8 | b2[b2Pos] & 0xFF;
                    ++k;
                    ++b2Pos;
                }
            }
            if (b1Length > 0) {
                b1Bytes = new byte[b1Length];
                System.arraycopy(b1, b1Pos, b1Bytes, 0, b1Length);
                b1Pos += b1Length;
            } else {
                b1Bytes = null;
            }
            if (b2Length > 0) {
                b2Bytes = new byte[b2Length];
                System.arraycopy(b2, b2Pos, b2Bytes, 0, b2Length);
                b2Pos += b2Length;
            } else {
                b2Bytes = null;
            }
            if (b1Bytes == null) {
                if (b2Bytes == null) continue;
                return 1;
            }
            if (b2Bytes == null) {
                return -1;
            }
            int result = this.ascending[j] ? this.orderingRules[j].compare(b1Bytes, b2Bytes) : this.orderingRules[j].compare(b2Bytes, b1Bytes);
            if (result == 0) continue;
            return result;
        }
        if (b1Pos + 8 <= b1.length && b2Pos + 8 <= b2.length) {
            long b1ID = 0L;
            for (int i = b1Pos; i < b1Pos + 8; ++i) {
                b1ID <<= 8;
                b1ID |= (long)(b1[i] & 0xFF);
            }
            long b2ID = 0L;
            for (int i = b2Pos; i < b2Pos + 8; ++i) {
                b2ID <<= 8;
                b2ID |= (long)(b2[i] & 0xFF);
            }
            long idDifference = b1ID - b2ID;
            if (idDifference < 0L) {
                return -1;
            }
            if (idDifference > 0L) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public int compare(SortValuesSet set, int index, long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        for (int j = 0; j < this.orderingRules.length && j < values.length; ++j) {
            byte[] b1Bytes = set.getValue(index * this.orderingRules.length + j);
            byte[] b2Bytes = null;
            if (values[j] != null) {
                b2Bytes = values[j].getNormalizedValueBytes();
            }
            if (b1Bytes == null) {
                if (b2Bytes == null) continue;
                return 1;
            }
            if (b2Bytes == null) {
                return -1;
            }
            int result = this.ascending[j] ? this.orderingRules[j].compare(b1Bytes, b2Bytes) : this.orderingRules[j].compare(b2Bytes, b1Bytes);
            if (result == 0) continue;
            return result;
        }
        if (entryID != -1L) {
            long idDifference = set.getEntryIDs()[index] - entryID;
            if (idDifference < 0L) {
                return -1;
            }
            if (idDifference > 0L) {
                return 1;
            }
            return 0;
        }
        return 0;
    }
}

