/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class MonitorProvider<T extends MonitorProviderCfg>
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean stopRequested = false;
    private Thread monitorThread = null;

    protected MonitorProvider(String threadName) {
        super(threadName);
    }

    public abstract void initializeMonitorProvider(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(MonitorProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeMonitorProvider() {
        block3: {
            this.stopRequested = true;
            try {
                if (this.monitorThread != null) {
                    this.monitorThread.interrupt();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public abstract String getMonitorInstanceName();

    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("extensibleobject", true);
    }

    public abstract long getUpdateInterval();

    public abstract void updateMonitorData();

    public abstract List<Attribute> getMonitorData();

    @Override
    public final void run() {
        this.monitorThread = Thread.currentThread();
        if (this.getUpdateInterval() <= 0L) {
            return;
        }
        this.setName(this.getMonitorInstanceName() + " Monitor Provider");
        while (!this.stopRequested) {
            long stopSleepTime;
            block11: {
                stopSleepTime = System.currentTimeMillis() + this.getUpdateInterval();
                try {
                    this.updateMonitorData();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block11;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            long remainingSleepTime = stopSleepTime - System.currentTimeMillis();
            while (!this.stopRequested && remainingSleepTime > 0L) {
                if (remainingSleepTime > 1000L) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        Thread.sleep(remainingSleepTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                remainingSleepTime = stopSleepTime - System.currentTimeMillis();
            }
        }
    }
}

