/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReplicationServerCfgDefn
extends ManagedObjectDefinition<ReplicationServerCfgClient, ReplicationServerCfg> {
    private static final ReplicationServerCfgDefn INSTANCE = new ReplicationServerCfgDefn();
    private static final IntegerPropertyDefinition PD_QUEUE_SIZE;
    private static final StringPropertyDefinition PD_REPLICATION_DB_DIRECTORY;
    private static final IntegerPropertyDefinition PD_REPLICATION_PORT;
    private static final DurationPropertyDefinition PD_REPLICATION_PURGE_DELAY;
    private static final StringPropertyDefinition PD_REPLICATION_SERVER;
    private static final IntegerPropertyDefinition PD_REPLICATION_SERVER_ID;
    private static final IntegerPropertyDefinition PD_WINDOW_SIZE;

    public static ReplicationServerCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReplicationServerCfgDefn() {
        super("replication-server", TopCfgDefn.getInstance());
    }

    @Override
    public ReplicationServerCfgClient createClientConfiguration(ManagedObject<? extends ReplicationServerCfgClient> impl) {
        return new ReplicationServerCfgClientImpl(impl);
    }

    @Override
    public ReplicationServerCfg createServerConfiguration(ServerManagedObject<? extends ReplicationServerCfg> impl) {
        return new ReplicationServerCfgServerImpl(impl);
    }

    @Override
    public Class<ReplicationServerCfg> getServerConfigurationClass() {
        return ReplicationServerCfg.class;
    }

    public IntegerPropertyDefinition getQueueSizePropertyDefinition() {
        return PD_QUEUE_SIZE;
    }

    public StringPropertyDefinition getReplicationDBDirectoryPropertyDefinition() {
        return PD_REPLICATION_DB_DIRECTORY;
    }

    public IntegerPropertyDefinition getReplicationPortPropertyDefinition() {
        return PD_REPLICATION_PORT;
    }

    public DurationPropertyDefinition getReplicationPurgeDelayPropertyDefinition() {
        return PD_REPLICATION_PURGE_DELAY;
    }

    public StringPropertyDefinition getReplicationServerPropertyDefinition() {
        return PD_REPLICATION_SERVER;
    }

    public IntegerPropertyDefinition getReplicationServerIdPropertyDefinition() {
        return PD_REPLICATION_SERVER_ID;
    }

    public IntegerPropertyDefinition getWindowSizePropertyDefinition() {
        return PD_WINDOW_SIZE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "queue-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "queue-size"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("10000");
        builder.setDefaultBehaviorProvider(provider);
        PD_QUEUE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUEUE_SIZE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-db-directory");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-db-directory"));
        provider = new DefinedDefaultBehaviorProvider("changelogDb");
        builder.setDefaultBehaviorProvider(provider);
        PD_REPLICATION_DB_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_DB_DIRECTORY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "replication-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_REPLICATION_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_PORT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "replication-purge-delay");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-purge-delay"));
        provider = new DefinedDefaultBehaviorProvider("86400s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(false);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        PD_REPLICATION_PURGE_DELAY = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_PURGE_DELAY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "replication-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+:[0-9]+$", "HOST:PORT");
        PD_REPLICATION_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "replication-server-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "replication-server-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_REPLICATION_SERVER_ID = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REPLICATION_SERVER_ID);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "window-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "window-size"));
        provider = new DefinedDefaultBehaviorProvider("100");
        builder.setDefaultBehaviorProvider(provider);
        PD_WINDOW_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WINDOW_SIZE);
        INSTANCE.registerTag(Tag.valueOf("replication"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicationServerCfgServerImpl
    implements ReplicationServerCfg {
        private ServerManagedObject<? extends ReplicationServerCfg> impl;
        private final int pQueueSize;
        private final String pReplicationDBDirectory;
        private final int pReplicationPort;
        private final long pReplicationPurgeDelay;
        private final SortedSet<String> pReplicationServer;
        private final int pReplicationServerId;
        private final int pWindowSize;

        private ReplicationServerCfgServerImpl(ServerManagedObject<? extends ReplicationServerCfg> impl) {
            this.impl = impl;
            this.pQueueSize = impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
            this.pReplicationDBDirectory = impl.getPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition());
            this.pReplicationPort = impl.getPropertyValue(INSTANCE.getReplicationPortPropertyDefinition());
            this.pReplicationPurgeDelay = impl.getPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition());
            this.pReplicationServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getReplicationServerPropertyDefinition());
            this.pReplicationServerId = impl.getPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition());
            this.pWindowSize = impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ReplicationServerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ReplicationServerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getQueueSize() {
            return this.pQueueSize;
        }

        @Override
        public String getReplicationDBDirectory() {
            return this.pReplicationDBDirectory;
        }

        @Override
        public int getReplicationPort() {
            return this.pReplicationPort;
        }

        @Override
        public long getReplicationPurgeDelay() {
            return this.pReplicationPurgeDelay;
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.pReplicationServer;
        }

        @Override
        public int getReplicationServerId() {
            return this.pReplicationServerId;
        }

        @Override
        public int getWindowSize() {
            return this.pWindowSize;
        }

        @Override
        public Class<? extends ReplicationServerCfg> configurationClass() {
            return ReplicationServerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicationServerCfgClientImpl
    implements ReplicationServerCfgClient {
        private ManagedObject<? extends ReplicationServerCfgClient> impl;

        private ReplicationServerCfgClientImpl(ManagedObject<? extends ReplicationServerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public int getQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
        }

        @Override
        public void setQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getQueueSizePropertyDefinition(), value);
        }

        @Override
        public String getReplicationDBDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition());
        }

        @Override
        public void setReplicationDBDirectory(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getReplicationDBDirectoryPropertyDefinition(), value);
        }

        @Override
        public Integer getReplicationPort() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationPortPropertyDefinition());
        }

        @Override
        public void setReplicationPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getReplicationPortPropertyDefinition(), value);
        }

        @Override
        public long getReplicationPurgeDelay() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition());
        }

        @Override
        public void setReplicationPurgeDelay(Long value) {
            this.impl.setPropertyValue(INSTANCE.getReplicationPurgeDelayPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getReplicationServer() {
            return this.impl.getPropertyValues(INSTANCE.getReplicationServerPropertyDefinition());
        }

        @Override
        public void setReplicationServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getReplicationServerPropertyDefinition(), values);
        }

        @Override
        public Integer getReplicationServerId() {
            return this.impl.getPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition());
        }

        @Override
        public void setReplicationServerId(int value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getReplicationServerIdPropertyDefinition(), value);
        }

        @Override
        public int getWindowSize() {
            return this.impl.getPropertyValue(INSTANCE.getWindowSizePropertyDefinition());
        }

        @Override
        public void setWindowSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getWindowSizePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ReplicationServerCfgClient, ? extends ReplicationServerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

