/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.server.ConfigAddListenerAdaptor;
import org.opends.server.admin.server.ConfigChangeListenerAdaptor;
import org.opends.server.admin.server.ConfigDeleteListenerAdaptor;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ConstraintViolationException;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.DelayedConfigAddListener;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObjectAddListener;
import org.opends.server.admin.server.ServerManagedObjectAddListenerAdaptor;
import org.opends.server.admin.server.ServerManagedObjectChangeListener;
import org.opends.server.admin.server.ServerManagedObjectChangeListenerAdaptor;
import org.opends.server.admin.server.ServerManagedObjectDeleteListener;
import org.opends.server.admin.server.ServerManagedObjectDeleteListenerAdaptor;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerManagedObject<S extends Configuration>
implements PropertyProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConfigEntry configEntry;
    private final ServerManagementContext context = ServerManagementContext.getInstance();
    private final ManagedObjectDefinition<?, S> definition;
    private final ManagedObjectPath<?, S> path;
    private final Map<PropertyDefinition<?>, SortedSet<?>> properties;

    ServerManagedObject(ManagedObjectPath<?, S> path, ManagedObjectDefinition<?, S> d, Map<PropertyDefinition<?>, SortedSet<?>> properties, ConfigEntry configEntry) {
        this.definition = d;
        this.path = path;
        this.properties = properties;
        this.configEntry = configEntry;
    }

    public <M extends Configuration> void deregisterAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterAddListener(baseDN, listener);
    }

    public void deregisterChangeListener(ConfigurationChangeListener<? super S> listener) {
        for (ConfigChangeListener l : this.configEntry.getChangeListeners()) {
            ServerManagedObjectChangeListenerAdaptor adaptor2;
            ConfigChangeListenerAdaptor adaptor;
            ServerManagedObjectChangeListener l2;
            if (!(l instanceof ConfigChangeListenerAdaptor) || !((l2 = (adaptor = (ConfigChangeListenerAdaptor)l).getServerManagedObjectChangeListener()) instanceof ServerManagedObjectChangeListenerAdaptor) || (adaptor2 = (ServerManagedObjectChangeListenerAdaptor)l2).getConfigurationChangeListener() != listener) continue;
            adaptor.finalizeChangeListener();
            this.configEntry.deregisterChangeListener(adaptor);
        }
    }

    public void deregisterChangeListener(ServerManagedObjectChangeListener<? super S> listener) {
        for (ConfigChangeListener l : this.configEntry.getChangeListeners()) {
            ConfigChangeListenerAdaptor adaptor;
            if (!(l instanceof ConfigChangeListenerAdaptor) || (adaptor = (ConfigChangeListenerAdaptor)l).getServerManagedObjectChangeListener() != listener) continue;
            adaptor.finalizeChangeListener();
            this.configEntry.deregisterChangeListener(adaptor);
        }
    }

    public <M extends Configuration> void deregisterDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(InstantiableRelationDefinition<?, M> d, String name) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        return this.context.getManagedObject(this.path.child(d, name));
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(OptionalRelationDefinition<?, M> d) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        return this.context.getManagedObject(this.path.child(d));
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(SingletonRelationDefinition<?, M> d) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        return this.context.getManagedObject(this.path.child(d));
    }

    public S getConfiguration() {
        return this.definition.createServerConfiguration(this);
    }

    public DN getDN() {
        if (this.configEntry != null) {
            return this.configEntry.getDN();
        }
        return DN.nullDN();
    }

    public ManagedObjectDefinition<?, S> getManagedObjectDefinition() {
        return this.definition;
    }

    public ManagedObjectPath<?, S> getManagedObjectPath() {
        return this.path;
    }

    public <T> T getPropertyValue(PropertyDefinition<T> d) throws IllegalArgumentException {
        Collection values = this.getPropertyValues((PropertyDefinition)d);
        if (values.isEmpty()) {
            return null;
        }
        return (T)values.iterator().next();
    }

    public <T> SortedSet<T> getPropertyValues(PropertyDefinition<T> d) throws IllegalArgumentException {
        if (!this.properties.containsKey(d)) {
            throw new IllegalArgumentException("Unknown property " + d.getName());
        }
        return Collections.unmodifiableSortedSet(this.properties.get(d));
    }

    public boolean hasChild(OptionalRelationDefinition<?, ?> d) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        return this.context.managedObjectExists(this.path.child(d));
    }

    public String[] listChildren(InstantiableRelationDefinition<?, ?> d) throws IllegalArgumentException {
        this.validateRelationDefinition(d);
        return this.context.listManagedObjects(this.path, d);
    }

    public <M extends Configuration> void registerAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.registerAddListener(d, new ServerManagedObjectAddListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerAddListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.registerAddListener(d, new ServerManagedObjectAddListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerAddListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public void registerChangeListener(ConfigurationChangeListener<? super S> listener) {
        this.registerChangeListener(new ServerManagedObjectChangeListenerAdaptor<S>(listener));
    }

    public void registerChangeListener(ServerManagedObjectChangeListener<? super S> listener) {
        ConfigChangeListenerAdaptor<? super S> adaptor = new ConfigChangeListenerAdaptor<S>(this.path, listener);
        this.configEntry.registerChangeListener(adaptor);
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    handler.performPostAdd(this);
                }
                catch (ConfigException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public <M extends Configuration> void registerDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.registerDeleteListener(d, new ServerManagedObjectDeleteListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerDeleteListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.registerDeleteListener(d, new ServerManagedObjectDeleteListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerDeleteListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws IllegalArgumentException, ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).getParent();
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ TYPE=");
        builder.append(this.definition.getName());
        builder.append(", DN=\"");
        builder.append(this.getDN());
        builder.append('\"');
        for (Map.Entry<PropertyDefinition<?>, SortedSet<?>> value : this.properties.entrySet()) {
            builder.append(", ");
            builder.append(value.getKey().getName());
            builder.append('=');
            builder.append(value.getValue());
        }
        builder.append(" }");
        return builder.toString();
    }

    void ensureIsUsable() throws ConstraintViolationException {
        boolean isUsable = true;
        LinkedList<Message> reasons = new LinkedList<Message>();
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    if (handler.isUsable(this, reasons)) continue;
                    isUsable = false;
                }
                catch (ConfigException e) {
                    Message message = AdminMessages.ERR_SERVER_CONSTRAINT_EXCEPTION.get(e.getMessageObject());
                    reasons.add(message);
                    isUsable = false;
                }
            }
        }
        if (!isUsable) {
            throw new ConstraintViolationException(this, reasons);
        }
    }

    void setConfigEntry(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    private <M extends Configuration> void deregisterAddListener(DN baseDN, ConfigurationAddListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigAddListener l : configEntry.getAddListeners()) {
                        ServerManagedObjectAddListenerAdaptor adaptor2;
                        ConfigAddListenerAdaptor adaptor;
                        ServerManagedObjectAddListener l2;
                        if (!(l instanceof ConfigAddListenerAdaptor) || !((l2 = (adaptor = (ConfigAddListenerAdaptor)l).getServerManagedObjectAddListener()) instanceof ServerManagedObjectAddListenerAdaptor) || (adaptor2 = (ServerManagedObjectAddListenerAdaptor)l2).getConfigurationAddListener() != listener) continue;
                        configEntry.deregisterAddListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private <M extends Configuration> void deregisterAddListener(DN baseDN, ServerManagedObjectAddListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigAddListener l : configEntry.getAddListeners()) {
                        ConfigAddListenerAdaptor adaptor;
                        if (!(l instanceof ConfigAddListenerAdaptor) || (adaptor = (ConfigAddListenerAdaptor)l).getServerManagedObjectAddListener() != listener) continue;
                        configEntry.deregisterAddListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private <M extends Configuration> void deregisterDeleteListener(DN baseDN, ConfigurationDeleteListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigDeleteListener l : configEntry.getDeleteListeners()) {
                        ServerManagedObjectDeleteListenerAdaptor adaptor2;
                        ConfigDeleteListenerAdaptor adaptor;
                        ServerManagedObjectDeleteListener l2;
                        if (!(l instanceof ConfigDeleteListenerAdaptor) || !((l2 = (adaptor = (ConfigDeleteListenerAdaptor)l).getServerManagedObjectDeleteListener()) instanceof ServerManagedObjectDeleteListenerAdaptor) || (adaptor2 = (ServerManagedObjectDeleteListenerAdaptor)l2).getConfigurationDeleteListener() != listener) continue;
                        configEntry.deregisterDeleteListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private <M extends Configuration> void deregisterDeleteListener(DN baseDN, ServerManagedObjectDeleteListener<M> listener) {
        block4: {
            try {
                ConfigEntry configEntry = this.getListenerConfigEntry(baseDN);
                if (configEntry != null) {
                    for (ConfigDeleteListener l : configEntry.getDeleteListeners()) {
                        ConfigDeleteListenerAdaptor adaptor;
                        if (!(l instanceof ConfigDeleteListenerAdaptor) || (adaptor = (ConfigDeleteListenerAdaptor)l).getServerManagedObjectDeleteListener() != listener) continue;
                        configEntry.deregisterDeleteListener(adaptor);
                    }
                }
            }
            catch (ConfigException e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private ConfigEntry getListenerConfigEntry(DN dn) throws ConfigException {
        ConfigEntry configEntry;
        try {
            configEntry = DirectoryServer.getConfigEntry(dn);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_LISTENER_BASE.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return configEntry;
    }

    private void registerAddListener(DN baseDN, ConfigAddListener adaptor) throws IllegalArgumentException, ConfigException {
        ConfigEntry relationEntry = this.getListenerConfigEntry(baseDN);
        if (relationEntry != null) {
            relationEntry.registerAddListener(adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void registerDelayedListener(DN baseDN, ConfigAddListener delayedListener) throws ConfigException {
        for (DN parentDN = baseDN.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            ConfigEntry relationEntry = this.getListenerConfigEntry(parentDN);
            if (relationEntry == null) {
                delayedListener = new DelayedConfigAddListener(parentDN, delayedListener);
                continue;
            }
            relationEntry.registerAddListener(delayedListener);
            return;
        }
        Message message = AdminMessages.ERR_ADMIN_UNABLE_TO_REGISTER_LISTENER.get(String.valueOf(baseDN));
        throw new ConfigException(message);
    }

    private void registerDeleteListener(DN baseDN, ConfigDeleteListener adaptor) throws ConfigException {
        ConfigEntry relationEntry = this.getListenerConfigEntry(baseDN);
        if (relationEntry != null) {
            relationEntry.registerDeleteListener(adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        RelationDefinition<?, ?> tmp = this.definition.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + this.definition.getName());
        }
    }
}

