/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.LinkedList;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.server.AbstractConfigListenerAdaptor;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.server.ServerManagedObjectDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigDeleteListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigDeleteListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final InstantiableRelationDefinition<?, S> instantiableRelation;
    private final ServerManagedObjectDeleteListener<S> listener;
    private final OptionalRelationDefinition<?, S> optionalRelation;
    private final ManagedObjectPath<?, ?> path;

    public ConfigDeleteListenerAdaptor(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, S> relation, ServerManagedObjectDeleteListener<S> listener) {
        this.path = path;
        this.optionalRelation = null;
        this.instantiableRelation = relation;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigDeleteListenerAdaptor(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, S> relation, ServerManagedObjectDeleteListener<S> listener) {
        this.path = path;
        this.optionalRelation = relation;
        this.instantiableRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        ConfigChangeResult result;
        if (this.optionalRelation != null) {
            ManagedObjectPath<?, S> childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!configEntry.getDN().equals(expectedDN)) {
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
        }
        if ((result = this.listener.applyConfigurationDelete(this.cachedManagedObject)).getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostDelete(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
        ManagedObjectPath<?, S> childPath;
        DN dn = configEntry.getDN();
        AttributeValue av = dn.getRDN().getAttributeValue(0);
        String name = av.getStringValue().trim();
        if (this.instantiableRelation != null) {
            childPath = this.path.child(this.instantiableRelation, name);
        } else {
            childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!dn.equals(expectedDN)) {
                return true;
            }
        }
        try {
            ServerManagementContext context = ServerManagementContext.getInstance();
            this.cachedManagedObject = context.decode(childPath, configEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        LinkedList<Message> reasons = new LinkedList<Message>();
        boolean isDeleteAllowed = true;
        ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
        for (Constraint constraint : d.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    if (handler.isDeleteAllowed(this.cachedManagedObject, reasons)) continue;
                    isDeleteAllowed = false;
                }
                catch (ConfigException e) {
                    Message message = AdminMessages.ERR_SERVER_CONSTRAINT_EXCEPTION.get(e.getMessageObject());
                    reasons.add(message);
                    isDeleteAllowed = false;
                }
            }
        }
        if (!isDeleteAllowed) {
            this.generateUnacceptableReason(reasons, unacceptableReason);
            return false;
        }
        if (this.listener.isConfigurationDeleteAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ServerManagedObjectDeleteListener<S> getServerManagedObjectDeleteListener() {
        return this.listener;
    }
}

