/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringPropertyDefinition
extends PropertyDefinition<String> {
    private final boolean isCaseInsensitive;
    private final Pattern pattern;
    private final String patternUsage;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private StringPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, boolean isCaseInsensitive, Pattern pattern, String patternUsage) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.isCaseInsensitive = isCaseInsensitive;
        this.pattern = pattern;
        this.patternUsage = patternUsage;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitString(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitString(this, value, p);
    }

    @Override
    public String decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            this.validateValue(value);
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        return value;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Message getPatternSynopsis() {
        return this.getPatternSynopsis(Locale.getDefault());
    }

    public Message getPatternSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.string.pattern.synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getPatternUsage() {
        return this.patternUsage;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    @Override
    public String normalizeValue(String value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
        if (this.isCaseInsensitive()) {
            return value.trim().toLowerCase();
        }
        return value.trim();
    }

    @Override
    public void validateValue(String value) throws IllegalPropertyValueException {
        Matcher matcher;
        Validator.ensureNotNull(value);
        if (this.pattern != null && !(matcher = this.pattern.matcher(value)).matches()) {
            throw new IllegalPropertyValueException(this, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends PropertyDefinition.AbstractBuilder<String, StringPropertyDefinition> {
        private boolean isCaseInsensitive = true;
        private Pattern pattern = null;
        private String patternUsage = null;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setCaseInsensitive(boolean value) {
            this.isCaseInsensitive = value;
        }

        public final void setPattern(String pattern, String patternUsage) throws PatternSyntaxException {
            if (pattern == null) {
                this.pattern = null;
                this.patternUsage = null;
            } else {
                this.pattern = Pattern.compile(pattern);
                this.patternUsage = patternUsage;
            }
        }

        @Override
        protected StringPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            return new StringPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.isCaseInsensitive, this.pattern, this.patternUsage);
        }
    }
}

