/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanPropertyDefinition
extends PropertyDefinition<Boolean> {
    private static final Map<String, Boolean> VALUE_MAP = new HashMap<String, Boolean>();

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private BooleanPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Boolean> defaultBehavior) {
        super(d, Boolean.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(Boolean value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
    }

    @Override
    public Boolean decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        String nvalue = value.trim().toLowerCase();
        Boolean b = VALUE_MAP.get(nvalue);
        if (b == null) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        return b;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitBoolean(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Boolean value, P p) {
        return v.visitBoolean(this, value, p);
    }

    @Override
    public int compare(Boolean o1, Boolean o2) {
        return o1.compareTo(o2);
    }

    static {
        VALUE_MAP.put("false", Boolean.FALSE);
        VALUE_MAP.put("true", Boolean.TRUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends PropertyDefinition.AbstractBuilder<Boolean, BooleanPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected BooleanPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Boolean> defaultBehavior) {
            return new BooleanPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

