/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixesToReplicatePanel
extends QuickSetupStepPanel
implements Comparator<SuffixDescriptor> {
    private static final long serialVersionUID = -8051367953737385327L;
    private Component lastFocusComponent;
    private UserData defaultUserData;
    private TreeSet<SuffixDescriptor> orderedSuffixes = new TreeSet<SuffixDescriptor>(this);
    private HashMap<String, JCheckBox> hmCheckBoxes = new HashMap();
    private Set<JEditorPane> suffixLabels = new HashSet<JEditorPane>();
    private String serverToConnectDisplay = null;
    private JRadioButton rbCreateNewSuffix;
    private JRadioButton rbReplicate;
    private JLabel noSuffixLabel;
    private Component labelGlue;
    private JPanel checkBoxPanel;
    private JScrollPane scroll;

    public SuffixesToReplicatePanel(GuiApplication application) {
        super(application);
        this.defaultUserData = application.getUserData();
        this.createComponents();
        this.addFocusListeners();
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        Object value = null;
        if (fieldName == FieldName.SUFFIXES_TO_REPLICATE_OPTIONS) {
            value = this.rbCreateNewSuffix.isSelected() ? SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY : SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES;
        } else if (fieldName == FieldName.SUFFIXES_TO_REPLICATE) {
            HashSet<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
            for (SuffixDescriptor suffix : this.orderedSuffixes) {
                if (!this.hmCheckBoxes.get(suffix.getId()).isSelected()) continue;
                suffixes.add(suffix);
            }
            value = suffixes;
        }
        return value;
    }

    @Override
    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        if (fieldName == FieldName.SUFFIXES_TO_REPLICATE) {
            UIFactory.TextStyle style = invalid ? UIFactory.TextStyle.SECONDARY_FIELD_INVALID : UIFactory.TextStyle.SECONDARY_FIELD_VALID;
            UIFactory.setTextStyle(this.rbReplicate, style);
        }
    }

    @Override
    public int compare(SuffixDescriptor desc1, SuffixDescriptor desc2) {
        int result = 0;
        result = this.compareSuffixDN(desc1, desc2);
        if (result == 0) {
            result = this.compareSuffixStrings(desc1, desc2);
        }
        return result;
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        panel.add((Component)this.rbCreateNewSuffix, gbc);
        gbc.insets.top = 0;
        panel.add((Component)this.rbReplicate, gbc);
        gbc.insets.top = 5;
        gbc.insets.left = 30;
        this.checkBoxPanel = new JPanel(new GridBagLayout());
        this.checkBoxPanel.setOpaque(false);
        gbc.insets.top = 0;
        gbc.anchor = 11;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.scroll = new JScrollPane(this.checkBoxPanel);
        this.scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroll.setOpaque(false);
        this.scroll.getViewport().setOpaque(false);
        panel.add((Component)this.scroll, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets.top = 5;
        gbc.anchor = 12;
        panel.add((Component)this.noSuffixLabel, gbc);
        this.noSuffixLabel.setVisible(false);
        this.labelGlue = Box.createVerticalGlue();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        panel.add(this.labelGlue, gbc);
        this.labelGlue.setVisible(false);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return QuickSetupMessages.INFO_SUFFIXES_TO_REPLICATE_PANEL_INSTRUCTIONS.get();
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_SUFFIXES_TO_REPLICATE_PANEL_TITLE.get();
    }

    @Override
    public void beginDisplay(UserData data) {
        TreeSet<SuffixDescriptor> array = this.orderSuffixes(data.getSuffixesToReplicateOptions().getAvailableSuffixes());
        AuthenticationData authData = data.getReplicationOptions().getAuthenticationData();
        String newServerDisplay = data != null ? authData.getHostName() + ":" + authData.getPort() : "";
        if (!array.equals(this.orderedSuffixes) || !newServerDisplay.equals(this.serverToConnectDisplay)) {
            this.serverToConnectDisplay = newServerDisplay;
            HashMap<String, Boolean> hmOldValues = new HashMap<String, Boolean>();
            for (String id : this.hmCheckBoxes.keySet()) {
                hmOldValues.put(id, this.hmCheckBoxes.get(id).isSelected());
            }
            this.orderedSuffixes.clear();
            for (SuffixDescriptor suffix : array) {
                if (Utils.areDnsEqual(suffix.getDN(), ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(suffix.getDN(), "cn=schema") || Utils.areDnsEqual(suffix.getDN(), "dc=replicationChanges")) continue;
                this.orderedSuffixes.add(suffix);
            }
            this.hmCheckBoxes.clear();
            for (SuffixDescriptor suffix : this.orderedSuffixes) {
                JCheckBox cb = UIFactory.makeJCheckBox(Message.raw(suffix.getDN(), new Object[0]), QuickSetupMessages.INFO_SUFFIXES_TO_REPLICATE_DN_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
                cb.setOpaque(false);
                Boolean v = (Boolean)hmOldValues.get(suffix.getId());
                if (v != null) {
                    cb.setSelected(v);
                }
                cb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        if (((JCheckBox)ev.getSource()).isSelected()) {
                            SuffixesToReplicatePanel.this.rbReplicate.setSelected(true);
                        }
                    }
                });
                this.hmCheckBoxes.put(suffix.getId(), cb);
            }
            this.populateCheckBoxPanel();
        }
        boolean display = this.orderedSuffixes.size() > 0;
        this.noSuffixLabel.setVisible(!display);
        this.labelGlue.setVisible(!display);
        this.scroll.setVisible(display);
        if (!display) {
            this.rbCreateNewSuffix.setSelected(true);
        }
        this.rbReplicate.setEnabled(display);
        this.checkEnablingState();
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    private void createComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbCreateNewSuffix = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_CREATE_NEW_SUFFIX_LABEL.get(), QuickSetupMessages.INFO_CREATE_NEW_SUFFIX_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbCreateNewSuffix.setOpaque(false);
        this.rbReplicate = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_REPLICATE_WITH_SUFFIXES_LABEL.get(), QuickSetupMessages.INFO_REPLICATE_WITH_SUFFIXES_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbReplicate.setOpaque(false);
        buttonGroup.add(this.rbCreateNewSuffix);
        buttonGroup.add(this.rbReplicate);
        SuffixesToReplicateOptions.Type type = this.defaultUserData.getSuffixesToReplicateOptions().getType();
        this.rbCreateNewSuffix.setSelected(type == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY);
        this.rbReplicate.setSelected(type == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES);
        this.noSuffixLabel = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_SUFFIX_LIST_EMPTY.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SuffixesToReplicatePanel.this.checkEnablingState();
                ButtonEvent be = new ButtonEvent(ev.getSource(), ButtonName.INPUT_PANEL_BUTTON);
                SuffixesToReplicatePanel.this.notifyButtonListeners(be);
            }
        };
        this.rbCreateNewSuffix.addActionListener(l);
        this.rbReplicate.addActionListener(l);
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            public void focusGained(FocusEvent e) {
                SuffixesToReplicatePanel.this.lastFocusComponent = e.getComponent();
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.rbReplicate.addFocusListener(l);
        this.rbCreateNewSuffix.addFocusListener(l);
        this.lastFocusComponent = this.rbReplicate;
    }

    private void populateCheckBoxPanel() {
        this.checkBoxPanel.removeAll();
        this.suffixLabels.clear();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 11;
        boolean first = true;
        for (SuffixDescriptor suffix : this.orderedSuffixes) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            if (!first) {
                gbc.insets.top = 5;
            }
            gbc.gridwidth = -1;
            JCheckBox cb = this.hmCheckBoxes.get(suffix.getId());
            cb.setVerticalAlignment(1);
            this.checkBoxPanel.add((Component)cb, gbc);
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            JEditorPane l = UIFactory.makeTextPane(Message.raw(this.getSuffixString(suffix), new Object[0]), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
            l.setOpaque(false);
            this.suffixLabels.add(l);
            JEditorPane proto = UIFactory.makeTextPane(Message.raw(suffix.getDN(), new Object[0]), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
            gbc.insets.top += Math.abs(cb.getPreferredSize().height - proto.getPreferredSize().height) / 2;
            this.checkBoxPanel.add((Component)l, gbc);
            first = false;
        }
        this.addVerticalGlue(this.checkBoxPanel);
    }

    private String getSuffixString(SuffixDescriptor desc) {
        TreeSet<Message> replicaDisplays = new TreeSet<Message>();
        for (ReplicaDescriptor rep : desc.getReplicas()) {
            replicaDisplays.add(this.getReplicaDisplay(rep));
        }
        MessageBuilder buf = new MessageBuilder();
        for (Message display : replicaDisplays) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(display);
        }
        return buf.toString();
    }

    private Message getReplicaDisplay(ReplicaDescriptor replica) {
        ServerDescriptor server = replica.getServer();
        String serverDisplay = server.getHostPort(false).equalsIgnoreCase(this.serverToConnectDisplay) ? this.serverToConnectDisplay : server.getHostPort(true);
        int nEntries = replica.getEntries();
        Message display = nEntries > 0 ? QuickSetupMessages.INFO_SUFFIX_LIST_REPLICA_DISPLAY_ENTRIES.get(serverDisplay, String.valueOf(nEntries)) : (nEntries == 0 ? QuickSetupMessages.INFO_SUFFIX_LIST_REPLICA_DISPLAY_NO_ENTRIES.get(serverDisplay) : QuickSetupMessages.INFO_SUFFIX_LIST_REPLICA_DISPLAY_ENTRIES_NOT_AVAILABLE.get(serverDisplay));
        return display;
    }

    private TreeSet<SuffixDescriptor> orderSuffixes(Set<SuffixDescriptor> suffixes) {
        TreeSet<SuffixDescriptor> ordered = new TreeSet<SuffixDescriptor>(this);
        ordered.addAll(suffixes);
        return ordered;
    }

    private int compareSuffixDN(SuffixDescriptor desc1, SuffixDescriptor desc2) {
        return desc1.getDN().compareTo(desc2.getDN());
    }

    private int compareSuffixStrings(SuffixDescriptor desc1, SuffixDescriptor desc2) {
        return this.getSuffixString(desc1).compareTo(this.getSuffixString(desc2));
    }

    private void checkEnablingState() {
        boolean enable = this.rbReplicate.isSelected();
        for (JCheckBox cb : this.hmCheckBoxes.values()) {
            cb.setEnabled(enable);
        }
        for (JEditorPane p : this.suffixLabels) {
            p.setEnabled(enable);
        }
        this.noSuffixLabel.setEnabled(enable);
    }
}

