/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class QuickSetupLog {
    public static final String LOG_FILE_SUFFIX = ".log";
    private static File logFile = null;
    private static FileHandler fileHandler = null;

    public static void initLogFileHandler(File file) throws IOException {
        if (!QuickSetupLog.isInitialized()) {
            logFile = file;
            fileHandler = new FileHandler(logFile.getCanonicalPath());
            fileHandler.setFormatter(new SimpleFormatter());
            Logger logger = Logger.getLogger("org.opends.quicksetup");
            logger.addHandler(fileHandler);
            logger = Logger.getLogger("org.opends.admin.ads");
            logger.addHandler(fileHandler);
            logger = Logger.getLogger("org.opends.server.admin.client.cli");
            logger.addHandler(fileHandler);
            QuickSetupLog.disableConsoleLogging();
            logger = Logger.getLogger("org.opends.quicksetup");
            logger.log(Level.INFO, QuickSetupLog.getInitialLogRecord());
        }
    }

    public static void initLogFileHandler(File file, String packageName) throws IOException {
        QuickSetupLog.initLogFileHandler(file);
        Logger logger = Logger.getLogger(packageName);
        logger.addHandler(fileHandler);
        logger.setUseParentHandlers(false);
    }

    public static void disableConsoleLogging() {
        Logger logger = Logger.getLogger("org.opends.quicksetup");
        logger.setUseParentHandlers(false);
        logger = Logger.getLogger("org.opends.admin.ads");
        logger.setUseParentHandlers(false);
        logger = Logger.getLogger("org.opends.server.tools");
        logger.setUseParentHandlers(false);
        logger = Logger.getLogger("org.opends.server.admin.client.cli");
        logger.setUseParentHandlers(false);
    }

    public static File getLogFile() {
        return logFile;
    }

    public static boolean isInitialized() {
        return logFile != null;
    }

    private static String getInitialLogRecord() {
        StringBuilder sb = new StringBuilder().append("QuickSetup application launched " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
        return sb.toString();
    }
}

