/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFromLDAP {
    private HashSet<ListenerDescriptor> listeners = new HashSet();
    private HashSet<DatabaseDescriptor> databases = new HashSet();
    private HashSet<String> administrativeUsers = new HashSet();
    private Message errorMessage;
    private boolean replicationConfigured = false;
    private ArrayList<String> replicatedSuffixes = new ArrayList();
    private HashMap<String, Integer> hmMissingChanges = new HashMap();
    private HashMap<String, Long> hmAgeOfOldestMissingChanges = new HashMap();
    private static final Logger LOG = Logger.getLogger(ConfigFromLDAP.class.getName());
    private String dn;
    private String pwd;
    private String lastUrl;
    private ConnectionProtocolPolicy policy;
    private ConfigFromFile offlineConf;
    private TrustManager trustManager;
    private InitialLdapContext ctx;
    private String javaVersion;
    private int openConnections = -1;

    public void setConnectionInfo(ConfigFromFile offlineConf, ConnectionProtocolPolicy policy, String dn, String pwd, TrustManager trustManager) throws ConfigException {
        if (offlineConf == null) {
            throw new IllegalArgumentException("offlineConf cannot be null.");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy cannot be null.");
        }
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null.");
        }
        if (pwd == null) {
            throw new IllegalArgumentException("pwd cannot be null.");
        }
        this.trustManager = trustManager;
        this.offlineConf = offlineConf;
        this.policy = policy;
        String ldapUrl = offlineConf.getURL(policy);
        if (!(Utils.areDnsEqual(dn, this.dn) && pwd.equals(this.pwd) && policy == this.policy && ldapUrl.equals(this.lastUrl) || this.ctx == null)) {
            try {
                this.ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.ctx = null;
        }
        this.lastUrl = ldapUrl;
        this.dn = dn;
        this.pwd = pwd;
    }

    public void closeConnection() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void readConfiguration() {
        this.errorMessage = null;
        this.listeners.clear();
        this.databases.clear();
        this.administrativeUsers.clear();
        this.replicationConfigured = false;
        this.replicatedSuffixes.clear();
        this.hmMissingChanges.clear();
        this.hmAgeOfOldestMissingChanges.clear();
        this.javaVersion = null;
        this.openConnections = -1;
        try {
            InitialLdapContext ctx = this.getDirContext();
            this.updateAdministrativeUsers(ctx);
            this.updateListeners(ctx);
            this.updateReplication(ctx);
            this.updateDatabases(ctx);
            this.javaVersion = this.getJavaVersion(ctx);
            this.openConnections = this.getOpenConnections(ctx);
        }
        catch (NamingException ne) {
            String detail = ne.getMessage() != null ? ne.getMessage() : ne.toString();
            this.errorMessage = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE.get(detail) : AdminToolMessages.ERR_READING_CONFIG_LDAP.get(detail);
            if (this.listeners.isEmpty()) {
                this.listeners.addAll(this.offlineConf.getListeners());
            }
            if (this.databases.isEmpty()) {
                this.databases.addAll(this.offlineConf.getDatabases());
            }
            if (this.administrativeUsers.isEmpty()) {
                this.administrativeUsers.addAll(this.offlineConf.getAdministrativeUsers());
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Unexpected error reading configuration: " + t, t);
            this.errorMessage = AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString());
        }
    }

    public HashSet<String> getAdministrativeUsers() {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(this.administrativeUsers);
        return copy;
    }

    public HashSet<DatabaseDescriptor> getDatabases() {
        HashSet<DatabaseDescriptor> copy = new HashSet<DatabaseDescriptor>();
        copy.addAll(this.databases);
        return copy;
    }

    public HashSet<ListenerDescriptor> getListeners() {
        HashSet<ListenerDescriptor> copy = new HashSet<ListenerDescriptor>();
        copy.addAll(this.listeners);
        return copy;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public int getOpenConnections() {
        return this.openConnections;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    private InitialLdapContext getDirContext() throws NamingException, ConfigException {
        if (this.ctx != null) {
            try {
                this.pingDirContext(this.ctx);
            }
            catch (NamingException ne) {
                try {
                    this.ctx.close();
                }
                catch (NamingException xx) {
                    // empty catch block
                }
                this.ctx = null;
            }
        }
        if (this.ctx == null) {
            String ldapUrl = this.offlineConf.getLDAPURL();
            String startTlsUrl = this.offlineConf.getStartTLSURL();
            String ldapsUrl = this.offlineConf.getLDAPSURL();
            switch (this.policy) {
                case USE_STARTTLS: {
                    if (startTlsUrl != null) {
                        this.ctx = Utils.createStartTLSContext(startTlsUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null, this.trustManager, null);
                        break;
                    }
                    throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                case USE_LDAPS: {
                    if (ldapsUrl != null) {
                        this.ctx = Utils.createLdapsContext(ldapsUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null, this.trustManager);
                        break;
                    }
                    throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                case USE_LDAP: {
                    if (ldapUrl != null) {
                        this.ctx = Utils.createLdapContext(ldapUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null);
                        break;
                    }
                    throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                case USE_MOST_SECURE_AVAILABLE: {
                    if (ldapsUrl != null) {
                        this.ctx = Utils.createLdapsContext(ldapsUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null, this.trustManager);
                        break;
                    }
                    if (startTlsUrl != null) {
                        this.ctx = Utils.createStartTLSContext(startTlsUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null, this.trustManager, null);
                        break;
                    }
                    if (ldapUrl != null) {
                        this.ctx = Utils.createLdapContext(ldapUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null);
                        break;
                    }
                    throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                case USE_LESS_SECURE_AVAILABLE: {
                    if (ldapUrl != null) {
                        this.ctx = Utils.createLdapContext(ldapUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null);
                        break;
                    }
                    if (ldapsUrl != null) {
                        this.ctx = Utils.createLdapsContext(ldapsUrl, this.dn, this.pwd, Utils.getDefaultLDAPTimeout(), null, this.trustManager);
                        break;
                    }
                    throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                default: {
                    throw new IllegalStateException("Unknown connection policy: " + (Object)((Object)this.policy));
                }
            }
        }
        return this.ctx;
    }

    private void pingDirContext(InitialLdapContext ctx) throws NamingException {
        SearchControls sc = new SearchControls(0, 0L, 0, new String[0], false, false);
        ctx.search("", "objectclass=*", sc);
    }

    private void updateListeners(InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "objectclass"});
        String filter = "(objectclass=ds-cfg-connection-handler)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            this.updateConfigWithConnectionHandler(sr);
        }
    }

    private void updateReplication(InitialLdapContext ctx) throws NamingException {
        SearchResult sr;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-cfg-enabled"});
        String filter = "(objectclass=ds-cfg-synchronization-provider)";
        LdapName jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        try {
            NamingEnumeration<SearchResult> syncProviders = ctx.search((Name)jndiName, filter, ctls);
            while (syncProviders.hasMore()) {
                SearchResult sr2 = syncProviders.next();
                if (!"true".equalsIgnoreCase(this.getFirstValue(sr2, "ds-cfg-enabled"))) continue;
                this.replicationConfigured = true;
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-server-id"});
        filter = "(objectclass=ds-cfg-replication-domain)";
        jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        ArrayList<String> replicaIds = new ArrayList<String>();
        try {
            NamingEnumeration<SearchResult> syncProviders = ctx.search((Name)jndiName, filter, ctls);
            while (syncProviders.hasMore()) {
                sr = syncProviders.next();
                this.replicatedSuffixes.add(this.getFirstValue(sr, "ds-cfg-base-dn"));
                replicaIds.add(this.getFirstValue(sr, "ds-cfg-server-id"));
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningAttributes(new String[]{"approx-older-change-not-synchronized-millis", "missing-changes", "base-dn", "server-id"});
        filter = "(missing-changes=*)";
        jndiName = new LdapName("cn=monitor");
        if (this.replicatedSuffixes.size() > 0) {
            try {
                NamingEnumeration<SearchResult> monitorEntries = ctx.search((Name)jndiName, filter, ctls);
                while (monitorEntries.hasMore()) {
                    sr = monitorEntries.next();
                    String dn = this.getFirstValue(sr, "base-dn");
                    String replicaId = this.getFirstValue(sr, "server-id");
                    for (int i = 0; i < this.replicatedSuffixes.size(); ++i) {
                        String baseDn = this.replicatedSuffixes.get(i);
                        String id = (String)replicaIds.get(i);
                        if (!Utils.areDnsEqual(dn, baseDn) || !id.equals(replicaId)) continue;
                        try {
                            this.hmAgeOfOldestMissingChanges.put(baseDn, new Long(this.getFirstValue(sr, "approx-older-change-not-synchronized-millis")));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            this.hmMissingChanges.put(baseDn, new Integer(this.getFirstValue(sr, "missing-changes")));
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (NameNotFoundException nse) {
                // empty catch block
            }
        }
    }

    private void updateDatabases(InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-backend-id"});
        String filter = "(objectclass=ds-cfg-backend)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> databases = ctx.search((Name)jndiName, filter, ctls);
        while (databases.hasMore()) {
            SearchResult sr = databases.next();
            this.updateConfigWithBackend(sr, ctx);
        }
    }

    private void updateAdministrativeUsers(InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-alternate-bind-dn"});
        String filter = "(objectclass=ds-cfg-root-dn-user)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> users = ctx.search((Name)jndiName, filter, ctls);
        while (users.hasMore()) {
            SearchResult sr = users.next();
            this.updateConfigWithAdministrativeUser(sr);
        }
    }

    private String getJavaVersion(InitialLdapContext ctx) throws NamingException {
        String v = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"jvmVersion"});
        String filter = "(objectclass=*)";
        LdapName jndiName = new LdapName("cn=System Information,cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v = this.getFirstValue(sr, "jvmVersion");
        }
        return v;
    }

    private int getOpenConnections(InitialLdapContext ctx) throws NamingException {
        int nConnections = -1;
        String v = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"currentConnections"});
        String filter = "(objectclass=*)";
        LdapName jndiName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v = this.getFirstValue(sr, "currentConnections");
        }
        try {
            nConnections = Integer.parseInt(v);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return nConnections;
    }

    private int getEntryCount(InitialLdapContext ctx, String backendID) throws NamingException {
        int nEntries = -1;
        String v = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningAttributes(new String[]{"ds-backend-entry-count"});
        String filter = "(ds-backend-id=" + backendID + ")";
        LdapName jndiName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v = this.getFirstValue(sr, "ds-backend-entry-count");
        }
        try {
            nEntries = Integer.parseInt(v);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return nEntries;
    }

    private BaseDNDescriptor getBaseDNDescriptor(InitialLdapContext ctx, String baseDn) throws NamingException {
        BaseDNDescriptor.Type type;
        int missingChanges = -1;
        long ageOfOldestMissingChange = -1L;
        String mapSuffixDn = null;
        boolean replicated = false;
        if (this.replicationConfigured) {
            for (String suffixDn : this.replicatedSuffixes) {
                if (!Utils.areDnsEqual(baseDn, suffixDn)) continue;
                replicated = true;
                mapSuffixDn = suffixDn;
                break;
            }
        }
        if (replicated) {
            type = BaseDNDescriptor.Type.REPLICATED;
            Integer missing = this.hmMissingChanges.get(mapSuffixDn);
            Long age = this.hmAgeOfOldestMissingChanges.get(mapSuffixDn);
            if (age != null) {
                ageOfOldestMissingChange = age;
            }
            if (missing != null) {
                missingChanges = missing;
            }
        } else {
            type = BaseDNDescriptor.Type.NOT_REPLICATED;
        }
        return new BaseDNDescriptor(type, baseDn, null, -1, ageOfOldestMissingChange, missingChanges);
    }

    private void updateConfigWithConnectionHandler(SearchResult entry) throws NamingException {
        ListenerDescriptor.State state;
        ListenerDescriptor.Protocol protocol;
        Message protocolDescription;
        String addressPort;
        String address = this.getFirstValue(entry, "ds-cfg-listen-address");
        String port = this.getFirstValue(entry, "ds-cfg-listen-port");
        boolean isSecure = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-use-ssl"));
        if (this.hasObjectClass(entry, "ds-cfg-ldap-connection-handler")) {
            if (address == null) {
                address = ConfigFromFile.getDefaultLdapAddress();
            }
            addressPort = address + ":" + port;
            if (isSecure) {
                protocolDescription = AdminToolMessages.INFO_LDAPS_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.LDAPS;
            } else {
                protocolDescription = AdminToolMessages.INFO_LDAP_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.LDAP;
            }
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (this.hasObjectClass(entry, "ds-cfg-jmx-connection-handler")) {
            addressPort = "0.0.0.0:" + port;
            if (isSecure) {
                protocolDescription = AdminToolMessages.INFO_JMX_SECURE_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.JMXS;
            } else {
                protocolDescription = AdminToolMessages.INFO_JMX_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.JMX;
            }
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (this.hasObjectClass(entry, "ds-cfg-ldif-connection-handler")) {
            addressPort = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
            protocol = ListenerDescriptor.Protocol.LDIF;
            protocolDescription = AdminToolMessages.INFO_LDIF_PROTOCOL_LABEL.get();
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-connection-handler-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (this.hasObjectClass(entry, "ds-cfg-snmp-connection-handler")) {
            addressPort = "0.0.0.0:" + port;
            protocolDescription = AdminToolMessages.INFO_SNMP_PROTOCOL_LABEL.get();
            protocol = ListenerDescriptor.Protocol.SNMP;
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else {
            int index;
            addressPort = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
            protocolDescription = null;
            protocol = ListenerDescriptor.Protocol.OTHER;
            String cn = this.getFirstValue(entry, "cn");
            protocolDescription = cn != null ? ((index = cn.toLowerCase().indexOf("connection handler")) > 0 ? Message.raw(cn.substring(0, index).trim(), new Object[0]) : Message.raw(cn, new Object[0])) : AdminToolMessages.INFO_UNDEFINED_PROTOCOL_LABEL.get();
            state = ListenerDescriptor.State.UNKNOWN;
        }
        this.listeners.add(new ListenerDescriptor(addressPort, protocol, protocolDescription, state));
    }

    private void updateConfigWithBackend(SearchResult entry, InitialLdapContext ctx) throws NamingException {
        String id = this.getFirstValue(entry, "ds-cfg-backend-id");
        if (!this.isConfigBackend(id)) {
            Set<String> baseDns = this.getValues(entry, "ds-cfg-base-dn");
            TreeSet<BaseDNDescriptor> replicas = new TreeSet<BaseDNDescriptor>();
            int nEntries = this.getEntryCount(ctx, id);
            Set<String> baseDnEntries = ConfigFromLDAP.getBaseDNEntryCount(ctx, id);
            DatabaseDescriptor db = new DatabaseDescriptor(id, replicas, nEntries);
            for (String baseDn : baseDns) {
                BaseDNDescriptor rep = this.getBaseDNDescriptor(ctx, baseDn);
                rep.setDatabase(db);
                nEntries = -1;
                for (String s : baseDnEntries) {
                    String dn;
                    int index = s.indexOf(" ");
                    if (index == -1 || !Utils.areDnsEqual(baseDn, dn = s.substring(index + 1))) continue;
                    try {
                        nEntries = Integer.parseInt(s.substring(0, index));
                    }
                    catch (Throwable t) {}
                    break;
                }
                rep.setEntries(nEntries);
                db.getBaseDns().add(rep);
            }
            this.databases.add(db);
        }
    }

    private void updateConfigWithAdministrativeUser(SearchResult entry) throws NamingException {
        this.administrativeUsers.addAll(this.getValues(entry, "ds-cfg-alternate-bind-dn"));
    }

    private String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        return Utils.getFirstValue(entry, attrName);
    }

    private Set<String> getValues(SearchResult entry, String attrName) throws NamingException {
        Attribute attr;
        HashSet<String> values = new HashSet<String>();
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get(attrName)) != null) {
            for (int i = 0; i < attr.size(); ++i) {
                values.add((String)attr.get(i));
            }
        }
        return values;
    }

    private boolean hasObjectClass(SearchResult entry, String ocName) throws NamingException {
        Attribute attr;
        boolean hasObjectClass = false;
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get("objectclass")) != null) {
            for (int i = 0; i < attr.size() && !hasObjectClass; ++i) {
                hasObjectClass = ocName.equalsIgnoreCase((String)attr.get(i));
            }
        }
        return hasObjectClass;
    }

    private boolean isConfigBackend(String id) {
        return ConfigFromFile.isConfigBackend(id);
    }

    private static Set<String> getBaseDNEntryCount(InitialLdapContext ctx, String backendID) throws NamingException {
        LinkedHashSet<String> v = new LinkedHashSet<String>();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningAttributes(new String[]{"ds-base-dn-entry-count"});
        String filter = "(ds-backend-id=" + backendID + ")";
        LdapName jndiName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v.addAll(ConnectionUtils.getValues(sr, "ds-base-dn-entry-count"));
        }
        return v;
    }
}

