/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.std.meta.LDAPConnectionHandlerCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFromFile {
    private final ObjectClass connectionHandlerOc = DirectoryServer.getObjectClass("ds-cfg-connection-handler", true);
    private final ObjectClass ldapConnectionHandlerOc = DirectoryServer.getObjectClass("ds-cfg-ldap-connection-handler", true);
    private final ObjectClass jmxConnectionHandlerOc = DirectoryServer.getObjectClass("ds-cfg-jmx-connection-handler", true);
    private final ObjectClass ldifConnectionHandlerOc = DirectoryServer.getObjectClass("ds-cfg-ldif-connection-handler", true);
    private final ObjectClass snmpConnectionHandlerOc = DirectoryServer.getObjectClass("ds-cfg-snmp-connection-handler", true);
    private final ObjectClass backendOc = DirectoryServer.getObjectClass("ds-cfg-backend", true);
    private final ObjectClass administrativeUserOc = DirectoryServer.getObjectClass("ds-cfg-root-dn-user", true);
    private final ObjectClass syncProviderOc = DirectoryServer.getObjectClass("ds-cfg-synchronization-provider", true);
    private final ObjectClass replicationConfigOc = DirectoryServer.getObjectClass("ds-cfg-replication-domain", true);
    private DN replicationDomainDN;
    private HashSet<ListenerDescriptor> listeners = new HashSet();
    private HashSet<ListenerDescriptor> startTLSListeners = new HashSet();
    private HashSet<DatabaseDescriptor> databases = new HashSet();
    private HashSet<String> administrativeUsers = new HashSet();
    private Message errorMessage;
    private boolean replicationConfigured = false;
    private HashSet<String> replicatedSuffixes = new HashSet();
    private static final Logger LOG = Logger.getLogger(ConfigFromFile.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() {
        this.errorMessage = null;
        this.listeners.clear();
        this.startTLSListeners.clear();
        this.databases.clear();
        this.administrativeUsers.clear();
        this.replicationConfigured = false;
        this.replicatedSuffixes.clear();
        LDIFReader reader = null;
        try {
            Installation installation = Installation.getLocal();
            LDIFImportConfig c = new LDIFImportConfig(Utils.getPath(installation.getCurrentConfigurationFile()));
            reader = new LDIFReader(c);
            Entry entry = reader.readEntry(false);
            while (entry != null) {
                this.updateConfig(entry);
                entry = reader.readEntry(false);
            }
            this.updateReplication();
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Error reading config file: " + ioe, ioe);
            this.errorMessage = Utils.getThrowableMsg(AdminToolMessages.ERR_READING_CONFIG_FILE.get(), ioe);
        }
        catch (LDIFException le) {
            LOG.log(Level.SEVERE, "Error reading config file: " + le, le);
            this.errorMessage = Utils.getThrowableMsg(AdminToolMessages.ERR_READING_CONFIG_FILE.get(), le);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error reading config file: " + t, t);
            t.printStackTrace();
            this.errorMessage = Utils.getThrowableMsg(AdminToolMessages.ERR_READING_CONFIG_FILE.get(), t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public HashSet<String> getAdministrativeUsers() {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(this.administrativeUsers);
        return copy;
    }

    public HashSet<DatabaseDescriptor> getDatabases() {
        HashSet<DatabaseDescriptor> copy = new HashSet<DatabaseDescriptor>();
        copy.addAll(this.databases);
        return copy;
    }

    public HashSet<ListenerDescriptor> getListeners() {
        HashSet<ListenerDescriptor> copy = new HashSet<ListenerDescriptor>();
        copy.addAll(this.listeners);
        return copy;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public String getLDAPURL() {
        return this.getLDAPURL(false);
    }

    public String getLDAPSURL() {
        return this.getLDAPURL(true);
    }

    public String getStartTLSURL() {
        String url = null;
        for (ListenerDescriptor desc : this.startTLSListeners) {
            if (desc.getState() != ListenerDescriptor.State.ENABLED) continue;
            int port = -1;
            String host = "localhost";
            try {
                String addressPort = desc.getAddressPort();
                int index = addressPort.indexOf(":");
                if (index != -1) {
                    port = Integer.parseInt(addressPort.substring(index + 1));
                    if (index > 0) {
                        host = addressPort.substring(0, index);
                    }
                } else {
                    port = Integer.parseInt(addressPort);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (port == -1) continue;
            url = "ldap://" + ConnectionUtils.getHostNameForLdapUrl(host) + ":" + port;
            break;
        }
        return url;
    }

    public String getURL(ConnectionProtocolPolicy policy) throws ConfigException {
        String url;
        String ldapUrl = this.getLDAPURL();
        String startTlsUrl = this.getStartTLSURL();
        String ldapsUrl = this.getLDAPSURL();
        switch (policy) {
            case USE_STARTTLS: {
                if (startTlsUrl != null) {
                    url = startTlsUrl;
                    break;
                }
                throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            case USE_LDAPS: {
                if (ldapsUrl != null) {
                    url = ldapsUrl;
                    break;
                }
                throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            case USE_LDAP: {
                if (ldapUrl != null) {
                    url = ldapUrl;
                    break;
                }
                throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            case USE_MOST_SECURE_AVAILABLE: {
                if (ldapsUrl != null) {
                    url = ldapsUrl;
                    break;
                }
                if (startTlsUrl != null) {
                    url = startTlsUrl;
                    break;
                }
                if (ldapUrl != null) {
                    url = ldapUrl;
                    break;
                }
                throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            case USE_LESS_SECURE_AVAILABLE: {
                if (ldapUrl != null) {
                    url = ldapUrl;
                    break;
                }
                if (ldapsUrl != null) {
                    url = ldapsUrl;
                    break;
                }
                throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            default: {
                throw new IllegalStateException("Unknown connection policy: " + (Object)((Object)policy));
            }
        }
        return url;
    }

    private String getLDAPURL(boolean secure) {
        String url = null;
        for (ListenerDescriptor desc : this.getListeners()) {
            if (desc.getState() != ListenerDescriptor.State.ENABLED) continue;
            int port = -1;
            String host = "localhost";
            try {
                String addressPort = desc.getAddressPort();
                int index = addressPort.indexOf(":");
                if (index != -1) {
                    port = Integer.parseInt(addressPort.substring(index + 1));
                    if (index > 0) {
                        host = addressPort.substring(0, index);
                    }
                } else {
                    port = Integer.parseInt(addressPort);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (port == -1) continue;
            if (!secure && desc.getProtocol() == ListenerDescriptor.Protocol.LDAP) {
                url = "ldap://" + ConnectionUtils.getHostNameForLdapUrl(host) + ":" + port;
                break;
            }
            if (!secure || desc.getProtocol() != ListenerDescriptor.Protocol.LDAPS) continue;
            url = "ldaps://" + ConnectionUtils.getHostNameForLdapUrl(host) + ":" + port;
            break;
        }
        return url;
    }

    static String getDefaultLdapAddress() {
        Collection<String> defaultValues;
        String address = null;
        LDAPConnectionHandlerCfgDefn connHandler = LDAPConnectionHandlerCfgDefn.getInstance();
        IPAddressPropertyDefinition prop = connHandler.getListenAddressPropertyDefinition();
        DefaultBehaviorProvider p = prop.getDefaultBehaviorProvider();
        if (p instanceof DefinedDefaultBehaviorProvider && !(defaultValues = ((DefinedDefaultBehaviorProvider)p).getDefaultValues()).isEmpty()) {
            address = defaultValues.iterator().next().toString();
        }
        return address;
    }

    static boolean isConfigBackend(String id) {
        return "tasks".equalsIgnoreCase(id) || "schema".equalsIgnoreCase(id) || "config".equalsIgnoreCase(id) || "monitor".equalsIgnoreCase(id) || "backup".equalsIgnoreCase(id) || ADSContext.getDefaultBackendName().equalsIgnoreCase(id) || "ads-truststore".equalsIgnoreCase(id) || "replicationchanges".equalsIgnoreCase(id);
    }

    private void updateConfig(Entry entry) {
        if (entry.hasObjectClass(this.connectionHandlerOc)) {
            this.updateConfigWithConnectionHandler(entry);
        } else if (entry.hasObjectClass(this.backendOc)) {
            this.updateConfigWithBackend(entry);
        } else if (entry.hasObjectClass(this.administrativeUserOc)) {
            this.updateConfigWithAdministrativeUser(entry);
        } else if (entry.hasObjectClass(this.syncProviderOc)) {
            this.updateConfigWithSyncProviderEntry(entry);
        } else if (entry.hasObjectClass(this.replicationConfigOc)) {
            this.updateConfigWithReplConfig(entry);
        }
    }

    private void updateConfigWithConnectionHandler(Entry entry) {
        String allowStartTLS;
        ListenerDescriptor.State state;
        ListenerDescriptor.Protocol protocol;
        Message protocolDescription;
        String addressPort;
        String address = this.getFirstValue(entry, "ds-cfg-listen-address");
        String port = this.getFirstValue(entry, "ds-cfg-listen-port");
        boolean isSecure = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-use-ssl"));
        if (entry.hasObjectClass(this.ldapConnectionHandlerOc)) {
            if (address == null) {
                address = ConfigFromFile.getDefaultLdapAddress();
            }
            addressPort = address + ":" + port;
            if (isSecure) {
                protocolDescription = AdminToolMessages.INFO_LDAPS_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.LDAPS;
            } else {
                protocolDescription = AdminToolMessages.INFO_LDAP_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.LDAP;
            }
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (entry.hasObjectClass(this.jmxConnectionHandlerOc)) {
            addressPort = "0.0.0.0:" + port;
            if (isSecure) {
                protocolDescription = AdminToolMessages.INFO_JMX_SECURE_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.JMXS;
            } else {
                protocolDescription = AdminToolMessages.INFO_JMX_PROTOCOL_LABEL.get();
                protocol = ListenerDescriptor.Protocol.JMX;
            }
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (entry.hasObjectClass(this.ldifConnectionHandlerOc)) {
            addressPort = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
            protocol = ListenerDescriptor.Protocol.LDIF;
            protocolDescription = AdminToolMessages.INFO_LDIF_PROTOCOL_LABEL.get();
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-connection-handler-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else if (entry.hasObjectClass(this.snmpConnectionHandlerOc)) {
            addressPort = "0.0.0.0:" + port;
            protocol = ListenerDescriptor.Protocol.SNMP;
            protocolDescription = AdminToolMessages.INFO_SNMP_PROTOCOL_LABEL.get();
            boolean enabled = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
            state = enabled ? ListenerDescriptor.State.ENABLED : ListenerDescriptor.State.DISABLED;
        } else {
            int index;
            addressPort = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
            protocolDescription = null;
            protocol = ListenerDescriptor.Protocol.OTHER;
            String cn = this.getFirstValue(entry, "cn");
            protocolDescription = cn != null ? ((index = cn.toLowerCase().indexOf("connection handler")) > 0 ? Message.raw(cn.substring(0, index).trim(), new Object[0]) : Message.raw(cn, new Object[0])) : AdminToolMessages.INFO_UNDEFINED_PROTOCOL_LABEL.get();
            state = ListenerDescriptor.State.UNKNOWN;
        }
        this.listeners.add(new ListenerDescriptor(addressPort, protocol, protocolDescription, state));
        if (protocol == ListenerDescriptor.Protocol.LDAP && (allowStartTLS = this.getFirstValue(entry, "ds-cfg-allow-start-tls")) != null && "true".equalsIgnoreCase(allowStartTLS.trim())) {
            this.startTLSListeners.add(new ListenerDescriptor(addressPort, protocol, protocolDescription, state));
        }
    }

    private void updateConfigWithBackend(Entry entry) {
        String id = this.getFirstValue(entry, "ds-cfg-backend-id");
        int nEntries = -1;
        if (!ConfigFromFile.isConfigBackend(id)) {
            Set<String> baseDns = this.getValues(entry, "ds-cfg-base-dn");
            TreeSet<BaseDNDescriptor> replicas = new TreeSet<BaseDNDescriptor>();
            DatabaseDescriptor db = new DatabaseDescriptor(id, replicas, nEntries);
            for (String baseDn : baseDns) {
                BaseDNDescriptor rep = this.getBaseDNDescriptor(entry, baseDn);
                rep.setDatabase(db);
                db.getBaseDns().add(rep);
            }
            this.databases.add(db);
        }
    }

    private void updateConfigWithAdministrativeUser(Entry entry) {
        this.administrativeUsers.addAll(this.getValues(entry, "ds-cfg-alternate-bind-dn"));
    }

    private void updateConfigWithSyncProviderEntry(Entry entry) {
        this.replicationConfigured = "true".equalsIgnoreCase(this.getFirstValue(entry, "ds-cfg-enabled"));
    }

    private void updateReplication() {
        if (this.replicationConfigured) {
            for (String suffixDn : this.replicatedSuffixes) {
                BaseDNDescriptor replica = null;
                for (DatabaseDescriptor db : this.databases) {
                    SortedSet<BaseDNDescriptor> replicas = db.getBaseDns();
                    for (BaseDNDescriptor rep : replicas) {
                        if (!Utils.areDnsEqual(rep.getDn(), suffixDn)) continue;
                        replica = rep;
                        break;
                    }
                    if (replica == null) continue;
                    break;
                }
                if (replica == null) continue;
                replica.setType(BaseDNDescriptor.Type.REPLICATED);
            }
        }
    }

    private void updateConfigWithReplConfig(Entry entry) {
        if (this.replicationDomainDN == null) {
            try {
                this.replicationDomainDN = DN.decode("cn=domains,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
            }
            catch (Throwable t) {
                throw new IllegalStateException("Bug: " + t, t);
            }
        }
        if (entry.getDN().isDescendantOf(this.replicationDomainDN)) {
            this.replicatedSuffixes.addAll(this.getValues(entry, "ds-cfg-base-dn"));
        }
    }

    private Set<String> getValues(Entry entry, String attrName) {
        Attribute attr;
        LinkedHashSet<AttributeValue> vs;
        HashSet<String> values = new HashSet<String>();
        List<Attribute> attrs = entry.getAttribute(attrName);
        if (attrs != null && attrs.size() > 0 && (vs = (attr = attrs.iterator().next()).getValues()) != null && vs.size() > 0) {
            for (AttributeValue v : vs) {
                values.add(v.getStringValue());
            }
        }
        return values;
    }

    private String getFirstValue(Entry entry, String attrName) {
        String v = null;
        Set<String> values = this.getValues(entry, attrName);
        if (values.size() > 0) {
            v = values.iterator().next();
        }
        return v;
    }

    private BaseDNDescriptor getBaseDNDescriptor(Entry entry, String baseDn) {
        return new BaseDNDescriptor(BaseDNDescriptor.Type.NOT_REPLICATED, baseDn, null, -1, -1L, -1);
    }
}

