/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.TimeLimitExceededException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLoader
extends Thread {
    private Map<ADSContext.ServerProperty, Object> serverProperties;
    private boolean isOver;
    private boolean isInterrupted;
    private String lastLdapUrl;
    private TopologyCacheException lastException;
    private ServerDescriptor serverDescriptor;
    private ApplicationTrustManager trustManager;
    private String dn;
    private String pwd;
    private LinkedHashSet<PreferredConnection> preferredLDAPURLs;
    private TopologyCacheFilter filter;
    private static final Logger LOG = Logger.getLogger(ServerLoader.class.getName());

    public ServerLoader(Map<ADSContext.ServerProperty, Object> serverProperties, String dn, String pwd, ApplicationTrustManager trustManager, LinkedHashSet<PreferredConnection> preferredLDAPURLs, TopologyCacheFilter filter) {
        this.serverProperties = serverProperties;
        this.dn = dn;
        this.pwd = pwd;
        this.trustManager = trustManager;
        this.preferredLDAPURLs = new LinkedHashSet<PreferredConnection>(preferredLDAPURLs);
        this.filter = filter;
    }

    public ServerDescriptor getServerDescriptor() {
        if (this.serverDescriptor == null) {
            this.serverDescriptor = ServerDescriptor.createStandalone(this.serverProperties);
        }
        this.serverDescriptor.setLastException(this.lastException);
        return this.serverDescriptor;
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    @Override
    public void interrupt() {
        if (!this.isOver) {
            LinkedHashSet<PreferredConnection> urls;
            this.isInterrupted = true;
            String ldapUrl = this.getLastLdapUrl();
            if (ldapUrl == null && !(urls = this.getLDAPURLsByPreference()).isEmpty()) {
                ldapUrl = ((PreferredConnection)urls.iterator().next()).getLDAPURL();
            }
            this.lastException = new TopologyCacheException(TopologyCacheException.Type.TIMEOUT, new TimeLimitExceededException("Timeout reading server: " + ldapUrl), this.trustManager, ldapUrl);
            LOG.log(Level.WARNING, "Timeout reading server: " + ldapUrl);
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastException = null;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createContext();
            this.serverDescriptor = ServerDescriptor.createStandalone(ctx, this.filter);
            this.serverDescriptor.setAdsProperties(this.serverProperties);
        }
        catch (NoPermissionException npe) {
            LOG.log(Level.WARNING, "Permissions error reading server: " + this.getLastLdapUrl(), npe);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, npe, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.NO_PERMISSIONS, npe, this.trustManager, this.getLastLdapUrl());
        }
        catch (AuthenticationException ae) {
            LOG.log(Level.WARNING, "Authentication exception: " + this.getLastLdapUrl(), ae);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, ae, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, ae, this.trustManager, this.getLastLdapUrl());
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "NamingException error reading server: " + this.getLastLdapUrl(), ne);
            this.lastException = ctx == null ? new TopologyCacheException(TopologyCacheException.Type.GENERIC_CREATING_CONNECTION, ne, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, ne, this.trustManager, this.getLastLdapUrl());
        }
        catch (Throwable t) {
            if (!this.isInterrupted) {
                LOG.log(Level.WARNING, "Generic error reading server: " + this.getLastLdapUrl(), t);
                LOG.log(Level.WARNING, "server Properties: " + this.serverProperties);
                this.lastException = new TopologyCacheException(TopologyCacheException.Type.BUG, t);
            }
        }
        finally {
            this.isOver = true;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    public InitialLdapContext createContext() throws NamingException {
        InitialLdapContext ctx = null;
        if (this.trustManager != null) {
            this.trustManager.resetLastRefusedItems();
            String host = (String)this.serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
            this.trustManager.setHost(host);
        }
        LinkedHashSet<PreferredConnection> conns = this.getLDAPURLsByPreference();
        block4: for (PreferredConnection connection : conns) {
            if (ctx != null) continue;
            this.lastLdapUrl = connection.getLDAPURL();
            switch (connection.getType()) {
                case LDAPS: {
                    ctx = ConnectionUtils.createLdapsContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.trustManager, null);
                    continue block4;
                }
                case START_TLS: {
                    ctx = ConnectionUtils.createStartTLSContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.trustManager, null, null);
                    continue block4;
                }
            }
            ctx = ConnectionUtils.createLdapContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null);
        }
        return ctx;
    }

    private String getLastLdapUrl() {
        return this.lastLdapUrl;
    }

    private String getLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean ldapEnabled;
        String ldapUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean bl = ldapEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapEnabled) {
            ldapUrl = "ldap://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return ldapUrl;
    }

    private String getStartTlsLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean startTLSEnabled;
        String ldapUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean ldapEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        v = serverProperties.get((Object)ADSContext.ServerProperty.STARTTLS_ENABLED);
        boolean bl = startTLSEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapEnabled && startTLSEnabled) {
            ldapUrl = "ldap://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return ldapUrl;
    }

    private String getLdapsUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean ldapsEnabled;
        String ldapsUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAPS_ENABLED);
        boolean bl = ldapsEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapsEnabled) {
            ldapsUrl = "ldaps://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAPS_PORT);
        }
        return ldapsUrl;
    }

    private String getHostNameForLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        String host = (String)serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        return ConnectionUtils.getHostNameForLdapUrl(host);
    }

    private boolean isAdministratorDn() {
        boolean isAdministratorDn = false;
        try {
            LdapName theDn = new LdapName(this.dn);
            LdapName containerDn = new LdapName(ADSContext.getAdministratorContainerDN());
            isAdministratorDn = theDn.startsWith(containerDn);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error parsing authentication DNs.", t);
        }
        return isAdministratorDn;
    }

    private LinkedHashSet<PreferredConnection> getLDAPURLsByPreference() {
        LinkedHashSet<PreferredConnection> ldapUrls = new LinkedHashSet<PreferredConnection>();
        String ldapsUrl = this.getLdapsUrl(this.serverProperties);
        String startTLSUrl = this.getStartTlsLdapUrl(this.serverProperties);
        String ldapUrl = this.getLdapUrl(this.serverProperties);
        for (PreferredConnection connection : this.preferredLDAPURLs) {
            String url = connection.getLDAPURL();
            if (url.equalsIgnoreCase(ldapsUrl) && connection.getType() == PreferredConnection.Type.LDAPS) {
                ldapUrls.add(connection);
                continue;
            }
            if (url.equalsIgnoreCase(startTLSUrl) && connection.getType() == PreferredConnection.Type.START_TLS) {
                ldapUrls.add(connection);
                continue;
            }
            if (!url.equalsIgnoreCase(ldapUrl) || connection.getType() != PreferredConnection.Type.LDAP) continue;
            ldapUrls.add(connection);
        }
        if (ldapsUrl != null) {
            ldapUrls.add(new PreferredConnection(ldapsUrl, PreferredConnection.Type.LDAPS));
        }
        if (startTLSUrl != null) {
            ldapUrls.add(new PreferredConnection(startTLSUrl, PreferredConnection.Type.START_TLS));
        }
        if (ldapUrl != null) {
            ldapUrls.add(new PreferredConnection(ldapUrl, PreferredConnection.Type.LDAP));
        }
        return ldapUrls;
    }
}

