/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.transport.TransportProtocolServer;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.net.ConnectedSocketTransportProvider;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolEventAdapter;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshServer {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$SshServer == null ? (class$com$sshtools$daemon$SshServer = SshServer.class$("com.sshtools.daemon.SshServer")) : class$com$sshtools$daemon$SshServer));
    private ConnectionListener listener = null;
    private ServerSocket server = null;
    private boolean shutdown = false;
    private ServerSocket commandServerSocket;
    protected List activeConnections = new Vector();
    Thread thread;
    static /* synthetic */ Class class$com$sshtools$daemon$SshServer;
    static /* synthetic */ Class class$com$sshtools$daemon$configuration$ServerConfiguration;
    static /* synthetic */ Class class$com$sshtools$daemon$configuration$PlatformConfiguration;
    static /* synthetic */ Class class$com$sshtools$daemon$SshServer$ConnectionListener;

    public SshServer() throws IOException {
        String string = System.getProperty("sshtools.serverid");
        if (string != null) {
            TransportProtocolServer.SOFTWARE_VERSION_COMMENTS = string;
        }
        if (!ConfigurationLoader.isConfigurationAvailable((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))) {
            throw new SshException("Server configuration not available!");
        }
        if (!ConfigurationLoader.isConfigurationAvailable((Class)(class$com$sshtools$daemon$configuration$PlatformConfiguration == null ? (class$com$sshtools$daemon$configuration$PlatformConfiguration = SshServer.class$("com.sshtools.daemon.configuration.PlatformConfiguration")) : class$com$sshtools$daemon$configuration$PlatformConfiguration))) {
            throw new SshException("Platform configuration not available");
        }
        if (((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getServerHostKeys().size() <= 0) {
            throw new SshException("Server cannot start because there are no server host keys available");
        }
    }

    public void startServer() throws IOException {
        log.info((Object)"Starting server");
        this.shutdown = false;
        this.startServerSocket();
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    SshServer.this.startCommandSocket();
                }
                catch (IOException iOException) {
                    log.info((Object)"Failed to start command socket", (Throwable)iOException);
                    try {
                        SshServer.this.stopServer("The command socket failed to start");
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        });
        this.thread.start();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void processCommand(int n, Socket socket) throws IOException {
        if (n == 58) {
            int n2 = socket.getInputStream().read();
            byte[] byArray = new byte[n2];
            socket.getInputStream().read(byArray);
            this.stopServer(new String(byArray));
        }
    }

    protected void startCommandSocket() throws IOException {
        block3: {
            try {
                Socket socket;
                this.commandServerSocket = new ServerSocket(((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getCommandPort(), 50, InetAddress.getLocalHost());
                while ((socket = this.commandServerSocket.accept()) != null) {
                    log.info((Object)"Command request received");
                    this.processCommand(socket.getInputStream().read(), socket);
                    socket.close();
                    if (!this.shutdown) continue;
                }
                this.commandServerSocket.close();
            }
            catch (Exception exception) {
                if (this.shutdown) break block3;
                log.fatal((Object)"The command socket failed", (Throwable)exception);
            }
        }
    }

    protected void startServerSocket() throws IOException {
        this.listener = new ConnectionListener(((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getListenAddress(), ((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getPort());
        this.listener.start();
    }

    public void stopServer(String string) throws IOException {
        log.info((Object)"Shutting down server");
        this.shutdown = true;
        log.debug((Object)string);
        this.shutdown(string);
        this.listener.stop();
        log.debug((Object)"Stopping command server");
        try {
            if (this.commandServerSocket != null) {
                this.commandServerSocket.close();
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
    }

    protected abstract void shutdown(String var1);

    protected abstract void configureServices(ConnectionProtocol var1) throws IOException;

    protected void refuseSession(Socket socket) throws IOException {
        TransportProtocolServer transportProtocolServer = new TransportProtocolServer(true);
        transportProtocolServer.startTransportProtocol((TransportProvider)new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
    }

    protected TransportProtocolServer createSession(Socket socket) throws IOException {
        log.debug((Object)"Initializing connection");
        InetAddress inetAddress = socket.getInetAddress();
        log.debug((Object)("Remote Hostname: " + inetAddress.getHostName()));
        log.debug((Object)("Remote IP: " + inetAddress.getHostAddress()));
        TransportProtocolServer transportProtocolServer = new TransportProtocolServer();
        AuthenticationProtocolServer authenticationProtocolServer = new AuthenticationProtocolServer();
        ConnectionProtocol connectionProtocol = new ConnectionProtocol();
        this.configureServices(connectionProtocol);
        authenticationProtocolServer.acceptService((Service)connectionProtocol);
        transportProtocolServer.acceptService((Service)authenticationProtocolServer);
        transportProtocolServer.startTransportProtocol((TransportProvider)new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
        return transportProtocolServer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConnectionListener
    implements Runnable {
        private Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$SshServer$ConnectionListener == null ? (class$com$sshtools$daemon$SshServer$ConnectionListener = SshServer.class$("com.sshtools.daemon.SshServer$ConnectionListener")) : class$com$sshtools$daemon$SshServer$ConnectionListener));
        private ServerSocket server;
        private String listenAddress;
        private Thread thread;
        private int maxConnections;
        private int port;
        private StartStopState state = new StartStopState(2);

        public ConnectionListener(String string, int n) {
            this.port = n;
            this.listenAddress = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object;
                block13: {
                    this.log.debug((Object)"Starting connection listener thread");
                    this.state.setValue(1);
                    this.server = new ServerSocket(this.port);
                    this.maxConnections = ((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)(class$com$sshtools$daemon$configuration$ServerConfiguration == null ? (class$com$sshtools$daemon$configuration$ServerConfiguration = SshServer.class$("com.sshtools.daemon.configuration.ServerConfiguration")) : class$com$sshtools$daemon$configuration$ServerConfiguration))).getMaxConnections();
                    boolean bl = false;
                    TransportProtocolEventAdapter transportProtocolEventAdapter = new TransportProtocolEventAdapter(this){
                        private final /* synthetic */ ConnectionListener this$1;
                        {
                            this.this$1 = connectionListener;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onDisconnect(TransportProtocol transportProtocol) {
                            if (ConnectionListener.access$100(this.this$1).getValue() != 2) {
                                List list = ConnectionListener.access$200((ConnectionListener)this.this$1).activeConnections;
                                synchronized (list) {
                                    ConnectionListener.access$300(this.this$1).info((Object)(transportProtocol.getUnderlyingProviderDetail() + " connection closed"));
                                    ConnectionListener.access$200((ConnectionListener)this.this$1).activeConnections.remove(transportProtocol);
                                }
                            }
                        }
                    };
                    try {
                        Socket socket;
                        while ((socket = this.server.accept()) != null && this.state.getValue() == 1) {
                            this.log.debug((Object)"New connection requested");
                            if (this.maxConnections < SshServer.this.activeConnections.size()) {
                                SshServer.this.refuseSession(socket);
                                continue;
                            }
                            object = SshServer.this.createSession(socket);
                            this.log.info((Object)("Monitoring active session from " + socket.getInetAddress().getHostName()));
                            List list = SshServer.this.activeConnections;
                            synchronized (list) {
                                SshServer.this.activeConnections.add(object);
                            }
                            object.addEventHandler((TransportProtocolEventHandler)transportProtocolEventAdapter);
                        }
                    }
                    catch (IOException iOException) {
                        if (this.state.getValue() == 2) break block13;
                        this.log.info((Object)"The server was shutdown unexpectedly", (Throwable)iOException);
                    }
                }
                this.state.setValue(2);
                this.log.info((Object)"Disconnecting active sessions");
                object = SshServer.this.activeConnections.iterator();
                while (object.hasNext()) {
                    ((TransportProtocolServer)((Object)object.next())).disconnect("The server is shuting down");
                }
                SshServer.this.listener = null;
                this.log.info((Object)"Exiting connection listener thread");
            }
            catch (IOException iOException) {
                this.log.info((Object)"The server thread failed", (Throwable)iOException);
            }
            finally {
                this.thread = null;
            }
        }

        public void start() {
            this.thread = new SshThread((Runnable)this, "Connection listener", true);
            this.thread.start();
        }

        public void stop() {
            try {
                this.state.setValue(2);
                this.server.close();
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (IOException iOException) {
                this.log.warn((Object)"The listening socket reported an error during shutdown", (Throwable)iOException);
            }
        }

        static /* synthetic */ StartStopState access$100(ConnectionListener connectionListener) {
            return connectionListener.state;
        }

        static /* synthetic */ SshServer access$200(ConnectionListener connectionListener) {
            return connectionListener.SshServer.this;
        }

        static /* synthetic */ Log access$300(ConnectionListener connectionListener) {
            return connectionListener.log;
        }
    }
}

