/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicBuffer {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$io$DynamicBuffer == null ? (class$com$sshtools$j2ssh$io$DynamicBuffer = DynamicBuffer.class$("com.sshtools.j2ssh.io.DynamicBuffer")) : class$com$sshtools$j2ssh$io$DynamicBuffer));
    protected static final int DEFAULT_BUFFER_SIZE = 32768;
    protected byte[] buf = new byte[32768];
    protected int writepos = 0;
    protected int readpos = 0;
    protected InputStream in = new DynamicBufferInputStream();
    protected OutputStream out = new DynamicBufferOutputStream();
    private boolean closed = false;
    private int interrupt = 5000;
    static /* synthetic */ Class class$com$sshtools$j2ssh$io$DynamicBuffer;

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    private synchronized void verifyBufferSize(int n) {
        if (n > this.buf.length - this.writepos) {
            System.arraycopy(this.buf, this.readpos, this.buf, 0, this.writepos - this.readpos);
            this.writepos -= this.readpos;
            this.readpos = 0;
        }
        if (n > this.buf.length - this.writepos) {
            byte[] byArray = new byte[this.buf.length + 32768];
            System.arraycopy(this.buf, 0, byArray, 0, this.writepos - this.readpos);
            this.buf = byArray;
        }
    }

    protected synchronized int available() {
        return this.writepos - this.readpos;
    }

    private synchronized void block() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Buffer size: " + String.valueOf(this.buf.length)));
            log.debug((Object)("Unread data: " + String.valueOf(this.writepos - this.readpos)));
        }
        if (!this.closed) {
            while (this.readpos >= this.writepos && !this.closed) {
                this.wait(this.interrupt);
            }
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyAll();
        }
    }

    protected synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("The buffer is closed");
        }
        this.verifyBufferSize(1);
        this.buf[this.writepos] = (byte)n;
        ++this.writepos;
        this.notifyAll();
    }

    protected synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("The buffer is closed");
        }
        this.verifyBufferSize(n2);
        System.arraycopy(byArray, n, this.buf, this.writepos, n2);
        this.writepos += n2;
        this.notifyAll();
    }

    public void setBlockInterrupt(int n) {
        this.interrupt = n;
    }

    protected synchronized int read() throws IOException {
        try {
            this.block();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The blocking operation was interrupted");
        }
        if (this.closed && this.available() <= 0) {
            return -1;
        }
        return this.buf[this.readpos++];
    }

    protected synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.block();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The blocking operation was interrupted");
        }
        if (this.closed && this.available() <= 0) {
            return -1;
        }
        int n3 = n2 > this.writepos - this.readpos ? this.writepos - this.readpos : n2;
        System.arraycopy(this.buf, this.readpos, byArray, n, n3);
        this.readpos += n3;
        return n3;
    }

    protected synchronized void flush() throws IOException {
        this.notifyAll();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DynamicBufferOutputStream
    extends OutputStream {
        DynamicBufferOutputStream() {
        }

        public void write(int n) throws IOException {
            DynamicBuffer.this.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            DynamicBuffer.this.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            DynamicBuffer.this.flush();
        }

        public void close() {
            DynamicBuffer.this.close();
        }
    }

    class DynamicBufferInputStream
    extends InputStream {
        DynamicBufferInputStream() {
        }

        public int read() throws IOException {
            return DynamicBuffer.this.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return DynamicBuffer.this.read(byArray, n, n2);
        }

        public int available() {
            return DynamicBuffer.this.available();
        }

        public void close() {
            DynamicBuffer.this.close();
        }
    }
}

