/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.build;

import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.build.BuildServerDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class BambooBuildServerData
extends BuildServerDataProvider {
    BambooBuildServerData(LoggerBridge log, @NotNull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("BAMBOO_BUILDKEY");
    }

    @Override
    void loadBuildNumber(@NotNull Properties properties) {
        String buildNumber = (String)this.env.get("BAMBOO_BUILDNUMBER");
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("BAMBOO_PLANREPOSITORY_BRANCH");
        this.log.info("Using environment variable based branch name. BAMBOO_PLANREPOSITORY_BRANCH = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

