/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.http.oidc.PublicKeyLocator;
import org.wildfly.security.jose.jwk.JWK;
import org.wildfly.security.jose.jwk.JsonWebKeySet;
import org.wildfly.security.jose.jwk.JsonWebKeySetUtil;

class JWKEncPublicKeyLocator
implements PublicKeyLocator {
    private List<PublicKey> currentKeys = new ArrayList<PublicKey>();
    private volatile int lastRequestTime = 0;

    JWKEncPublicKeyLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey getPublicKey(String kid, OidcClientConfiguration config) {
        int currentTime;
        int minTimeBetweenRequests = config.getMinTimeBetweenJwksRequests();
        int publicKeyCacheTtl = config.getPublicKeyCacheTtl();
        PublicKey publicKey = this.lookupCachedKey(publicKeyCacheTtl, currentTime = JWKEncPublicKeyLocator.getCurrentTime());
        if (publicKey != null) {
            return publicKey;
        }
        JWKEncPublicKeyLocator jWKEncPublicKeyLocator = this;
        synchronized (jWKEncPublicKeyLocator) {
            currentTime = JWKEncPublicKeyLocator.getCurrentTime();
            if (currentTime > this.lastRequestTime + minTimeBetweenRequests) {
                this.sendRequest(config);
                this.lastRequestTime = currentTime;
            } else {
                ElytronMessages.log.debug("Won't send request to jwks url. Last request time was " + this.lastRequestTime);
            }
            return this.lookupCachedKey(publicKeyCacheTtl, currentTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(OidcClientConfiguration config) {
        JWKEncPublicKeyLocator jWKEncPublicKeyLocator = this;
        synchronized (jWKEncPublicKeyLocator) {
            this.sendRequest(config);
            this.lastRequestTime = JWKEncPublicKeyLocator.getCurrentTime();
        }
    }

    private PublicKey lookupCachedKey(int publicKeyCacheTtl, int currentTime) {
        if (this.lastRequestTime + publicKeyCacheTtl > currentTime) {
            return this.currentKeys.get(0);
        }
        return null;
    }

    private static int getCurrentTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private void sendRequest(OidcClientConfiguration config) {
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("Going to send request to retrieve new set of public keys to encrypt a JWT request for client " + config.getResourceName());
        }
        HttpGet request = new HttpGet(config.getJwksUrl());
        request.addHeader("Accept", "application/json");
        try {
            JsonWebKeySet jwks = Oidc.sendJsonHttpRequest(config, request, JsonWebKeySet.class);
            Map<String, PublicKey> publicKeys = JsonWebKeySetUtil.getKeysForUse(jwks, JWK.Use.ENC);
            if (ElytronMessages.log.isDebugEnabled()) {
                ElytronMessages.log.debug("Public keys successfully retrieved for client " + config.getResourceName() + ". New kids: " + publicKeys.keySet());
            }
            this.currentKeys.clear();
            this.currentKeys.addAll(publicKeys.values());
        }
        catch (OidcException e) {
            ElytronMessages.log.error("Error when sending request to retrieve public keys", e);
        }
    }
}

