/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public interface SSLConfigurator {
    default public void configure(SSLContext context, SSLServerSocket sslServerSocket) {
    }

    default public void configure(SSLContext context, SSLSocket sslSocket) {
    }

    default public void configure(SSLContext context, SSLEngine sslEngine) {
    }

    default public void configure(SSLContext context) {
    }

    default public SSLParameters getDefaultSSLParameters(SSLContext sslContext, SSLParameters original) {
        return original;
    }

    default public SSLParameters getSupportedSSLParameters(SSLContext sslContext, SSLParameters original) {
        return original;
    }

    default public void setWantClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
        sslSocket.setWantClientAuth(value);
    }

    default public void setWantClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
        sslEngine.setWantClientAuth(value);
    }

    default public void setWantClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
        sslServerSocket.setNeedClientAuth(value);
    }

    default public void setNeedClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
        sslSocket.setNeedClientAuth(value);
    }

    default public void setNeedClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
        sslEngine.setNeedClientAuth(value);
    }

    default public void setNeedClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
        sslServerSocket.setNeedClientAuth(value);
    }

    default public void setEnabledCipherSuites(SSLContext sslContext, SSLSocket sslSocket, String[] cipherSuites) {
        sslSocket.setEnabledCipherSuites(cipherSuites);
    }

    default public void setEnabledCipherSuites(SSLContext sslContext, SSLEngine sslEngine, String[] cipherSuites) {
        sslEngine.setEnabledCipherSuites(cipherSuites);
    }

    default public void setEnabledCipherSuites(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] suites) {
        sslServerSocket.setEnabledCipherSuites(suites);
    }

    default public void setEnabledProtocols(SSLContext sslContext, SSLSocket sslSocket, String[] protocols) {
        sslSocket.setEnabledProtocols(protocols);
    }

    default public void setEnabledProtocols(SSLContext sslContext, SSLEngine sslEngine, String[] protocols) {
        sslEngine.setEnabledProtocols(protocols);
    }

    default public void setEnabledProtocols(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] protocols) {
        sslServerSocket.setEnabledProtocols(protocols);
    }

    default public void setSSLParameters(SSLContext sslContext, SSLSocket sslSocket, SSLParameters parameters) {
        sslSocket.setSSLParameters(parameters);
    }

    default public void setSSLParameters(SSLContext sslContext, SSLEngine sslEngine, SSLParameters parameters) {
        sslEngine.setSSLParameters(parameters);
    }

    default public void setSSLParameters(SSLContext sslContext, SSLServerSocket sslServerSocket, SSLParameters parameters) {
        sslServerSocket.setSSLParameters(parameters);
    }

    default public void setUseClientMode(SSLContext sslContext, SSLSocket sslSocket, boolean mode) {
        sslSocket.setUseClientMode(mode);
    }

    default public void setUseClientMode(SSLContext sslContext, SSLEngine sslEngine, boolean mode) {
        sslEngine.setUseClientMode(mode);
    }

    default public void setUseClientMode(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean mode) {
        sslServerSocket.setUseClientMode(mode);
    }

    default public void setEnableSessionCreation(SSLContext sslContext, SSLSocket sslSocket, boolean flag) {
        sslSocket.setEnableSessionCreation(flag);
    }

    default public void setEnableSessionCreation(SSLContext sslContext, SSLEngine sslEngine, boolean flag) {
        sslEngine.setEnableSessionCreation(flag);
    }

    default public void setEnableSessionCreation(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean flag) {
        sslServerSocket.setEnableSessionCreation(flag);
    }
}

