/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.dev;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.apache.maven.plugin.MojoExecutionException;
import org.wildfly.plugin.dev.WatchHandler;

class WatchContext
implements Comparable<WatchContext> {
    private final Path directory;
    private final WatchHandler handler;

    private WatchContext(Path directory, WatchHandler handler) {
        this.directory = directory;
        this.handler = handler;
    }

    static WatchContext of(Path directory, WatchHandler handler) {
        return new WatchContext(directory, handler);
    }

    Path directory() {
        return this.directory;
    }

    WatchHandler handler() {
        return this.handler;
    }

    WatchHandler.Result handle(WatchEvent<Path> event, Path file) throws MojoExecutionException, IOException {
        return this.handler.handle(this, event, this.directory.resolve(file));
    }

    @Override
    public int compareTo(WatchContext o) {
        return this.directory().compareTo(o.directory());
    }
}

