/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.core.GalleonUtils;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.ModulesPath;
import org.wildfly.plugin.server.ServerType;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartMojo
extends AbstractServerConnection {
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File targetDir;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="version", property="wildfly.version")
    private String version;
    @Parameter(alias="provisioning-dir", property="wildfly.provisioning.dir", defaultValue="server")
    private String provisioningDir;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="domain-config", property="wildfly.domainConfig")
    private String domainConfig;
    @Parameter(alias="host-config", property="wildfly.hostConfig")
    private String hostConfig;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    private String[] serverArgs;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(property="wildfly.stdout")
    private String stdout;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;
    @Parameter(alias="server-type", property="wildfly.server.type", defaultValue="STANDALONE")
    private ServerType serverType;
    private MavenRepoManager mavenRepoManager;
    @Parameter
    private Map<String, String> env;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.debug((CharSequence)"Skipping server start");
            return;
        }
        MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
        this.mavenRepoManager = new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
        Path jbossHome = this.provisionIfRequired(this.targetDir.toPath().resolve(this.provisioningDir));
        if (!ServerHelper.isValidHomeDirectory((Path)jbossHome)) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
        }
        try {
            StandardOutput out = StandardOutput.parse(this.stdout, true);
            try (ModelControllerClient client = this.createClient();){
                if (ServerHelper.isStandaloneRunning((ModelControllerClient)client) || ServerHelper.isDomainRunning((ModelControllerClient)client)) {
                    throw new MojoExecutionException(String.format("%s server is already running?", new Object[]{this.serverType}));
                }
                CommandBuilder commandBuilder = this.createCommandBuilder(jbossHome);
                log.info((CharSequence)String.format("%s server is starting up.", new Object[]{this.serverType}));
                Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true);
                if (this.env != null) {
                    launcher.addEnvironmentVariables(this.env);
                }
                out.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
                Process process = launcher.launch();
                out.startConsumer(process);
                if (this.serverType == ServerType.DOMAIN) {
                    ServerHelper.waitForDomain((Process)process, (ModelControllerClient)DomainClient.Factory.create((ModelControllerClient)client), (long)this.startupTimeout);
                } else {
                    ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
                }
                if (!process.isAlive()) {
                    throw new MojoExecutionException("The process has been terminated before the start goal has completed.");
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    private CommandBuilder createCommandBuilder(Path jbossHome) throws MojoExecutionException {
        if (this.serverType == ServerType.DOMAIN) {
            return this.createDomainCommandBuilder(jbossHome);
        }
        return this.createStandaloneCommandBuilder(jbossHome);
    }

    private CommandBuilder createStandaloneCommandBuilder(Path jbossHome) throws MojoExecutionException {
        Path javaHomePath;
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)jbossHome).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        if (this.serverConfig != null) {
            commandBuilder.setServerConfiguration(this.serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        Path path = javaHomePath = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        if (Environment.isModularJvm(javaHomePath)) {
            commandBuilder.addJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    private CommandBuilder createDomainCommandBuilder(Path jbossHome) throws MojoExecutionException {
        Path javaHome = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        DomainCommandBuilder commandBuilder = (DomainCommandBuilder)DomainCommandBuilder.of((Path)jbossHome, (Path)javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setProcessControllerJavaOptions(this.javaOpts).setHostControllerJavaOptions(this.javaOpts);
        }
        if (this.domainConfig != null) {
            commandBuilder.setDomainConfiguration(this.domainConfig);
        }
        if (this.hostConfig != null) {
            commandBuilder.setHostConfiguration(this.hostConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        if (Environment.isModularJvm(javaHome)) {
            commandBuilder.addHostControllerJavaOptions(Environment.getModularJvmArguments());
            commandBuilder.addProcessControllerJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getHostControllerJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    private Path provisionIfRequired(Path installDir) throws MojoFailureException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        try {
            if (!Files.exists(installDir, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Provisioning default WildFly server in " + installDir));
                GalleonUtils.provision((Path)installDir, (String)this.version, (MavenRepoManager)this.mavenRepoManager);
            }
            return installDir;
        }
        catch (ProvisioningException ex) {
            throw new MojoFailureException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void addUsers(Path wildflyHome, Path javaHome) throws IOException {
        if (this.addUser != null && this.addUser.hasUsers()) {
            this.getLog().info((CharSequence)("Adding users: " + this.addUser));
            this.addUser.addUsers(wildflyHome, javaHome);
        }
    }

    @Override
    public String goal() {
        return "start";
    }
}

