/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.UndeployDescription;
import org.wildfly.plugin.deployment.MojoDeploymentException;

@Mojo(name="undeploy-artifact", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class UndeployArtifactMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    private String groupId;
    @Parameter
    private String artifactId;
    @Parameter
    private String classifier;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="server-groups", property="wildfly.serverGroups")
    private List<String> serverGroups;
    @Parameter(defaultValue="true", property="undeploy.ignoreMissingDeployment")
    private boolean ignoreMissingDeployment;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DeploymentResult result;
        String deploymentName;
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping undeploy of artifact %s:%s", this.groupId, this.artifactId));
            return;
        }
        if (this.artifactId == null) {
            throw new MojoDeploymentException("undeploy-artifact must specify the artifactId");
        }
        if (this.groupId == null) {
            throw new MojoDeploymentException("undeploy-artifact must specify the groupId");
        }
        if (this.name == null) {
            Set dependencies = this.project.getDependencyArtifacts();
            Artifact artifact = null;
            for (Artifact a : dependencies) {
                if (!Objects.equals(a.getArtifactId(), this.artifactId) || !Objects.equals(a.getGroupId(), this.groupId) || !Objects.equals(a.getClassifier(), this.classifier)) continue;
                artifact = a;
                break;
            }
            if (artifact == null) {
                throw new MojoDeploymentException("Could not resolve artifact to deploy %s:%s", this.groupId, this.artifactId);
            }
            deploymentName = artifact.getFile().getName();
        } else {
            deploymentName = this.name;
        }
        try {
            ModelControllerClient client = this.createClient();
            Object object = null;
            try (MavenModelControllerClientConfiguration configuration = this.getClientConfiguration();){
                boolean failOnMissing = !this.ignoreMissingDeployment;
                DeploymentManager deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
                result = deploymentManager.undeploy(UndeployDescription.of((String)deploymentName).addServerGroups(this.getServerGroups()).setFailOnMissing(failOnMissing));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to execute %s goal.", this.goal()), (Throwable)e);
        }
        if (!result.successful()) {
            throw new MojoDeploymentException("Failed to undeploy %s. Reason: %s", deploymentName, result.getFailureMessage());
        }
    }

    @Override
    public String goal() {
        return "undeploy-artifact";
    }

    private Collection<String> getServerGroups() {
        return this.serverGroups == null ? Collections.emptyList() : this.serverGroups;
    }
}

