/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.repository;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.plugin.repository.ArtifactName;
import org.wildfly.plugin.repository.ArtifactResolver;

@Named
class EclipseAetherArtifactResolver
implements ArtifactResolver {
    @Inject
    private RepositorySystem repoSystem;

    EclipseAetherArtifactResolver() {
    }

    @Override
    public Path resolve(RepositorySystemSession session, List<RemoteRepository> repositories, ArtifactName name) {
        File artifactFile;
        ArtifactResult result;
        try {
            ArtifactRequest request = new ArtifactRequest();
            DefaultArtifact defaultArtifact = new DefaultArtifact(name.getGroupId(), name.getArtifactId(), name.getClassifier(), name.getPackaging(), name.getVersion());
            request.setArtifact((Artifact)defaultArtifact);
            request.setRepositories(repositories);
            result = this.repoSystem.resolveArtifact(session, request);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!result.isResolved()) {
            throw new RuntimeException("Failed to resolve artifact " + name);
        }
        Artifact artifact = result.getArtifact();
        if (artifact == null || (artifactFile = artifact.getFile()) == null) {
            throw new RuntimeException("Failed to resolve artifact " + name);
        }
        return artifactFile.toPath();
    }
}

