/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.licenses.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;

public class ProjectLicenseInfo {
    private String groupId;
    private String artifactId;
    private String version;
    private List<License> licenses = new ArrayList<License>();
    private String licenseResolutionResult;

    public String getLicenseResolutionResult() {
        return this.licenseResolutionResult;
    }

    public void setLicenseResolutionResult(String licenseResolutionResult) {
        this.licenseResolutionResult = licenseResolutionResult;
    }

    public ProjectLicenseInfo() {
    }

    public ProjectLicenseInfo(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public String getId() {
        return this.groupId + ":" + this.artifactId;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object compareTo) {
        ProjectLicenseInfo compare;
        if (compareTo instanceof ProjectLicenseInfo && this.groupId.equals((compare = (ProjectLicenseInfo)compareTo).getGroupId()) && this.artifactId.equals(compare.getArtifactId())) {
            return true;
        }
        return compareTo instanceof Artifact && this.groupId.equals((compare = (Artifact)compareTo).getGroupId()) && this.artifactId.equals(compare.getArtifactId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

