/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.licenses;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.util.Base64;
import org.wildfly.maven.plugins.licenses.DependenciesResolver;
import org.wildfly.maven.plugins.licenses.LicensesFileReader;
import org.wildfly.maven.plugins.licenses.LicensesFileWriter;
import org.wildfly.maven.plugins.licenses.MavenProjectDependenciesConfiguration;
import org.wildfly.maven.plugins.licenses.model.ProjectLicenseInfo;

@Mojo(name="insert-versions", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class UpdateLicensesMojo
extends AbstractMojo {
    private final LicensesFileWriter licensesFileWriter;
    private final LicensesFileReader licensesFileReader;
    @Parameter(property="license.skipDownloadLicenses", defaultValue="false")
    private boolean skipDownloadLicenses;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    private File licensesConfigFile;
    @Parameter(property="licensesConfigFiles")
    private List<File> licensesConfigFiles;
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    private File licensesOutputFile;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes", defaultValue="")
    private String includedScopes;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.includeOptionalDependencies", defaultValue="true")
    private boolean includeOptionalDependencies;
    @Parameter(property="license.includeSelfArtifact", defaultValue="false")
    private boolean includeSelfArtifact;
    @Parameter(defaultValue="${settings.proxies}", readonly=true)
    private List<Proxy> proxies;
    @Parameter(property="license.sortByGroupIdAndArtifactId", defaultValue="false")
    private boolean sortByGroupIdAndArtifactId;
    @Parameter(property="license.excludedGroups", defaultValue="")
    private String excludedGroups;
    @Parameter(property="license.includedGroups", defaultValue="")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts", defaultValue="")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts", defaultValue="")
    private String includedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Inject
    private DependenciesResolver dependenciesResolver;
    private Set<String> downloadedLicenseURLs = new HashSet<String>();
    private String proxyLoginPasswordEncoded;
    private Properties systemProperties;

    private void backupSystemProperties() {
        this.systemProperties = (Properties)System.getProperties().clone();
    }

    private void restoreSystemProperties() {
        if (this.systemProperties != null) {
            System.setProperties(this.systemProperties);
        }
    }

    protected UpdateLicensesMojo() {
        this.licensesFileWriter = new LicensesFileWriter();
        this.licensesFileReader = new LicensesFileReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skipDownloadLicenses) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return;
        }
        this.backupSystemProperties();
        try {
            this.initProxy();
            this.initDirectories();
            HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
            if (this.licensesOutputFile.exists()) {
                this.loadLicenseInfo(configuredDepLicensesMap, this.licensesOutputFile, true);
            }
            if (this.licensesConfigFile.exists()) {
                this.loadLicenseInfo(configuredDepLicensesMap, this.licensesConfigFile, false);
            }
            if (this.licensesConfigFiles != null) {
                for (File licCfgFile : this.licensesConfigFiles) {
                    if (!licCfgFile.exists()) continue;
                    this.loadLicenseInfo(configuredDepLicensesMap, licCfgFile, false);
                }
            }
            Collection<ProjectLicenseInfo> dependenciesLicenseInfos = this.getDependenciesLicenseInfos();
            List<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
            for (ProjectLicenseInfo dependencyLicenseInfo : dependenciesLicenseInfos) {
                ProjectLicenseInfo licenseInfo;
                this.getLog().debug((CharSequence)("Checking licenses for project " + dependencyLicenseInfo.toString()));
                String artifactProjectId = dependencyLicenseInfo.getId();
                if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                    licenseInfo = (ProjectLicenseInfo)configuredDepLicensesMap.get(artifactProjectId);
                    licenseInfo.setVersion(dependencyLicenseInfo.getVersion());
                } else {
                    licenseInfo = dependencyLicenseInfo;
                }
                depProjectLicenses.add(licenseInfo);
            }
            try {
                this.getLog().info((CharSequence)("Sort licenses " + this.sortByGroupIdAndArtifactId));
                if (this.sortByGroupIdAndArtifactId) {
                    depProjectLicenses = this.sortByGroupIdAndArtifactId(depProjectLicenses);
                }
                this.licensesFileWriter.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to write license summary file: " + this.licensesOutputFile, e);
            }
        }
        finally {
            this.restoreSystemProperties();
        }
    }

    private Collection<ProjectLicenseInfo> getDependenciesLicenseInfos() {
        MavenProjectDependenciesConfiguration configuration = new MavenProjectDependenciesConfiguration(this.includeTransitiveDependencies, this.includeOptionalDependencies, this.includeSelfArtifact, UpdateLicensesMojo.convertStringToList(this.includedScopes), UpdateLicensesMojo.convertStringToList(this.excludedScopes), this.includedArtifacts, this.includedGroups, this.excludedGroups, this.excludedArtifacts, this.isVerbose());
        SortedMap<String, ProjectLicenseInfo> set = this.dependenciesResolver.loadDependenciesAndConvertThem(this.project, configuration, this.localRepository, this.remoteRepositories, null, new Function<MavenProject, ProjectLicenseInfo>(){

            @Override
            public ProjectLicenseInfo apply(MavenProject project) {
                return UpdateLicensesMojo.this.createDependencyProject(project);
            }
        });
        return set.values();
    }

    private List<ProjectLicenseInfo> sortByGroupIdAndArtifactId(List<ProjectLicenseInfo> depProjectLicenses) {
        ArrayList<ProjectLicenseInfo> sorted = new ArrayList<ProjectLicenseInfo>(depProjectLicenses);
        Comparator<ProjectLicenseInfo> comparator = new Comparator<ProjectLicenseInfo>(){

            @Override
            public int compare(ProjectLicenseInfo info1, ProjectLicenseInfo info2) {
                return (info1.getGroupId() + "+" + info1.getArtifactId()).compareTo(info2.getGroupId() + "+" + info2.getArtifactId());
            }
        };
        Collections.sort(sorted, comparator);
        return sorted;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    public boolean isIncludeOptionalDependencies() {
        return this.includeOptionalDependencies;
    }

    public boolean isIncludeSelfArtifact() {
        return this.includeSelfArtifact;
    }

    private boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initProxy() throws MojoExecutionException {
        Proxy proxyToUse = null;
        for (Proxy proxy : this.proxies) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            proxyToUse = proxy;
            break;
        }
        if (proxyToUse != null) {
            System.getProperties().put("proxySet", "true");
            System.setProperty("proxyHost", proxyToUse.getHost());
            System.setProperty("proxyPort", String.valueOf(proxyToUse.getPort()));
            if (proxyToUse.getNonProxyHosts() != null) {
                System.setProperty("nonProxyHosts", proxyToUse.getNonProxyHosts());
            }
            if (proxyToUse.getUsername() != null) {
                String loginPassword = proxyToUse.getUsername() + ":" + proxyToUse.getPassword();
                this.proxyLoginPasswordEncoded = new String(Base64.encodeBase64((byte[])loginPassword.getBytes()));
            }
        }
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            this.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private boolean createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new IOException("Could not create directory " + dir);
            }
            return true;
        }
        return false;
    }

    private void loadLicenseInfo(Map<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        try (FileInputStream fis = new FileInputStream(licenseConfigFile);){
            List<ProjectLicenseInfo> licensesList = this.licensesFileReader.parseLicenseSummary(fis);
            for (ProjectLicenseInfo dep : licensesList) {
                configuredDepLicensesMap.put(dep.getId(), dep);
                if (!previouslyDownloaded) continue;
                for (License license : dep.getLicenses()) {
                    this.downloadedLicenseURLs.add(license.getUrl());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to parse license summary output file: " + licenseConfigFile, e);
        }
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (Object license : licenses) {
            dependencyProject.addLicense((License)license);
        }
        return dependencyProject;
    }

    static List<String> convertStringToList(String params) {
        String[] split = params == null ? new String[]{} : params.split(",");
        return Arrays.asList(split);
    }
}

