/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.ClazzpathUnit;
import org.vafer.jdependency.asm.DependenciesClassAdapter;

public final class Clazzpath {
    private final Set<ClazzpathUnit> units = new HashSet<ClazzpathUnit>();
    private final Map<String, Clazz> missing = new HashMap<String, Clazz>();
    private final Map<String, Clazz> clazzes = new HashMap<String, Clazz>();

    public boolean removeClazzpathUnit(ClazzpathUnit pUnit) {
        Set unitClazzes = pUnit.getClazzes();
        for (Clazz clazz : unitClazzes) {
            clazz.removeClazzpathUnit(pUnit);
            if (clazz.getClazzpathUnits().size() != 0) continue;
            this.clazzes.remove(clazz.toString());
        }
        return this.units.remove(pUnit);
    }

    public ClazzpathUnit addClazzpathUnit(InputStream pInputStream, String pId) throws IOException {
        JarEntry entry;
        HashMap<String, Clazz> unitClazzes = new HashMap<String, Clazz>();
        HashMap<String, Clazz> unitDependencies = new HashMap<String, Clazz>();
        ClazzpathUnit unit = new ClazzpathUnit(pId, unitClazzes, unitDependencies);
        JarInputStream inputStream = new JarInputStream(pInputStream);
        while ((entry = inputStream.getNextJarEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith(".class")) continue;
            String clazzName = entryName.substring(0, entryName.length() - 6).replace('/', '.');
            Clazz clazz = this.getClazz(clazzName);
            if (clazz == null) {
                clazz = this.missing.get(clazzName);
                clazz = clazz != null ? this.missing.remove(clazzName) : new Clazz(clazzName);
            }
            clazz.addClazzpathUnit(unit);
            this.clazzes.put(clazzName, clazz);
            unitClazzes.put(clazzName, clazz);
            DependenciesClassAdapter v = new DependenciesClassAdapter();
            new ClassReader((InputStream)inputStream).accept((ClassVisitor)v, 10);
            Set depNames = v.getDependencies();
            for (String depName : depNames) {
                Clazz dep = this.getClazz(depName);
                if (dep == null) {
                    dep = this.missing.get(depName);
                }
                if (dep == null) {
                    dep = new Clazz(depName);
                    dep.addClazzpathUnit(unit);
                    this.missing.put(depName, dep);
                }
                if (dep == clazz) continue;
                unitDependencies.put(depName, dep);
                clazz.addDependency(dep);
            }
        }
        this.units.add(unit);
        return unit;
    }

    public Set getClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            all.add(clazz);
        }
        return all;
    }

    public Set getClashedClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            if (clazz.getClazzpathUnits().size() <= 1) continue;
            all.add(clazz);
        }
        return all;
    }

    public Set getMissingClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.missing.values()) {
            all.add(clazz);
        }
        return all;
    }

    public Clazz getClazz(String pClazzName) {
        return this.clazzes.get(pClazzName);
    }

    public ClazzpathUnit[] getUnits() {
        return this.units.toArray(new ClazzpathUnit[this.units.size()]);
    }
}

