/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractDOMTransformer<F, T>
extends BaseTransformer<F, T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractDOMTransformer.class);
    private Logger _log = Logger.getLogger(((Object)((Object)this)).getClass());
    private static DocumentBuilderFactory _docBuilderFactory;
    private static TransformerFactory _transformerFactory;

    protected AbstractDOMTransformer() {
    }

    public Logger getLogger() {
        return this._log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputSource source) {
        DocumentBuilder docBuilder;
        try {
            docBuilder = _docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SwitchYardException("Unexpected DOM parser configuration exception.", (Throwable)e);
        }
        try {
            Document e = docBuilder.parse(source);
            return e;
        }
        catch (SAXException e) {
            throw new SwitchYardException("Error parsing DOM source.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException("Error reading DOM source.", (Throwable)e);
        }
        finally {
            InputStream stream = source.getByteStream();
            Reader reader = source.getCharacterStream();
            try {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Exception while closing DOM InputSource: " + e.getMessage()));
            }
        }
    }

    public static String serialize(Node node) {
        Transformer transformer;
        try {
            transformer = _transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new SwitchYardException("Unexpected exception creating JDK Transformer instance.", (Throwable)e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new SwitchYardException("Error serializing DOM node.", (Throwable)e);
        }
        return writer.toString();
    }

    static {
        _transformerFactory = TransformerFactory.newInstance();
        _docBuilderFactory = DocumentBuilderFactory.newInstance();
        _docBuilderFactory.setNamespaceAware(true);
        try {
            _transformerFactory.setAttribute("indent-number", 4);
        }
        catch (Exception e) {
            Logger.getLogger(AbstractDOMTransformer.class).debug((Object)"Failed to set indent on transformer.", (Throwable)e);
        }
    }
}

