/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.pull;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.switchyard.common.io.pull.Puller;

public class KeyStorePuller
extends Puller<KeyStore> {
    private final String _type;
    private final char[] _password;

    public KeyStorePuller() {
        this(null, null);
    }

    public KeyStorePuller(String type) {
        this(type, null);
    }

    public KeyStorePuller(char[] password) {
        this(null, password);
    }

    public KeyStorePuller(String type, char[] password) {
        this._type = type != null ? type : KeyStore.getDefaultType();
        this._password = password;
    }

    public KeyStore pull(InputStream stream) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance(this._type);
            keyStore.load(stream, this._password);
            return keyStore;
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
    }
}

