/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extractor;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.switchyard.common.codec.Base64;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PasswordCredential;
import org.switchyard.security.credential.extractor.CredentialExtractor;

public class AuthorizationHeaderCredentialExtractor
implements CredentialExtractor<String> {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationHeaderCredentialExtractor.class);
    private final Charset _charset;

    public AuthorizationHeaderCredentialExtractor() {
        this._charset = Charset.defaultCharset();
    }

    public AuthorizationHeaderCredentialExtractor(String charsetName) {
        if (charsetName != null) {
            Charset charset;
            try {
                charset = Charset.forName(charsetName);
            }
            catch (Throwable t) {
                LOGGER.error((Object)("charsetName [" + charsetName + "] + is illegal or unsupported; using platform-default"));
                charset = Charset.defaultCharset();
            }
            this._charset = charset;
        } else {
            LOGGER.warn((Object)"charsetName is null; using platform-default");
            this._charset = Charset.defaultCharset();
        }
    }

    public AuthorizationHeaderCredentialExtractor(Charset charset) {
        if (charset != null) {
            this._charset = charset;
        } else {
            LOGGER.warn((Object)"charset is null; using platform-default");
            this._charset = Charset.defaultCharset();
        }
    }

    @Override
    public Set<Credential> extract(String source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source != null) {
            if (source.startsWith("Basic ")) {
                String encoded = source.substring(6, source.length());
                String decoded = Base64.decodeToString((String)encoded, (Charset)this._charset);
                if (decoded.indexOf(58) != -1) {
                    String password;
                    String name;
                    String[] split = decoded.split(":", 2);
                    String string = name = split.length > 0 ? split[0] : null;
                    if (name != null) {
                        credentials.add(new NameCredential(name));
                    }
                    String string2 = password = split.length > 1 ? split[1] : null;
                    if (password != null) {
                        credentials.add(new PasswordCredential(password));
                    }
                }
            } else if (source.startsWith("Digest ")) {
                HashMap<String, String> map = new HashMap<String, String>();
                String everything = source.substring(6, source.length()).trim();
                List list = Strings.splitTrimToNull((String)everything, (String)",\n");
                for (String pair : list) {
                    String value;
                    String[] split = pair.split("=", 2);
                    String key = split.length > 0 ? split[0] : null;
                    String string = value = split.length > 1 ? split[1] : null;
                    if (key == null || value == null) continue;
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    map.put(key, value);
                }
                String username = (String)map.get("username");
                if (username != null) {
                    credentials.add(new NameCredential(username));
                }
            }
        }
        return credentials;
    }
}

