/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public class TransactionHandler
implements ExchangeHandler {
    private static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private static final String SUSPENDED_TRANSACTION_PROPERTY = "org.switchyard.exchange.transaction.suspended";
    private static final String INITIATED_TRANSACTION_PROPERTY = "org.switchyard.exchange.transaction.initiated";
    private static final String BEFORE_INVOKED_PROPERTY = "org.switchyard.exchange.transaction.beforeInvoked";
    private static Logger _log = Logger.getLogger(TransactionHandler.class);
    private TransactionManager _transactionManager;

    public TransactionHandler() {
        try {
            this._transactionManager = (TransactionManager)new InitialContext().lookup(JNDI_TRANSACTION_MANAGER);
        }
        catch (NamingException nmEx) {
            _log.debug((Object)"Unable to find TransactionManager in JNDI at java:jboss/TransactionManager - Transaction Policy handling will not be available.");
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (this._transactionManager == null) {
            return;
        }
        Property prop = exchange.getContext().getProperty(BEFORE_INVOKED_PROPERTY, Scope.EXCHANGE);
        if (prop != null && ((Boolean)Boolean.class.cast(prop.getValue())).booleanValue()) {
            this.handleAfter(exchange);
        } else {
            exchange.getContext().setProperty(BEFORE_INVOKED_PROPERTY, (Object)Boolean.TRUE, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            this.handleBefore(exchange);
        }
    }

    public void handleFault(Exchange exchange) {
        try {
            Transaction transaction;
            Property rollbackOnFaultProperty = exchange.getContext().getProperty("org.switchyard.rollbackOnFault");
            if (rollbackOnFaultProperty != null && rollbackOnFaultProperty.getValue() != null && ((Boolean)Boolean.class.cast(rollbackOnFaultProperty.getValue())).booleanValue() && (transaction = this.getCurrentTransaction()) != null) {
                transaction.setRollbackOnly();
            }
            this.handleAfter(exchange);
        }
        catch (Exception e) {
            _log.error((Object)e);
        }
    }

    void setTransactionManager(TransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    private void handleAfter(Exchange exchange) throws HandlerException {
        Transaction transaction = null;
        try {
            transaction = (Transaction)exchange.getContext().getPropertyValue(INITIATED_TRANSACTION_PROPERTY);
            if (transaction != null) {
                this.endTransaction();
            }
        }
        catch (Exception e) {
            throw new HandlerException("TransactionHandler failed to complete a transaction", (Throwable)e);
        }
        finally {
            transaction = (Transaction)exchange.getContext().getPropertyValue(SUSPENDED_TRANSACTION_PROPERTY);
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
    }

    private void handleBefore(Exchange exchange) throws HandlerException {
        if (!(this.propagatesRequired(exchange) || this.suspendsRequired(exchange) || this.managedGlobalRequired(exchange) || this.managedLocalRequired(exchange) || this.noManagedRequired(exchange))) {
            return;
        }
        this.evaluatePolicyCombination(exchange);
        this.evaluateTransactionStatus(exchange);
        if (this.isEligibleToSuspendTransaction(exchange)) {
            this.suspendTransaction(exchange);
        }
        if (this.isEligibleToStartTransaction(exchange)) {
            this.startTransaction(exchange);
        }
        this.provideRequiredPolicies(exchange);
    }

    private void evaluatePolicyCombination(Exchange exchange) throws HandlerException {
        if (this.suspendsRequired(exchange) && this.propagatesRequired(exchange)) {
            throw new HandlerException("Invalid transaction policy : " + TransactionPolicy.SUSPENDS_TRANSACTION + " and " + TransactionPolicy.PROPAGATES_TRANSACTION + " cannot be requested simultaneously.");
        }
        if (this.managedGlobalRequired(exchange) && this.managedLocalRequired(exchange) || this.managedGlobalRequired(exchange) && this.noManagedRequired(exchange) || this.managedLocalRequired(exchange) && this.noManagedRequired(exchange)) {
            throw new HandlerException("Invalid transaction policy : " + TransactionPolicy.MANAGED_TRANSACTION_GLOBAL + ", " + TransactionPolicy.MANAGED_TRANSACTION_LOCAL + " and " + TransactionPolicy.NO_MANAGED_TRANSACTION + " cannot be requested simultaneously with each other.");
        }
        if (this.propagatesRequired(exchange) && this.managedLocalRequired(exchange) || this.propagatesRequired(exchange) && this.noManagedRequired(exchange)) {
            throw new HandlerException("Invalid transaction policy : " + TransactionPolicy.PROPAGATES_TRANSACTION + " cannot be requested with " + TransactionPolicy.MANAGED_TRANSACTION_LOCAL + " nor " + TransactionPolicy.NO_MANAGED_TRANSACTION);
        }
    }

    private void evaluateTransactionStatus(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null && this.propagatesRequired(exchange) && !this.managedGlobalRequired(exchange)) {
            throw new HandlerException("Invalid transaction status : " + TransactionPolicy.PROPAGATES_TRANSACTION + " is required but the transaction doesn't exist");
        }
    }

    private boolean isEligibleToSuspendTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            return false;
        }
        return this.managedLocalRequired(exchange) || this.noManagedRequired(exchange) || this.suspendsRequired(exchange);
    }

    private boolean isEligibleToStartTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction = this.getCurrentTransaction();
        if (this.managedLocalRequired(exchange)) {
            return true;
        }
        return this.managedGlobalRequired(exchange) && transaction == null;
    }

    private void provideRequiredPolicies(Exchange exchange) {
        if (this.suspendsRequired(exchange)) {
            this.provideSuspends(exchange);
        } else if (this.propagatesRequired(exchange)) {
            this.providePropagates(exchange);
        }
        if (this.managedGlobalRequired(exchange)) {
            this.provideManagedGlobal(exchange);
        } else if (this.managedLocalRequired(exchange)) {
            this.provideManagedLocal(exchange);
        } else if (this.noManagedRequired(exchange)) {
            this.provideNoManaged(exchange);
        }
    }

    private boolean managedGlobalRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
    }

    private boolean managedLocalRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
    }

    private boolean noManagedRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
    }

    private boolean suspendsRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
    }

    private boolean propagatesRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private void providePropagates(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private void provideSuspends(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
    }

    private void provideManagedGlobal(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_GLOBAL);
    }

    private void provideManagedLocal(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.MANAGED_TRANSACTION_LOCAL);
    }

    private void provideNoManaged(Exchange exchange) {
        PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.NO_MANAGED_TRANSACTION);
    }

    private void startTransaction(Exchange exchange) throws HandlerException {
        Transaction transaction;
        int txStatus;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"creating new transaction");
        }
        if ((txStatus = this.getCurrentTransactionStatus()) == 6) {
            transaction = null;
            try {
                this._transactionManager.begin();
                transaction = this._transactionManager.getTransaction();
            }
            catch (Exception e) {
                throw new HandlerException("Failed to create new transaction", (Throwable)e);
            }
        } else {
            throw new HandlerException("Transaction already exists");
        }
        exchange.getContext().setProperty(INITIATED_TRANSACTION_PROPERTY, (Object)transaction, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
    }

    private void endTransaction() throws HandlerException {
        int txStatus;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"completing transaction");
        }
        if ((txStatus = this.getCurrentTransactionStatus()) == 1) {
            try {
                this._transactionManager.rollback();
            }
            catch (Exception e) {
                throw new HandlerException("Failed to rollback transaction", (Throwable)e);
            }
        } else if (txStatus == 0) {
            try {
                this._transactionManager.commit();
            }
            catch (Exception e) {
                throw new HandlerException("Failed to commit transaction", (Throwable)e);
            }
        } else {
            throw new HandlerException("Failed to complete transaction due to invalid status - code=" + txStatus + ": see javax.transaction.Status.");
        }
    }

    private void suspendTransaction(Exchange exchange) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Suspending active transaction for exchange.");
        }
        Transaction transaction = null;
        try {
            transaction = this._transactionManager.suspend();
        }
        catch (SystemException sysEx) {
            _log.error((Object)"Failed to suspend transaction on exchange.", (Throwable)sysEx);
        }
        if (transaction != null) {
            exchange.getContext().setProperty(SUSPENDED_TRANSACTION_PROPERTY, (Object)transaction, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Resuming suspended transaction");
            }
            this._transactionManager.resume(transaction);
        }
        catch (Exception ex) {
            _log.error((Object)"Failed to resume transaction after service invocation.", (Throwable)ex);
        }
    }

    private Transaction getCurrentTransaction() throws HandlerException {
        try {
            return this._transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw new HandlerException("Failed to retrieve transaction status", (Throwable)e);
        }
    }

    private int getCurrentTransactionStatus() throws HandlerException {
        try {
            return this._transactionManager.getStatus();
        }
        catch (Exception e) {
            throw new HandlerException("Failed to retrieve transaction status", (Throwable)e);
        }
    }
}

