/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.switchyard.common.type.CompoundClassLoader;

public final class Classes {
    private Classes() {
    }

    public static Class<?> forName(String name) {
        return Classes.forName(name, (ClassLoader)null);
    }

    public static Class<?> forName(String name, Class<?> caller) {
        return Classes.forName(name, caller != null ? caller.getClassLoader() : null);
    }

    public static Class<?> forName(String name, ClassLoader loader) {
        Class<?> c = null;
        List<ClassLoader> loaders = Classes.getClassLoaders(loader);
        for (ClassLoader cl : loaders) {
            try {
                c = Class.forName(name, true, cl);
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return c;
    }

    public static URL getResource(String path) throws IOException {
        return Classes.getResource(path, (ClassLoader)null);
    }

    public static URL getResource(String path, Class<?> caller) throws IOException {
        String callerPath;
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        URL url = Classes.getResource(path, loader);
        if (url == null && (callerPath = Classes.callerPath(path, caller)) != null) {
            url = Classes.getResource(callerPath, loader);
        }
        return url;
    }

    public static URL getResource(String path, ClassLoader loader) throws IOException {
        List<URL> urls = Classes.getResources(path, loader);
        return urls.size() > 0 ? urls.get(0) : null;
    }

    public static List<URL> getResources(String path) throws IOException {
        return Classes.getResources(path, (ClassLoader)null);
    }

    public static List<URL> getResources(String path, Class<?> caller) throws IOException {
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        List<URL> urls = Classes.getResources(path, loader);
        String callerPath = Classes.callerPath(path, caller);
        if (callerPath != null) {
            urls.addAll(Classes.getResources(callerPath, loader));
        }
        return urls;
    }

    public static List<URL> getResources(String path, ClassLoader loader) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (path != null) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (ClassLoader cl : Classes.getClassLoaders(loader)) {
                Enumeration<URL> e = cl.getResources(path);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (urls.contains(url)) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        return Classes.getResourceAsStream(path, (ClassLoader)null);
    }

    public static InputStream getResourceAsStream(String path, Class<?> caller) throws IOException {
        String callerPath;
        ClassLoader loader = caller != null ? caller.getClassLoader() : null;
        InputStream in = Classes.getResourceAsStream(path, loader);
        if (in == null && (callerPath = Classes.callerPath(path, caller)) != null) {
            in = Classes.getResourceAsStream(callerPath, loader);
        }
        return in;
    }

    public static InputStream getResourceAsStream(String path, ClassLoader loader) throws IOException {
        URL url = Classes.getResource(path, loader);
        return url != null ? url.openStream() : null;
    }

    public static ClassLoader getClassLoader() {
        return new CompoundClassLoader(Classes.getClassLoaders());
    }

    public static ClassLoader getClassLoader(Class<?> caller) {
        return new CompoundClassLoader(Classes.getClassLoaders(caller));
    }

    public static ClassLoader getClassLoader(ClassLoader loader) {
        return new CompoundClassLoader(Classes.getClassLoaders(loader));
    }

    public static List<ClassLoader> getClassLoaders() {
        return Classes.getClassLoaders((ClassLoader)null);
    }

    public static List<ClassLoader> getClassLoaders(Class<?> caller) {
        return Classes.getClassLoaders(caller != null ? caller.getClassLoader() : null);
    }

    public static List<ClassLoader> getClassLoaders(ClassLoader loader) {
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>(6, 1.0f);
        ClassLoader cl = Classes.getTCCL();
        if (cl != null) {
            loaders.add(cl);
        }
        if (loader != null) {
            loaders.add(loader);
        }
        if ((cl = Classes.class.getClassLoader()) != null) {
            loaders.add(cl);
        }
        if ((cl = ClassLoader.getSystemClassLoader()) != null) {
            loaders.add(cl);
        }
        if ((cl = Class.class.getClassLoader()) != null) {
            loaders.add(cl);
        }
        return new ArrayList<ClassLoader>(loaders);
    }

    public static ClassLoader getTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader setTCCL(ClassLoader replacement) {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(replacement);
        return previous;
    }

    private static String callerPath(String path, Class<?> caller) {
        String pkg;
        String callerPath = null;
        if (path != null && caller != null && !path.contains(pkg = caller.getPackage().getName().replace('.', '/'))) {
            callerPath = pkg + "/" + path;
        }
        return callerPath;
    }
}

