/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.pull;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.switchyard.common.io.pull.Puller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ElementPuller
extends Puller<Element> {
    private final boolean _ignoringComments;

    public ElementPuller() {
        this._ignoringComments = true;
    }

    public ElementPuller(boolean ignoringComments) {
        this._ignoringComments = ignoringComments;
    }

    @Override
    public Element pull(InputStream stream) throws IOException {
        return this.pull(new InputSource(stream));
    }

    public Element pull(Reader reader) throws IOException {
        return this.pull(new InputSource(reader));
    }

    public Element pull(InputSource source) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(this._ignoringComments);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            return this.pull(factory.newDocumentBuilder().parse(source));
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException se) {
            throw new IOException(se);
        }
    }

    public Element pull(Document document) {
        return this.pull(document, true);
    }

    public Element pull(Document document, boolean normalize) {
        if (normalize) {
            document.normalizeDocument();
        }
        return this.pull(document.getDocumentElement(), normalize);
    }

    public Element pull(Element element) {
        return this.pull(element, true);
    }

    public Element pull(Element element, boolean normalize) {
        if (normalize) {
            element.normalize();
        }
        return element;
    }

    public Element pull(QName qname) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        String prefix = qname.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            sb.append(prefix);
            sb.append(':');
        }
        sb.append(qname.getLocalPart());
        String namespace = qname.getNamespaceURI();
        if (namespace != null && namespace.length() > 0) {
            sb.append(" xmlns");
            if (prefix != null && prefix.length() > 0) {
                sb.append(':');
                sb.append(prefix);
            }
            sb.append("=\"");
            sb.append(namespace);
            sb.append('\"');
        }
        sb.append("/>");
        try {
            return this.pull(new StringReader(sb.toString()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

