/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.classpath;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.InstanceOfFilter;

public abstract class AbstractTypeFilter
implements Filter {
    private Logger _logger;
    private List<Class<?>> _classes = new ArrayList();

    protected AbstractTypeFilter() {
        this._logger = Logger.getLogger(this.getClass());
    }

    @Override
    public boolean continueScanning() {
        return true;
    }

    public abstract boolean matches(Class<?> var1);

    public List<Class<?>> getMatchedTypes() {
        return this._classes;
    }

    public void clear() {
        this._classes.clear();
    }

    @Override
    public void filter(String resourceName) {
        if (resourceName.endsWith(".class")) {
            String className = this.toClassName(resourceName);
            try {
                Class<?> clazz = Classes.forName(className, this.getClass());
                if (this.matches(clazz)) {
                    this._classes.add(clazz);
                }
            }
            catch (Throwable throwable) {
                this._logger.debug((Object)("Resource '" + resourceName + "' presented to '" + InstanceOfFilter.class.getName() + "', but not loadable by classloader.  Ignoring."), throwable);
            }
        }
    }

    private String toClassName(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (resourceName.endsWith(".class")) {
            resourceName = resourceName.substring(0, resourceName.length() - ".class".length());
        }
        resourceName = resourceName.replace('/', '.');
        return resourceName;
    }
}

