/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

public class CompoundClassLoader
extends ClassLoader {
    private Collection<ClassLoader> _loaders;

    public CompoundClassLoader(ClassLoader ... loaders) {
        this._loaders = Arrays.asList(loaders);
    }

    public CompoundClassLoader(Collection<ClassLoader> loaders) {
        this._loaders = loaders;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this._loaders) {
            URL resource;
            if (loader == null || (resource = loader.getResource(name)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader loader : this._loaders) {
            InputStream is;
            if (loader == null || (is = loader.getResourceAsStream(name)) == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader loader : this._loaders) {
            if (loader == null) continue;
            try {
                Enumeration<URL> resources = loader.getResources(name);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (resource == null || urls.contains(resource)) continue;
                    urls.add(resource);
                }
            }
            catch (IOException ioe) {
                ioe.getMessage();
            }
        }
        return Collections.enumeration(urls);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this._loaders) {
            if (loader == null) continue;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.getMessage();
            }
        }
        throw new ClassNotFoundException();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name);
    }
}

