/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.label;

import org.switchyard.common.lang.Strings;

public interface Label {
    public String name();

    public String label();

    public static class Util {
        private static final String PREFIX = "org.switchyard.label.";

        public static final String toSwitchYardLabel(String labelType, String name) {
            labelType = labelType.trim().toLowerCase();
            name = name.trim().toLowerCase();
            return PREFIX + labelType + '.' + name;
        }

        public static final <T extends Enum<T>> T ofName(Class<T> enumType, String name) {
            if ((name = Strings.trimToNull((String)name)) != null) {
                name = name.toUpperCase();
                try {
                    return Enum.valueOf(enumType, name);
                }
                catch (IllegalArgumentException iae) {
                    return null;
                }
            }
            return null;
        }

        public static final void print(Label ... labels) {
            for (Label label : labels) {
                System.out.println(String.format("%s: %s = %s", label.getClass().getName(), label.name(), label.label()));
            }
        }
    }
}

