/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class DefaultSOAP11ExceptionTransformer<F extends Exception, T extends SOAPMessage>
extends BaseTransformer<F, T> {
    public QName getFrom() {
        return DefaultSOAP11ExceptionTransformer.toMessageType(Exception.class);
    }

    public QName getTo() {
        return SOAPUtil.SOAP11_FAULT_MESSAGE_TYPE;
    }

    public SOAPMessage transform(Exception from) {
        try {
            Throwable cause = from.getCause();
            if (cause instanceof InvocationTargetException) {
                return SOAPUtil.generateSOAP11Fault(cause.getCause());
            }
            return SOAPUtil.generateSOAP11Fault(from);
        }
        catch (SOAPException e1) {
            throw new IllegalStateException("Unexpected SOAPException when generating a SOAP 1.1 Fault message.", from);
        }
    }
}

