/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.composer.BaseContextMapper;

public class SOAPContextMapper
extends BaseContextMapper<SOAPMessage> {
    public void mapFrom(SOAPMessage source, Context context) throws Exception {
        Iterator mimeHeaders = source.getMimeHeaders().getAllHeaders();
        while (mimeHeaders.hasNext()) {
            String value;
            MimeHeader mimeHeader = (MimeHeader)mimeHeaders.next();
            String name = mimeHeader.getName();
            if (!this.matches(name) || (value = mimeHeader.getValue()) == null) continue;
            context.setProperty(name, (Object)value, Scope.IN);
        }
        Iterator soapHeaders = source.getSOAPHeader().examineAllHeaderElements();
        while (soapHeaders.hasNext()) {
            String value;
            SOAPHeaderElement soapHeader = (SOAPHeaderElement)soapHeaders.next();
            QName qname = soapHeader.getElementQName();
            if (!this.matches(qname) || (value = soapHeader.getValue()) == null) continue;
            context.setProperty(qname.toString(), (Object)value, Scope.EXCHANGE);
        }
    }

    public void mapTo(Context context, SOAPMessage target) throws Exception {
        MimeHeaders mimeHeaders = target.getMimeHeaders();
        for (Property property : context.getProperties(Scope.OUT)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            mimeHeaders.addHeader(name, String.valueOf(value));
        }
        SOAPHeader soapHeader = target.getSOAPHeader();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            Object value;
            String name = property.getName();
            QName qname = XMLHelper.createQName((String)name);
            boolean qualifiedForSoapHeader = Strings.trimToNull((String)qname.getNamespaceURI()) != null;
            if (!qualifiedForSoapHeader || !this.matches(qname) || (value = property.getValue()) == null) continue;
            soapHeader.addChildElement(qname).setValue(String.valueOf(value));
        }
    }
}

