/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.deploy;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.component.hornetq.composer.HornetQComposition;
import org.switchyard.component.hornetq.config.model.HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.config.model.OperationSelector;
import org.switchyard.component.hornetq.internal.HornetQUtil;
import org.switchyard.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.ServiceOperation;

public class InboundHandler
implements ExchangeHandler,
MessageHandler {
    private Logger _logger = Logger.getLogger(InboundHandler.class);
    private final HornetQBindingModel _bindingModel;
    private final HornetQConfigModel _configModel;
    private final MessageComposer<ClientMessage> _messageComposer;
    private ServiceReference _serviceRef;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _factory;
    private ClientSession _session;
    private ClientConsumer _consumer;

    public InboundHandler(HornetQBindingModel hbm, ServerLocator serverLocator) {
        this._bindingModel = hbm;
        this._configModel = hbm.getHornetQConfig();
        this._messageComposer = HornetQComposition.getMessageComposer(hbm);
        this._serverLocator = serverLocator;
    }

    public void start(ServiceReference serviceRef) {
        this._serviceRef = serviceRef;
        try {
            this._factory = this._serverLocator.createSessionFactory();
            this._session = this._configModel.isXASession() ? this._factory.createXASession() : this._factory.createSession();
            this._consumer = this._session.createConsumer(this._configModel.getQueue());
            this._consumer.setMessageHandler((MessageHandler)this);
            this._session.start();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void stop(ServiceReference serviceRef) {
        HornetQUtil.closeClientConsumer(this._consumer);
        HornetQUtil.closeSession(this._session);
        HornetQUtil.closeSessionFactory(this._factory);
        HornetQUtil.closeServerLocator(this._serverLocator);
    }

    public void onMessage(ClientMessage message) {
        Exchange exchange = this.createExchange(this._serviceRef);
        try {
            this._logger.info((Object)("onMessage :" + message));
            exchange.send(this._messageComposer.compose((Object)message, exchange, true));
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private Exchange createExchange(ServiceReference serviceReference) {
        String operationName = this.getOperationName();
        QName inputType = this.getOperationInputType(serviceReference, operationName);
        InOnlyOperation inOnlyOperation = new InOnlyOperation(operationName, inputType);
        BaseExchangeContract contract = new BaseExchangeContract((ServiceOperation)inOnlyOperation);
        return serviceReference.createExchange((ExchangeContract)contract);
    }

    private String getOperationName() {
        OperationSelector operationSelector = this._bindingModel.getOperationSelector();
        if (operationSelector != null) {
            return operationSelector.getOperationName();
        }
        return null;
    }

    private QName getOperationInputType(ServiceReference ref, String operationName) {
        ServiceOperation operation = ref.getInterface().getOperation(operationName);
        if (operation != null) {
            return operation.getInputType();
        }
        throw new SwitchYardException("The operationName [" + operationName + "] was not found on the" + " in the set of operations of the interface " + ref.getInterface().getOperations() + ". Please check that the 'operationName' attribute specified in the HornetQ binding " + " matches an operation on the interface.");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
    }

    public void handleFault(Exchange exchange) {
    }
}

