/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.client.impl.ServerLocatorImpl;

public class ServerLocatorBuilder {
    private boolean _useHA;
    private DiscoveryGroupConfiguration _discoveryGroupConf;
    private TransportConfiguration[] _transportConfigs;
    private Boolean _disableFinalizedCheck = true;
    private Long _clientFailureCheckPeriod;
    private Boolean _cacheLargeMessagesOnConsumers;
    private Long _connectionTTL;
    private Long _callTimeout;
    private Integer _minLargeMessageSize;
    private Integer _consumerWindowSize;
    private Integer _consumerMaxRate;
    private Integer _confirmationWindowSize;
    private Integer _producerWindowSize;
    private Integer _producerMaxRate;
    private Boolean _blockOnAcknowledge;
    private Boolean _blockOnDurableSend;
    private Boolean _blockOnNonDurableSend;
    private Boolean _autoGroup;
    private String _groupID;
    private Boolean _preAcknowledge;
    private Integer _ackBatchSize;
    private Boolean _useGlobalPools;
    private Integer _scheduledThreadPoolMaxSize;
    private Integer _threadPoolMaxSize;
    private Long _retryInterval;
    private Double _retryIntervalMultiplier;
    private Long _maxRetryInterval;
    private Integer _reconnectAttempts;
    private Integer _initialConnectAttempts;
    private Boolean _failoverOnInitialConnection;
    private String _connectionLoadBalancingPolicyClassName;
    private Integer _initialMessagePacketSize;
    private List<Interceptor> _interceptors = new ArrayList<Interceptor>();
    private Boolean _compressLargeMessage;
    private List<ClusterTopologyListener> _clusterListeners = new ArrayList<ClusterTopologyListener>();

    public ServerLocatorBuilder discoveryGroupConfiguration(DiscoveryGroupConfiguration discoveryGroupConf) {
        this._discoveryGroupConf = discoveryGroupConf;
        return this;
    }

    public ServerLocatorBuilder transportConfigurations(TransportConfiguration ... configs) {
        this._transportConfigs = configs;
        return this;
    }

    public ServerLocatorBuilder useHA(Boolean useHA) {
        this._useHA = useHA == null ? false : useHA;
        return this;
    }

    public ServerLocatorBuilder disableFinalizedCheck(Boolean disable) {
        this._disableFinalizedCheck = disable;
        return this;
    }

    public ServerLocatorBuilder clientFailureCheckPeriod(Long period) {
        this._clientFailureCheckPeriod = period;
        return this;
    }

    public ServerLocatorBuilder cacheLargeMessagesOnConsumers(Boolean cache) {
        this._cacheLargeMessagesOnConsumers = cache;
        return this;
    }

    public ServerLocatorBuilder connectionTTL(Long connectionTTL) {
        this._connectionTTL = connectionTTL;
        return this;
    }

    public ServerLocatorBuilder callTimeout(Long callTimeout) {
        this._callTimeout = callTimeout;
        return this;
    }

    public ServerLocatorBuilder minLargeMessageSize(Integer size) {
        this._minLargeMessageSize = size;
        return this;
    }

    public ServerLocatorBuilder consumerWindowSize(Integer size) {
        this._consumerWindowSize = size;
        return this;
    }

    public ServerLocatorBuilder consumerMaxRate(Integer rate) {
        this._consumerMaxRate = rate;
        return this;
    }

    public ServerLocatorBuilder confirmationWindowSize(Integer size) {
        this._confirmationWindowSize = size;
        return this;
    }

    public ServerLocatorBuilder producerWindowSize(Integer size) {
        this._producerWindowSize = size;
        return this;
    }

    public ServerLocatorBuilder producerMaxRate(Integer rate) {
        this._producerMaxRate = rate;
        return this;
    }

    public ServerLocatorBuilder blockOnAcknowledge(Boolean block) {
        this._blockOnAcknowledge = block;
        return this;
    }

    public ServerLocatorBuilder blockOnDurableSend(Boolean block) {
        this._blockOnDurableSend = block;
        return this;
    }

    public ServerLocatorBuilder blockOnNonDurableSend(Boolean block) {
        this._blockOnNonDurableSend = block;
        return this;
    }

    public ServerLocatorBuilder autoGroup(Boolean autoGroup) {
        this._autoGroup = autoGroup;
        return this;
    }

    public ServerLocatorBuilder groupID(String id) {
        this._groupID = id;
        return this;
    }

    public ServerLocatorBuilder preAcknowledge(Boolean preAck) {
        this._preAcknowledge = preAck;
        return this;
    }

    public ServerLocatorBuilder ackBatchSize(Integer size) {
        this._ackBatchSize = size;
        return this;
    }

    public ServerLocatorBuilder useGlobalPools(Boolean useGlobalPools) {
        this._useGlobalPools = useGlobalPools;
        return this;
    }

    public ServerLocatorBuilder scheduledThreadPoolMaxSize(Integer size) {
        this._scheduledThreadPoolMaxSize = size;
        return this;
    }

    public ServerLocatorBuilder threadPoolMaxSize(Integer size) {
        this._threadPoolMaxSize = size;
        return this;
    }

    public ServerLocatorBuilder retryInterval(Long interval) {
        this._retryInterval = interval;
        return this;
    }

    public ServerLocatorBuilder retryIntervalMultiplier(Double multiplier) {
        this._retryIntervalMultiplier = multiplier;
        return this;
    }

    public ServerLocatorBuilder maxRetryInterval(Long max) {
        this._maxRetryInterval = max;
        return this;
    }

    public ServerLocatorBuilder reconnectAttempts(Integer attempts) {
        this._reconnectAttempts = attempts;
        return this;
    }

    public ServerLocatorBuilder initialReconnectAttempts(Integer attempts) {
        this._initialConnectAttempts = attempts;
        return this;
    }

    public ServerLocatorBuilder failoverOnInitialConnection(Boolean failover) {
        this._failoverOnInitialConnection = failover;
        return this;
    }

    public ServerLocatorBuilder connectionLoadBalancingPolicyClassName(String className) {
        this._connectionLoadBalancingPolicyClassName = className;
        return this;
    }

    public ServerLocatorBuilder initialMessagePacketSize(Integer packetSize) {
        this._initialMessagePacketSize = packetSize;
        return this;
    }

    public ServerLocatorBuilder addInterceptors(Interceptor ... interceptors) {
        this._interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public ServerLocatorBuilder compressLargeMessage(Boolean compress) {
        this._compressLargeMessage = compress;
        return this;
    }

    public ServerLocatorBuilder addClusterTopologyListener(ClusterTopologyListener ... listeners) {
        this._clusterListeners.addAll(Arrays.asList(listeners));
        return this;
    }

    public ServerLocator build() {
        ServerLocatorImpl serverLocator;
        if (this._discoveryGroupConf != null) {
            serverLocator = new ServerLocatorImpl(this._useHA, this._discoveryGroupConf);
        } else if (this._transportConfigs != null) {
            serverLocator = new ServerLocatorImpl(this._useHA, this._transportConfigs);
        } else {
            throw new IllegalArgumentException("To bulid a ServerLocator you must configure either a discoverygroup, which will use UDP broadcast to discover the servers, or configure a static transport configuration.This can be done by calling builder.discoveryGroup() or builder.transportConfigurations()");
        }
        if (this._disableFinalizedCheck != null && this._disableFinalizedCheck.booleanValue()) {
            serverLocator.disableFinalizeCheck();
        }
        if (this._clientFailureCheckPeriod != null) {
            serverLocator.setClientFailureCheckPeriod(this._clientFailureCheckPeriod.longValue());
        }
        if (this._cacheLargeMessagesOnConsumers != null) {
            serverLocator.setCacheLargeMessagesClient(this._cacheLargeMessagesOnConsumers.booleanValue());
        }
        if (this._connectionTTL != null) {
            serverLocator.setConnectionTTL(this._connectionTTL.longValue());
        }
        if (this._callTimeout != null) {
            serverLocator.setCallTimeout(this._callTimeout.longValue());
        }
        if (this._minLargeMessageSize != null) {
            serverLocator.setMinLargeMessageSize(this._minLargeMessageSize.intValue());
        }
        if (this._consumerWindowSize != null) {
            serverLocator.setConsumerWindowSize(this._consumerWindowSize.intValue());
        }
        if (this._consumerMaxRate != null) {
            serverLocator.setConsumerMaxRate(this._consumerMaxRate.intValue());
        }
        if (this._confirmationWindowSize != null) {
            serverLocator.setConfirmationWindowSize(this._confirmationWindowSize.intValue());
        }
        if (this._producerWindowSize != null) {
            serverLocator.setProducerWindowSize(this._producerWindowSize.intValue());
        }
        if (this._producerMaxRate != null) {
            serverLocator.setProducerMaxRate(this._producerMaxRate.intValue());
        }
        if (this._blockOnAcknowledge != null) {
            serverLocator.setBlockOnAcknowledge(this._blockOnAcknowledge.booleanValue());
        }
        if (this._blockOnDurableSend != null) {
            serverLocator.setBlockOnDurableSend(this._blockOnDurableSend.booleanValue());
        }
        if (this._blockOnNonDurableSend != null) {
            serverLocator.setBlockOnNonDurableSend(this._blockOnNonDurableSend.booleanValue());
        }
        if (this._autoGroup != null) {
            serverLocator.setAutoGroup(this._autoGroup.booleanValue());
        }
        if (this._groupID != null) {
            serverLocator.setGroupID(this._groupID);
        }
        if (this._preAcknowledge != null) {
            serverLocator.setPreAcknowledge(this._preAcknowledge.booleanValue());
        }
        if (this._ackBatchSize != null) {
            serverLocator.setAckBatchSize(this._ackBatchSize.intValue());
        }
        if (this._useGlobalPools != null) {
            serverLocator.setUseGlobalPools(this._useGlobalPools.booleanValue());
        }
        if (this._scheduledThreadPoolMaxSize != null) {
            this.checkUseGlobalsIsTrue("scheduledThreadPoolMaxSize");
            serverLocator.setScheduledThreadPoolMaxSize(this._scheduledThreadPoolMaxSize.intValue());
        }
        if (this._threadPoolMaxSize != null) {
            this.checkUseGlobalsIsTrue("threadPoolMaxSize");
            serverLocator.setThreadPoolMaxSize(this._threadPoolMaxSize.intValue());
        }
        if (this._retryInterval != null) {
            serverLocator.setRetryInterval(this._retryInterval.longValue());
        }
        if (this._retryIntervalMultiplier != null) {
            serverLocator.setRetryIntervalMultiplier(this._retryIntervalMultiplier.doubleValue());
        }
        if (this._maxRetryInterval != null) {
            serverLocator.setMaxRetryInterval(this._maxRetryInterval.longValue());
        }
        if (this._reconnectAttempts != null) {
            serverLocator.setReconnectAttempts(this._reconnectAttempts.intValue());
        }
        if (this._initialConnectAttempts != null) {
            serverLocator.setInitialConnectAttempts(this._initialConnectAttempts.intValue());
        }
        if (this._failoverOnInitialConnection != null) {
            serverLocator.setFailoverOnInitialConnection(this._failoverOnInitialConnection.booleanValue());
        }
        if (this._connectionLoadBalancingPolicyClassName != null) {
            serverLocator.setConnectionLoadBalancingPolicyClassName(this._connectionLoadBalancingPolicyClassName);
        }
        if (this._initialMessagePacketSize != null) {
            serverLocator.setInitialMessagePacketSize(this._initialMessagePacketSize.intValue());
        }
        for (Interceptor interceptor : this._interceptors) {
            serverLocator.addInterceptor(interceptor);
        }
        if (this._compressLargeMessage != null) {
            serverLocator.setCompressLargeMessage(this._compressLargeMessage.booleanValue());
        }
        for (ClusterTopologyListener listener : this._clusterListeners) {
            serverLocator.addClusterTopologyListener(listener);
        }
        return serverLocator;
    }

    private void checkUseGlobalsIsTrue(String propertyName) throws IllegalArgumentException {
        if (this._useGlobalPools == null || this._useGlobalPools.booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Configuring '").append(propertyName);
            sb.append("' does not make sense when 'useGlobalPools' is set to true (default).");
            sb.append("'").append(propertyName).append("' property controls the non-global pool size");
            sb.append("for this ServerLocator. If you want for this ServerLocator to have its own then ");
            sb.append("set 'useGlobalPools' to false");
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

